/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class InitialQuestionsStep
extends AbstractProcessingStep {
    public static final int STATUS_VERIFY_PRUNE = 1;
    public static final int STATUS_CANCEL_PRUNE = 2;
    public static final int STATUS_THESIS_REJECTED = 3;
    protected boolean willRemoveTitles = false;
    protected boolean willRemoveDate = false;
    protected boolean willRemoveFiles = false;

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        Metadatum[] dateIssued;
        boolean isThesis;
        boolean multipleTitles = Util.getBoolParameter(request, "multiple_titles");
        boolean publishedBefore = Util.getBoolParameter(request, "published_before");
        boolean multipleFiles = Util.getBoolParameter(request, "multiple_files");
        boolean bl = isThesis = ConfigurationManager.getBooleanProperty("webui.submit.blocktheses") && Util.getBoolParameter(request, "is_thesis");
        if (subInfo.isInWorkflow()) {
            isThesis = false;
            multipleFiles = true;
        }
        if (isThesis) {
            WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
            wi.deleteAll();
            subInfo.setSubmissionItem(null);
            request.getSession().setAttribute("removed_thesis", (Object)Boolean.TRUE);
            return 3;
        }
        if (request.getParameter("do_not_prune") != null) {
            return 2;
        }
        if (request.getParameter("prune") != null) {
            this.processVerifyPrune(context, request, response, subInfo, multipleTitles, publishedBefore, multipleFiles);
        } else {
            if (subInfo.getSubmissionItem() != null) {
                Bundle[] bundles;
                if (!multipleTitles) {
                    Metadatum[] altTitles = subInfo.getSubmissionItem().getItem().getDC("title", "alternative", "*");
                    boolean bl2 = this.willRemoveTitles = altTitles.length > 0;
                }
                if (!publishedBefore) {
                    dateIssued = subInfo.getSubmissionItem().getItem().getDC("date", "issued", "*");
                    Metadatum[] citation = subInfo.getSubmissionItem().getItem().getDC("identifier", "citation", "*");
                    Metadatum[] publisher = subInfo.getSubmissionItem().getItem().getDC("publisher", null, "*");
                    boolean bl3 = this.willRemoveDate = dateIssued.length > 0 || citation.length > 0 || publisher.length > 0;
                }
                if (!multipleFiles && (bundles = subInfo.getSubmissionItem().getItem().getBundles("ORIGINAL")).length > 0) {
                    Bitstream[] bitstreams = bundles[0].getBitstreams();
                    boolean bl4 = this.willRemoveFiles = bitstreams.length > 1;
                }
            }
            if (this.willRemoveTitles || this.willRemoveDate || this.willRemoveFiles) {
                request.setAttribute("will.remove.titles", (Object)this.willRemoveTitles);
                request.setAttribute("will.remove.date", (Object)this.willRemoveDate);
                request.setAttribute("will.remove.files", (Object)this.willRemoveFiles);
                return 1;
            }
        }
        subInfo.getSubmissionItem().setMultipleTitles(multipleTitles);
        subInfo.getSubmissionItem().setPublishedBefore(publishedBefore);
        if (!subInfo.isInWorkflow()) {
            subInfo.getSubmissionItem().setMultipleFiles(multipleFiles);
        }
        if (!publishedBefore && (dateIssued = subInfo.getSubmissionItem().getItem().getDC("date", "issued", "*")).length == 0) {
            subInfo.getSubmissionItem().getItem().addDC("date", "issued", null, "today");
        }
        subInfo.getSubmissionItem().update();
        context.commit();
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }

    protected void processVerifyPrune(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean multipleTitles, boolean publishedBefore, boolean multipleFiles) throws ServletException, IOException, SQLException, AuthorizeException {
        Bundle[] bundles;
        Item item = subInfo.getSubmissionItem().getItem();
        if (!multipleTitles && subInfo.getSubmissionItem().hasMultipleTitles()) {
            item.clearDC("title", "alternative", "*");
        }
        if (!publishedBefore && subInfo.getSubmissionItem().isPublishedBefore()) {
            item.clearDC("date", "issued", "*");
            item.clearDC("identifier", "citation", "*");
            item.clearDC("publisher", null, "*");
        }
        if (!multipleFiles && subInfo.getSubmissionItem().hasMultipleFiles() && (bundles = item.getBundles("ORIGINAL")).length > 0) {
            Bitstream[] bitstreams = bundles[0].getBitstreams();
            for (int i = 1; i < bitstreams.length; ++i) {
                bundles[0].removeBitstream(bitstreams[i]);
            }
        }
    }
}

