/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.util;

import gr.ekt.bte.core.MutableRecord;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SubmissionLookupPublication
implements MutableRecord,
Serializable {
    private String providerName;
    private Map<String, List<String>> storage = new HashMap<String, List<String>>();

    public SubmissionLookupPublication(String providerName) {
        this.providerName = providerName;
    }

    public Map<String, List<String>> getStorage() {
        return this.storage;
    }

    public Set<String> getFields() {
        return this.storage.keySet();
    }

    public List<String> remove(String md) {
        return this.storage.remove(md);
    }

    public void add(String md, String nValue) {
        if (StringUtils.isNotBlank((String)nValue)) {
            List<String> tmp = this.storage.get(md);
            if (tmp == null) {
                tmp = new ArrayList<String>();
                this.storage.put(md, tmp);
            }
            tmp.add(nValue);
        }
    }

    public String getFirstValue(String md) {
        List<String> tmp = this.storage.get(md);
        if (tmp == null || tmp.size() == 0) {
            return null;
        }
        return tmp.get(0);
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getType() {
        return this.getFirstValue("type");
    }

    public boolean hasField(String md) {
        return this.storage.containsKey(md);
    }

    public List<Value> getValues(String md) {
        List<String> stringValues = this.storage.get(md);
        if (stringValues == null) {
            return null;
        }
        ArrayList<Value> values = new ArrayList<Value>();
        for (String value : stringValues) {
            values.add((Value)new StringValue(value));
        }
        return values;
    }

    public boolean isMutable() {
        return true;
    }

    public MutableRecord makeMutable() {
        return this;
    }

    public boolean addField(String md, List<Value> values) {
        if (this.storage.containsKey(md)) {
            List<String> stringValues = this.storage.get(md);
            if (values != null) {
                for (Value value : values) {
                    stringValues.add(value.getAsString());
                }
            }
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            if (values != null) {
                for (Value value : values) {
                    tmp.add(value.getAsString());
                }
            }
            this.storage.put(md, tmp);
        }
        return true;
    }

    public boolean addValue(String md, Value value) {
        if (this.storage.containsKey(md)) {
            List<String> stringValues = this.storage.get(md);
            stringValues.add(value.getAsString());
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(value.getAsString());
            this.storage.put(md, tmp);
        }
        return true;
    }

    public boolean removeField(String md) {
        if (this.storage.containsKey(md)) {
            this.storage.remove(md);
        }
        return false;
    }

    public boolean removeValue(String md, Value value) {
        if (this.storage.containsKey(md)) {
            List<String> stringValues = this.storage.get(md);
            stringValues.remove(value.getAsString());
        }
        return true;
    }

    public boolean updateField(String md, List<Value> values) {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Value value : values) {
            stringValues.add(value.getAsString());
        }
        this.storage.put(md, stringValues);
        return true;
    }

    public boolean updateValue(String md, Value valueOld, Value valueNew) {
        if (this.storage.containsKey(md)) {
            List<String> stringValues = this.storage.get(md);
            List<String> newStringValues = this.storage.get(md);
            for (String s : stringValues) {
                if (s.equals(valueOld.getAsString())) {
                    newStringValues.add(valueNew.getAsString());
                    continue;
                }
                newStringValues.add(s);
            }
            this.storage.put(md, newStringValues);
        }
        return true;
    }
}

