/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.Site;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;

public class XSLTDisseminationCrosswalk
extends XSLTCrosswalk
implements DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(XSLTDisseminationCrosswalk.class);
    private static Context context;
    private static final String DIRECTION = "dissemination";
    private static String[] aliases;
    private String schemaLocation = null;
    private Namespace[] namespaces = null;
    private boolean preferList = false;

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private void init() throws CrosswalkInternalException {
        if (this.namespaces != null || this.schemaLocation != null) {
            return;
        }
        String myAlias = this.getPluginInstanceName();
        if (myAlias == null) {
            log.error((Object)"Must use PluginManager to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
            throw new CrosswalkInternalException("Must use PluginManager to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
        }
        String prefix = "crosswalk.dissemination." + myAlias + ".";
        this.schemaLocation = ConfigurationManager.getProperty(prefix + "schemaLocation");
        if (this.schemaLocation == null) {
            log.warn((Object)("No schemaLocation for crosswalk=" + myAlias + ", key=" + prefix + "schemaLocation"));
        } else if (this.schemaLocation.length() > 0 && this.schemaLocation.indexOf(32) < 0) {
            log.warn((Object)("Possible INVALID schemaLocation (no space found) for crosswalk=" + myAlias + ", key=" + prefix + "schemaLocation" + "\n\tCorrect format is \"{namespace} {schema-URL}\""));
        }
        String nsPrefix = prefix + "namespace.";
        Enumeration<?> pe = ConfigurationManager.propertyNames();
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(nsPrefix)) continue;
            nsList.add(Namespace.getNamespace((String)key.substring(nsPrefix.length()), (String)ConfigurationManager.getProperty(key)));
        }
        this.namespaces = nsList.toArray(new Namespace[nsList.size()]);
        this.preferList = ConfigurationManager.getBooleanProperty(prefix + "preferList", false);
    }

    @Override
    public Namespace[] getNamespaces() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return (Namespace[])ArrayUtils.clone((Object[])this.namespaces);
    }

    @Override
    public String getSchemaLocation() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.schemaLocation;
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type != 2 && type != 3 && type != 4) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk items, collections, and communities.");
        }
        this.init();
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            Document ddim = new Document(XSLTDisseminationCrosswalk.createDIM(dso));
            Document result = xform.transform(ddim);
            Element root = result.getRootElement();
            root.detach();
            return root;
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString(), e);
        }
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type != 2 && type != 3 && type != 4) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk a items, collections, and communities.");
        }
        this.init();
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            return xform.transform(XSLTDisseminationCrosswalk.createDIM(dso).getChildren());
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString(), e);
        }
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.preferList;
    }

    public static Element createDIM(DSpaceObject dso, Metadatum[] dcvs) {
        Element dim = new Element("dim", DIM_NS);
        String type = Constants.typeText[dso.getType()];
        dim.setAttribute("dspaceType", type);
        for (int i = 0; i < dcvs.length; ++i) {
            Metadatum dcv = dcvs[i];
            Element field = XSLTDisseminationCrosswalk.createField(dcv.schema, dcv.element, dcv.qualifier, dcv.language, dcv.value, dcv.authority, dcv.confidence);
            dim.addContent((Content)field);
        }
        return dim;
    }

    public static Element createDIM(DSpaceObject dso) {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            return XSLTDisseminationCrosswalk.createDIM(dso, item.getMetadata("*", "*", "*", "*"));
        }
        Element dim = new Element("dim", DIM_NS);
        String type = Constants.typeText[dso.getType()];
        dim.setAttribute("dspaceType", type);
        if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            String description = collection.getMetadata("introductory_text");
            String description_abstract = collection.getMetadata("short_description");
            String description_table = collection.getMetadata("side_bar_text");
            String identifier_uri = "hdl:" + collection.getHandle();
            String provenance = collection.getMetadata("provenance_description");
            String rights = collection.getMetadata("copyright_text");
            String rights_license = collection.getMetadata("license");
            String title = collection.getMetadata("name");
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", null, null, description));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "abstract", null, description_abstract));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "tableofcontents", null, description_table));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "provenance", null, null, provenance));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", null, null, rights));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", "license", null, rights_license));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        } else if (dso.getType() == 4) {
            Community community = (Community)dso;
            String description = community.getMetadata("introductory_text");
            String description_abstract = community.getMetadata("short_description");
            String description_table = community.getMetadata("side_bar_text");
            String identifier_uri = "hdl:" + community.getHandle();
            String rights = community.getMetadata("copyright_text");
            String title = community.getMetadata("name");
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", null, null, description));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "abstract", null, description_abstract));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "tableofcontents", null, description_table));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", null, null, rights));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        } else if (dso.getType() == 5) {
            Site site = (Site)dso;
            String identifier_uri = "hdl:" + site.getHandle();
            String title = site.getName();
            String url = site.getURL();
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, url));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        }
        return dim;
    }

    private static Element createField(String schema, String element, String qualifier, String language, String value) {
        return XSLTDisseminationCrosswalk.createField(schema, element, qualifier, language, value, null, -1);
    }

    private static Element createField(String schema, String element, String qualifier, String language, String value, String authority, int confidence) {
        Element field = new Element("field", DIM_NS);
        field.setAttribute("mdschema", schema);
        field.setAttribute("element", element);
        if (qualifier != null) {
            field.setAttribute("qualifier", qualifier);
        }
        if (language != null) {
            field.setAttribute("lang", language);
        }
        field.setText(XSLTDisseminationCrosswalk.checkedString(value));
        if (authority != null) {
            field.setAttribute("authority", authority);
            field.setAttribute("confidence", Choices.getConfidenceText(confidence));
        }
        return field;
    }

    private static String checkedString(String value) {
        if (value == null) {
            return null;
        }
        String reason = Verifier.checkCharacterData((String)value);
        if (reason == null) {
            return value;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filtering out non-XML characters in string, reason=" + reason));
        }
        StringBuffer result = new StringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static void main(String[] argv) throws Exception {
        DisseminationCrosswalk xwalk;
        log.error((Object)"started.");
        if (argv.length < 2 || argv.length > 3) {
            System.err.println("Usage:  java XSLTDisseminationCrosswalk <crosswalk-name> <handle> [output-file]");
            log.error((Object)"You started Dissemination Crosswalk Test/Export with a wrong number of parameters.");
            System.exit(1);
        }
        String xwalkname = argv[0];
        String handle = argv[1];
        OutputStream out = System.out;
        if (argv.length > 2) {
            try {
                out = new FileOutputStream(argv[2]);
            }
            catch (FileNotFoundException e) {
                System.err.println("Can't write to the specified file: " + e.getMessage());
                System.err.println("Will write output to stdout.");
            }
        }
        if ((xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, xwalkname)) == null) {
            System.err.println("Error: Cannot find a DisseminationCrosswalk plugin for: \"" + xwalkname + "\"");
            log.error((Object)"Cannot find the Dissemination Crosswalk plugin.");
            System.exit(1);
        }
        context = new Context();
        context.turnOffAuthorisationSystem();
        DSpaceObject dso = null;
        try {
            dso = HandleManager.resolveToObject(context, handle);
        }
        catch (SQLException e) {
            System.err.println("Error: A problem with the database connection occurred, check logs for further information.");
            System.exit(1);
        }
        if (null == dso) {
            System.err.println("Can't find a DSpaceObject with the handle \"" + handle + "\"");
            System.exit(1);
        }
        if (!xwalk.canDisseminate(dso)) {
            System.err.println("Dissemination Crosswalk can't disseminate this DSpaceObject.");
            log.error((Object)"Dissemination Crosswalk can't disseminate this DSpaceObject.");
            System.exit(1);
        }
        Element root = null;
        try {
            root = xwalk.disseminateElement(dso);
        }
        catch (Exception e) {
            System.err.println("An error occurred while processing the dissemination crosswalk.");
            System.err.println("=== Error Message ===");
            System.err.println(e.getMessage());
            System.err.println("===  Stack Trace  ===");
            e.printStackTrace();
            System.err.println("=====================");
            log.error((Object)("Caught: " + e.toString() + "."));
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
            System.exit(1);
        }
        try {
            XMLOutputter xmlout = new XMLOutputter(Format.getPrettyFormat());
            xmlout.output(new Document(root), out);
        }
        catch (Exception e) {
            System.err.println("An error occurred after processing the dissemination crosswalk.");
            System.err.println("The error occurred while trying to print the generated XML.");
            System.err.println("=== Error Message ===");
            System.err.println(e.getMessage());
            System.err.println("===  Stack Trace  ===");
            System.err.println(e.getStackTrace());
            System.err.println("=====================");
            log.error((Object)("Caught: " + e.toString() + "."));
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
            System.exit(1);
        }
        context.complete();
        if (out instanceof FileOutputStream) {
            out.close();
        }
    }

    static {
        aliases = XSLTDisseminationCrosswalk.makeAliases(DIRECTION);
    }
}

