/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

public class GoogleRecorderEventListener
extends AbstractUsageEventListener {
    private String analyticsKey;
    private CloseableHttpClient httpclient = HttpClients.createDefault();
    private String GoogleURL = "https://www.google-analytics.com/collect";
    private static Logger log = Logger.getLogger(GoogleRecorderEventListener.class);

    public void receiveEvent(Event event) {
        if (event instanceof UsageEvent) {
            log.debug((Object)("Usage event received " + event.getName()));
            this.analyticsKey = new DSpace().getConfigurationService().getProperty("jspui.google.analytics.key");
            if (this.analyticsKey == null) {
                this.analyticsKey = new DSpace().getConfigurationService().getProperty("xmlui.google.analytics.key");
            }
            if (this.analyticsKey != null) {
                try {
                    UsageEvent ue = (UsageEvent)event;
                    if (UsageEvent.Action.VIEW == ue.getAction() && 0 == ue.getObject().getType()) {
                        this.bitstreamDownload(ue);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
    }

    private void bitstreamDownload(UsageEvent ue) throws IOException {
        HttpPost httpPost = new HttpPost(this.GoogleURL);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("v", "1"));
        nvps.add(new BasicNameValuePair("tid", this.analyticsKey));
        nvps.add(new BasicNameValuePair("cid", "999"));
        nvps.add(new BasicNameValuePair("t", "event"));
        nvps.add(new BasicNameValuePair("dp", ue.getRequest().getRequestURI()));
        nvps.add(new BasicNameValuePair("ec", "bitstream"));
        nvps.add(new BasicNameValuePair("ea", "download"));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        try (CloseableHttpResponse response2 = this.httpclient.execute((HttpUriRequest)httpPost);){
            log.debug((Object)("Google Analytics response is " + response2.getStatusLine()));
        }
        log.debug((Object)("Posted to Google Analytics - " + ue.getRequest().getRequestURI()));
    }
}

