/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.PluginManager;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class DataCiteXMLCreator {
    private static Logger log = Logger.getLogger(DataCiteXMLCreator.class);
    protected String CROSSWALK_NAME = "DataCite";
    protected DisseminationCrosswalk xwalk;

    public String getXMLString(DSpaceObject dso) {
        if (dso == null) {
            log.info((Object)("Invalid object: " + dso));
            return null;
        }
        this.prepareXwalk();
        if (!this.xwalk.canDisseminate(dso)) {
            log.error((Object)("Crosswalk " + this.CROSSWALK_NAME + " cannot disseminate DSO with type " + dso.getType() + " and ID " + dso.getID() + "."));
            return null;
        }
        Element root = null;
        try {
            root = this.xwalk.disseminateElement(dso);
        }
        catch (Exception e) {
            log.error((Object)("Exception while crosswolking DSO with type " + dso.getType() + " and ID " + dso.getID() + "."), (Throwable)e);
            return null;
        }
        XMLOutputter xOut = new XMLOutputter();
        return xOut.outputString(root);
    }

    public void setDisseminationCrosswalkName(String CROSSWALK_NAME) {
        this.CROSSWALK_NAME = CROSSWALK_NAME;
    }

    protected void prepareXwalk() {
        if (null != this.xwalk) {
            return;
        }
        this.xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, this.CROSSWALK_NAME);
        if (this.xwalk == null) {
            throw new RuntimeException("Can't find crosswalk '" + this.CROSSWALK_NAME + "'!");
        }
    }
}

