/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.negotiation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Site;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.negotiation.MediaRange;
import org.dspace.utils.DSpace;

public class Negotiator {
    public static final int UNSPECIFIED = -1;
    public static final int WILDCARD = 0;
    public static final int HTML = 1;
    public static final int RDFXML = 2;
    public static final int TURTLE = 3;
    public static final int N3 = 4;
    public static final String DEFAULT_LANG = "html";
    private static final Logger log = Logger.getLogger(Negotiator.class);

    public static int negotiate(String acceptHeader) {
        MediaRange lookahead;
        if (acceptHeader == null) {
            return -1;
        }
        String[] mediaRangeSpecs = acceptHeader.split(",");
        ArrayList<MediaRange> requestedMediaRanges = new ArrayList<MediaRange>();
        for (String mediaRangeSpec : mediaRangeSpecs) {
            try {
                requestedMediaRanges.add(new MediaRange(mediaRangeSpec));
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                log.warn((Object)("Couldn't parse part of an AcceptHeader, ignoring it.\n" + ex.getMessage()), (Throwable)ex);
            }
        }
        if (requestedMediaRanges.isEmpty()) {
            return -1;
        }
        Collections.sort(requestedMediaRanges, Negotiator.getMediaRangeComparator());
        Collections.reverse(requestedMediaRanges);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Parsed Accept header '" + acceptHeader + "':\n");
            for (MediaRange mr : requestedMediaRanges) {
                sb.append(mr.getType()).append("/").append(mr.getSubtype());
                sb.append(" has a qvalue of ").append(Double.toString(mr.getQvalue()));
                sb.append("\n");
            }
            log.debug((Object)sb.toString());
        }
        boolean wildcard = false;
        boolean html = false;
        boolean rdf = false;
        boolean n3 = false;
        boolean turtle = false;
        Iterator it = requestedMediaRanges.iterator();
        MediaRange mediaRange = lookahead = it.hasNext() ? (MediaRange)it.next() : null;
        while (lookahead != null) {
            double qvalue = lookahead.getQvalue();
            String type = lookahead.getType();
            String subtype = lookahead.getSubtype();
            MediaRange mediaRange2 = lookahead = it.hasNext() ? (MediaRange)it.next() : null;
            if (qvalue <= 0.0) continue;
            if ("*".equals(type)) {
                wildcard = true;
            }
            if ("text".equals(type) && DEFAULT_LANG.equals(subtype) || "application".equals(type) && "xhtml+xml".equals(subtype)) {
                html = true;
            }
            if ("application".equals(type) && "rdf+xml".equals(subtype)) {
                rdf = true;
            }
            if ("text".equals(type) && "n3".equals(subtype) || "text".equals(type) && "rdf+n3".equals(subtype) || "application".equals(type) && "n3".equals(subtype)) {
                n3 = true;
            }
            if ("text".equals(type) && "turtle".equals(subtype) || "application".equals(type) && "turtle".equals(subtype) || "application".equals(type) && "x-turtle".equals(subtype) || "application".equals(type) && "rdf+turtle".equals(subtype)) {
                turtle = true;
            }
            if (lookahead == null || qvalue == lookahead.qvalue || !wildcard && !html && !rdf && !n3 && !turtle) continue;
            break;
        }
        if (html) {
            return 1;
        }
        if (wildcard) {
            return 0;
        }
        if (turtle) {
            return 3;
        }
        if (n3) {
            return 4;
        }
        if (rdf) {
            return 2;
        }
        return -1;
    }

    public static Comparator<MediaRange> getMediaRangeComparator() {
        return new Comparator<MediaRange>(){

            @Override
            public int compare(MediaRange mr1, MediaRange mr2) {
                if (Double.compare(mr1.qvalue, mr2.getQvalue()) != 0) {
                    return Double.compare(mr1.qvalue, mr2.getQvalue());
                }
                if (mr1.typeIsWildcard() && mr2.typeIsWildcard()) {
                    return 0;
                }
                if (mr1.typeIsWildcard() && !mr2.typeIsWildcard()) {
                    return -1;
                }
                if (!mr1.typeIsWildcard() && mr2.typeIsWildcard()) {
                    return 1;
                }
                if (mr1.subtypeIsWildcard() && mr2.subtypeIsWildcard()) {
                    return 0;
                }
                if (mr1.subtypeIsWildcard() && !mr2.subtypeIsWildcard()) {
                    return -1;
                }
                if (!mr1.subtypeIsWildcard() && mr2.subtypeIsWildcard()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static boolean sendRedirect(HttpServletResponse response, String handle, String extraPathInfo, int serialization, boolean redirectHTML) throws IOException {
        if (extraPathInfo == null) {
            extraPathInfo = "";
        }
        StringBuilder urlBuilder = new StringBuilder();
        String lang = null;
        switch (serialization) {
            case -1: 
            case 0: {
                lang = DEFAULT_LANG;
                break;
            }
            case 1: {
                lang = DEFAULT_LANG;
                break;
            }
            case 2: {
                lang = "rdf";
                break;
            }
            case 3: {
                lang = "turtle";
                break;
            }
            case 4: {
                lang = "n3";
                break;
            }
            default: {
                lang = DEFAULT_LANG;
            }
        }
        assert (lang != null);
        if (StringUtils.isEmpty((String)handle)) {
            log.warn((Object)"Handle is empty, set it to Site Handle.");
            handle = Site.getSiteHandle();
        }
        if (DEFAULT_LANG.equals(lang) && !redirectHTML) {
            return false;
        }
        response.setHeader("Vary", "Accept");
        if (DEFAULT_LANG.equals(lang)) {
            urlBuilder.append(new DSpace().getConfigurationService().getProperty("dspace.url"));
            if (!handle.equals(Site.getSiteHandle())) {
                urlBuilder.append("/handle/");
                urlBuilder.append(handle).append("/").append(extraPathInfo);
            }
            String url = urlBuilder.toString();
            log.debug((Object)("Will forward to '" + url + "'."));
            response.setStatus(303);
            response.setHeader("Location", url);
            response.flushBuffer();
            return true;
        }
        if ("statistics".equals(extraPathInfo)) {
            log.info((Object)"Cannot send statistics as RDF yet. => 406 Not Acceptable.");
            response.sendError(406);
            response.flushBuffer();
            return true;
        }
        urlBuilder.append(RDFConfiguration.getDSpaceRDFModuleURI());
        if (urlBuilder.length() == 0) {
            log.error((Object)"Cannot load URL of dspace-rdf module. => 500 Internal Server Error");
            response.sendError(500);
            response.flushBuffer();
            return true;
        }
        urlBuilder.append("/handle/").append(handle);
        urlBuilder.append("/").append(lang);
        String url = urlBuilder.toString();
        log.debug((Object)("Will forward to '" + url + "'."));
        response.setStatus(303);
        response.setHeader("Location", url);
        response.flushBuffer();
        return true;
    }
}

