/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.DatabaseUtils;

public class MigrationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer dropDBConstraint(Connection connection, String tableName, String columnName) throws SQLException {
        Integer checksum = -1;
        DatabaseMetaData meta = connection.getMetaData();
        String dbtype = DatabaseManager.findDbKeyword(meta);
        String constraintName = null;
        String constraintNameSQL = null;
        String schemaName = null;
        switch (dbtype) {
            case "postgres": {
                constraintNameSQL = "SELECT DISTINCT CONSTRAINT_NAME FROM information_schema.key_column_usage WHERE TABLE_NAME = ? AND COLUMN_NAME = ? AND TABLE_SCHEMA = ?";
                schemaName = DatabaseUtils.getSchemaName(connection);
                break;
            }
            case "oracle": {
                constraintNameSQL = "SELECT CONSTRAINT_NAME FROM USER_CONS_COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                break;
            }
            case "h2": {
                constraintNameSQL = "SELECT DISTINCT CONSTRAINT_NAME FROM information_schema.constraints WHERE table_name = ? AND column_list = ?";
                break;
            }
            default: {
                throw new SQLException("DBMS " + dbtype + " is unsupported in this migration.");
            }
        }
        PreparedStatement statement = connection.prepareStatement(constraintNameSQL);
        statement.setString(1, DatabaseUtils.canonicalize(connection, tableName));
        statement.setString(2, DatabaseUtils.canonicalize(connection, columnName));
        if (schemaName != null && !schemaName.isEmpty()) {
            statement.setString(3, DatabaseUtils.canonicalize(connection, schemaName));
        }
        try {
            ResultSet results = statement.executeQuery();
            if (results.next()) {
                constraintName = results.getString("CONSTRAINT_NAME");
            }
            results.close();
        }
        finally {
            statement.close();
        }
        if (constraintName != null && !constraintName.isEmpty()) {
            if ((constraintName = DatabaseUtils.canonicalize(connection, constraintName)).startsWith("$")) {
                constraintName = "\"" + constraintName + "\"";
            }
            String dropConstraintSQL = "ALTER TABLE " + DatabaseUtils.canonicalize(connection, tableName) + " DROP CONSTRAINT " + constraintName;
            statement = connection.prepareStatement(dropConstraintSQL);
            try {
                statement.execute();
            }
            finally {
                statement.close();
            }
            checksum = dropConstraintSQL.length();
        }
        return checksum;
    }
}

