/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class FixDefaultPolicies {
    public static void main(String[] argv) throws Exception {
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        Collection[] collections = Collection.findAll(c);
        for (int i = 0; i < collections.length; ++i) {
            Collection t = collections[i];
            System.out.println("Collection " + t + " " + t.getMetadata("name"));
            if (FixDefaultPolicies.checkForPolicy(c, t, 0)) {
                System.out.println("\tFound READ policies!");
            } else {
                System.out.println("\tNo READ policy found, adding anonymous.");
                FixDefaultPolicies.addAnonymousPolicy(c, t, 0);
            }
            if (FixDefaultPolicies.checkForPolicy(c, t, 10)) {
                System.out.println("\tFound DEFAULT_ITEM_READ policies!");
            } else {
                System.out.println("\tNo DEFAULT_ITEM_READ policy found, adding anonymous.");
                FixDefaultPolicies.addAnonymousPolicy(c, t, 10);
            }
            if (FixDefaultPolicies.checkForPolicy(c, t, 9)) {
                System.out.println("\tFound DEFAULT_BITSTREAM_READ policies!");
                continue;
            }
            System.out.println("\tNo DEFAULT_BITSTREAM_READ policy found, adding anonymous.");
            FixDefaultPolicies.addAnonymousPolicy(c, t, 9);
        }
        Community[] communities = Community.findAll(c);
        for (int i = 0; i < communities.length; ++i) {
            Community t = communities[i];
            System.out.println("Community " + t + " " + t.getMetadata("name"));
            if (FixDefaultPolicies.checkForPolicy(c, t, 0)) {
                System.out.println("\tFound READ policies!");
                continue;
            }
            System.out.println("\tNo READ policy found, adding anonymous.");
            FixDefaultPolicies.addAnonymousPolicy(c, t, 0);
        }
        c.complete();
        System.exit(0);
    }

    private static boolean checkForPolicy(Context c, DSpaceObject t, int myaction) throws SQLException {
        List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(c, t, myaction);
        return policies.size() > 0;
    }

    private static void addAnonymousPolicy(Context c, DSpaceObject t, int myaction) throws SQLException, AuthorizeException {
        Group anonymousGroup = Group.find(c, 0);
        ResourcePolicy myPolicy = ResourcePolicy.create(c);
        myPolicy.setResource(t);
        myPolicy.setAction(myaction);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
    }
}

