/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Context;

public abstract class AbstractPackageDisseminator
implements PackageDisseminator {
    private List<File> packageFileList = new ArrayList<File>();

    @Override
    public List<File> disseminateAll(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (!params.recursiveModeEnabled()) {
            params.setRecursiveModeEnabled(true);
        }
        if (!this.getPackageList().contains(pkgFile)) {
            this.disseminate(context, dso, params, pkgFile);
        }
        if (pkgFile.exists()) {
            this.addToPackageList(pkgFile);
            if (dso.getType() != 2) {
                String pkgDirectory = pkgFile.getCanonicalFile().getParent();
                if (!pkgDirectory.endsWith(File.separator)) {
                    pkgDirectory = pkgDirectory + File.separator;
                }
                String fileExtension = PackageUtils.getFileExtension(pkgFile.getName());
                switch (dso.getType()) {
                    case 3: {
                        Collection collection = (Collection)dso;
                        ItemIterator iterator = collection.getItems();
                        while (iterator.hasNext()) {
                            Item item = iterator.next();
                            String childFileName = pkgDirectory + PackageUtils.getPackageName(item, fileExtension);
                            this.disseminateAll(context, item, params, new File(childFileName));
                        }
                        break;
                    }
                    case 4: {
                        Community community = (Community)dso;
                        Community[] subcommunities = community.getSubcommunities();
                        for (int i = 0; i < subcommunities.length; ++i) {
                            String childFileName = pkgDirectory + PackageUtils.getPackageName(subcommunities[i], fileExtension);
                            this.disseminateAll(context, subcommunities[i], params, new File(childFileName));
                        }
                        Collection[] collections = community.getCollections();
                        for (int i = 0; i < collections.length; ++i) {
                            String childFileName = pkgDirectory + PackageUtils.getPackageName(collections[i], fileExtension);
                            this.disseminateAll(context, collections[i], params, new File(childFileName));
                        }
                        break;
                    }
                    case 5: {
                        Community[] topCommunities = Community.findAllTop(context);
                        for (int i = 0; i < topCommunities.length; ++i) {
                            String childFileName = pkgDirectory + PackageUtils.getPackageName(topCommunities[i], fileExtension);
                            this.disseminateAll(context, topCommunities[i], params, new File(childFileName));
                        }
                        break;
                    }
                }
            }
        }
        return this.getPackageList();
    }

    protected void addToPackageList(File f) {
        if (!this.packageFileList.contains(f)) {
            this.packageFileList.add(f);
        }
    }

    protected List<File> getPackageList() {
        return this.packageFileList;
    }
}

