/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.services.EmailService;
import org.dspace.utils.DSpace;

public class Email {
    private String content = "";
    private String subject = "";
    private List<Object> arguments = new ArrayList<Object>(50);
    private List<String> recipients = new ArrayList<String>(50);
    private String replyTo = null;
    private List<FileAttachment> attachments = new ArrayList<FileAttachment>(10);
    private List<InputStreamAttachment> moreAttachments = new ArrayList<InputStreamAttachment>(10);
    private String charset = null;
    private static final Logger log = Logger.getLogger(Email.class);

    public void addRecipient(String email) {
        this.recipients.add(email);
    }

    public void setContent(String cnt) {
        this.content = cnt;
        this.arguments = new ArrayList<Object>();
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setReplyTo(String email) {
        this.replyTo = email;
    }

    public void addArgument(Object arg) {
        this.arguments.add(arg);
    }

    public void addAttachment(File f, String name) {
        this.attachments.add(new FileAttachment(f, name));
    }

    public void addAttachment(InputStream is, String name, String mimetype) {
        this.moreAttachments.add(new InputStreamAttachment(is, name, mimetype));
    }

    public void setCharset(String cs) {
        this.charset = cs;
    }

    public void reset() {
        this.arguments = new ArrayList<Object>(50);
        this.recipients = new ArrayList<String>(50);
        this.attachments = new ArrayList<FileAttachment>(10);
        this.moreAttachments = new ArrayList<InputStreamAttachment>(10);
        this.replyTo = null;
        this.charset = null;
    }

    public void send() throws MessagingException, IOException {
        String from = ConfigurationManager.getProperty("mail.from.address");
        boolean disabled = ConfigurationManager.getBooleanProperty("mail.server.disabled", false);
        if (this.charset == null) {
            this.charset = ConfigurationManager.getProperty("mail.charset");
        }
        Session session = ((EmailService)new DSpace().getServiceManager().getServicesByType(EmailService.class).get(0)).getSession();
        MimeMessage message = new MimeMessage(session);
        Iterator<String> i = this.recipients.iterator();
        while (i.hasNext()) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(i.next()));
        }
        Object[] args = this.arguments.toArray();
        String fullMessage = MessageFormat.format(this.content, args);
        Date date = new Date();
        message.setSentDate(date);
        message.setFrom((Address)new InternetAddress(from));
        String fullSubject = MessageFormat.format(this.subject, args);
        if (this.charset != null) {
            message.setSubject(fullSubject, this.charset);
        } else {
            message.setSubject(fullSubject);
        }
        if (this.attachments.isEmpty() && this.moreAttachments.isEmpty()) {
            if (this.charset != null) {
                message.setText(fullMessage, this.charset);
            } else {
                message.setText(fullMessage);
            }
        } else {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(fullMessage);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (!this.attachments.isEmpty()) {
                for (FileAttachment f : this.attachments) {
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(f.file)));
                    messageBodyPart.setFileName(f.name);
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                message.setContent((Multipart)multipart);
            }
            if (!this.moreAttachments.isEmpty()) {
                for (InputStreamAttachment isa : this.moreAttachments) {
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new InputStreamDataSource(isa.name, isa.mimetype, isa.is)));
                    messageBodyPart.setFileName(isa.name);
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                message.setContent((Multipart)multipart);
            }
        }
        if (this.replyTo != null) {
            Address[] replyToAddr = new Address[]{new InternetAddress(this.replyTo)};
            message.setReplyTo(replyToAddr);
        }
        if (disabled) {
            StringBuffer text = new StringBuffer("Message not sent due to mail.server.disabled:\n");
            Enumeration headers = message.getAllHeaderLines();
            while (headers.hasMoreElements()) {
                text.append((String)headers.nextElement()).append('\n');
            }
            if (!this.attachments.isEmpty()) {
                text.append("\nAttachments:\n");
                for (FileAttachment f : this.attachments) {
                    text.append(f.name).append('\n');
                }
                text.append('\n');
            }
            text.append('\n').append(fullMessage);
            log.info((Object)text);
        } else {
            Transport.send((Message)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Email getEmail(String emailFile) throws IOException {
        String charset = null;
        String subject = "";
        StringBuilder contentBuffer = new StringBuilder();
        FileInputStream is = null;
        InputStreamReader ir = null;
        BufferedReader reader = null;
        try {
            is = new FileInputStream(emailFile);
            ir = new InputStreamReader((InputStream)is, "UTF-8");
            reader = new BufferedReader(ir);
            boolean more = true;
            while (more) {
                String line = reader.readLine();
                if (line == null) {
                    more = false;
                    continue;
                }
                if (line.toLowerCase().startsWith("subject:")) {
                    subject = line.substring(8).trim();
                    continue;
                }
                if (line.toLowerCase().startsWith("charset:")) {
                    charset = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("#")) continue;
                contentBuffer.append(line);
                contentBuffer.append("\n");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException ioe) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {}
            }
        }
        Email email = new Email();
        email.setSubject(subject);
        email.setContent(contentBuffer.toString());
        if (charset != null) {
            email.setCharset(charset);
        }
        return email;
    }

    public static void main(String[] args) {
        String to = ConfigurationManager.getProperty("mail.admin");
        String subject = "DSpace test email";
        String server = ConfigurationManager.getProperty("mail.server");
        String url = ConfigurationManager.getProperty("dspace.url");
        Email e = new Email();
        e.setSubject(subject);
        e.addRecipient(to);
        e.content = "This is a test email sent from DSpace: " + url;
        System.out.println("\nAbout to send test email:");
        System.out.println(" - To: " + to);
        System.out.println(" - Subject: " + subject);
        System.out.println(" - Server: " + server);
        boolean disabled = ConfigurationManager.getBooleanProperty("mail.server.disabled", false);
        try {
            if (disabled) {
                System.err.println("\nError sending email:");
                System.err.println(" - Error: cannot test email because mail.server.disabled is set to true");
                System.err.println("\nPlease see the DSpace documentation for assistance.\n");
                System.err.println("\n");
                System.exit(1);
                return;
            }
            e.send();
        }
        catch (MessagingException me) {
            System.err.println("\nError sending email:");
            System.err.println(" - Error: " + (Object)((Object)me));
            System.err.println("\nPlease see the DSpace documentation for assistance.\n");
            System.err.println("\n");
            System.exit(1);
        }
        catch (IOException e1) {
            System.err.println("\nError sending email:");
            System.err.println(" - Error: " + e1);
            System.err.println("\nPlease see the DSpace documentation for assistance.\n");
            System.err.println("\n");
            System.exit(1);
        }
        System.out.println("\nEmail sent successfully!\n");
    }

    public class InputStreamDataSource
    implements DataSource {
        private String name;
        private String contentType;
        private ByteArrayOutputStream baos;

        InputStreamDataSource(String name, String contentType, InputStream inputStream) throws IOException {
            int read;
            this.name = name;
            this.contentType = contentType;
            this.baos = new ByteArrayOutputStream();
            byte[] buff = new byte[256];
            while ((read = inputStream.read(buff)) != -1) {
                this.baos.write(buff, 0, read);
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.baos.toByteArray());
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Cannot write to this read-only resource");
        }
    }

    private static class InputStreamAttachment {
        InputStream is;
        String mimetype;
        String name;

        public InputStreamAttachment(InputStream is, String name, String mimetype) {
            this.is = is;
            this.name = name;
            this.mimetype = mimetype;
        }
    }

    private static class FileAttachment {
        File file;
        String name;

        public FileAttachment(File f, String n) {
            this.file = f;
            this.name = n;
        }
    }
}

