/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.springframework.stereotype.Component;

@Component
public class HandleIdentifierProvider
extends IdentifierProvider {
    private static Logger log = Logger.getLogger(HandleIdentifierProvider.class);
    protected static final String EXAMPLE_PREFIX = "123456789";
    protected String[] supportedPrefixes = new String[]{"info:hdl", "hdl", "http://"};

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return Handle.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        for (String prefix : this.supportedPrefixes) {
            if (!identifier.startsWith(prefix)) continue;
            return true;
        }
        try {
            String outOfUrl = HandleIdentifierProvider.retrieveHandleOutOfUrl(identifier);
            if (outOfUrl != null) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public String register(Context context, DSpaceObject dso) {
        try {
            String id = this.mint(context, dso);
            if (dso instanceof Item) {
                Item item = (Item)dso;
                this.populateHandleMetadata(item, id);
            }
            return id;
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) {
        try {
            this.createNewIdentifier(context, dso, identifier);
            if (dso instanceof Item) {
                Item item = (Item)dso;
                this.populateHandleMetadata(item, identifier);
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            TableRow handle = DatabaseManager.create(context, "Handle");
            this.modifyHandleRecord(context, dso, handle, identifier);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) {
        if (dso.getHandle() != null) {
            return dso.getHandle();
        }
        try {
            return this.createNewIdentifier(context, dso, null);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            TableRow dbhandle = HandleIdentifierProvider.findHandleInternal(context, identifier);
            if (dbhandle == null) {
                if ((identifier = HandleIdentifierProvider.retrieveHandleOutOfUrl(identifier)) != null) {
                    dbhandle = HandleIdentifierProvider.findHandleInternal(context, identifier);
                }
                if (dbhandle == null) {
                    return null;
                }
            }
            if (dbhandle.isColumnNull("resource_type_id") || dbhandle.isColumnNull("resource_id")) {
                throw new IllegalStateException("No associated resource type");
            }
            int handletypeid = dbhandle.getIntColumn("resource_type_id");
            int resourceID = dbhandle.getIntColumn("resource_id");
            if (handletypeid == 2) {
                Item item = Item.find(context, resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved handle " + identifier + " to item " + (item == null ? -1 : item.getID())));
                }
                return item;
            }
            if (handletypeid == 3) {
                Collection collection = Collection.find(context, resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved handle " + identifier + " to collection " + (collection == null ? -1 : collection.getID())));
                }
                return collection;
            }
            if (handletypeid == 4) {
                Community community = Community.find(context, resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved handle " + identifier + " to community " + (community == null ? -1 : community.getID())));
                }
                return community;
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while resolving handle to item", "handle: " + identifier), (Throwable)e);
        }
        return null;
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            TableRow row = HandleIdentifierProvider.getHandleInternal(context, dso.getType(), dso.getID());
            if (row == null) {
                if (dso.getType() == 5) {
                    return Site.getSiteHandle();
                }
                return null;
            }
            return row.getStringColumn("handle");
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), sqe);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        try {
            TableRow row = HandleIdentifierProvider.getHandleInternal(context, dso.getType(), dso.getID());
            if (row != null) {
                row.setColumnNull("resource_id");
                DatabaseManager.update(context, row);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unbound Handle " + row.getStringColumn("handle") + " from object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
                }
            } else {
                log.warn((Object)("Cannot find Handle entry to unbind for object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
            }
        }
        catch (SQLException sqe) {
            throw new IdentifierException(sqe.getMessage(), sqe);
        }
    }

    public static String retrieveHandleOutOfUrl(String url) throws SQLException {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    public static String getPrefix() {
        String prefix = ConfigurationManager.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error((Object)("handle.prefix is not configured; using " + prefix));
        }
        return prefix;
    }

    protected static String getCanonicalForm(String handle) {
        String handlePrefix = ConfigurationManager.getProperty("handle.canonical.prefix");
        if (handlePrefix == null || handlePrefix.length() == 0) {
            handlePrefix = "http://hdl.handle.net/";
        }
        return handlePrefix + handle;
    }

    protected String createNewIdentifier(Context context, DSpaceObject dso, String handleId) throws SQLException {
        int previousType;
        TableRow handle = null;
        if (handleId != null) {
            handle = HandleIdentifierProvider.findHandleInternal(context, handleId);
            if (handle != null && !handle.isColumnNull("resource_id")) {
                if (handle.getIntColumn("resource_id") == dso.getID() && handle.getIntColumn("resource_type_id") == dso.getType()) {
                    return handleId;
                }
                throw new IllegalStateException("Attempted to create a handle which is already in use: " + handleId);
            }
        } else if (handle != null && !handle.isColumnNull("resource_type_id") && (previousType = handle.getIntColumn("resource_type_id")) != dso.getType()) {
            throw new IllegalStateException("Attempted to reuse a handle previously used by a " + Constants.typeText[previousType] + " for a new " + Constants.typeText[dso.getType()]);
        }
        if (handle == null) {
            handle = DatabaseManager.create(context, "Handle");
            handleId = HandleIdentifierProvider.createId(handle.getIntColumn("handle_id"));
        }
        this.modifyHandleRecord(context, dso, handle, handleId);
        return handleId;
    }

    protected String modifyHandleRecord(Context context, DSpaceObject dso, TableRow handle, String handleId) throws SQLException {
        handle.setColumn("handle", handleId);
        handle.setColumn("resource_type_id", dso.getType());
        handle.setColumn("resource_id", dso.getID());
        DatabaseManager.update(context, handle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new handle for " + Constants.typeText[dso.getType()] + " " + handleId));
        }
        return handleId;
    }

    protected static TableRow getHandleInternal(Context context, int type, int id) throws SQLException {
        String sql = "SELECT * FROM Handle WHERE resource_type_id = ? AND resource_id = ?";
        return DatabaseManager.querySingleTable(context, "Handle", sql, type, id);
    }

    protected static TableRow findHandleInternal(Context context, String handle) throws SQLException {
        if (handle == null) {
            throw new IllegalArgumentException("Handle is null");
        }
        return DatabaseManager.findByUnique(context, "Handle", "handle", handle);
    }

    protected static String createId(int id) throws SQLException {
        String handlePrefix = HandleIdentifierProvider.getPrefix();
        return handlePrefix + (handlePrefix.endsWith("/") ? "" : "/") + id;
    }

    protected void populateHandleMetadata(Item item, String handle) throws SQLException, IOException, AuthorizeException {
        Metadatum[] identifiers;
        String handleref = HandleIdentifierProvider.getCanonicalForm(handle);
        boolean identifierExists = false;
        for (Metadatum identifier : identifiers = item.getDC("identifier", "uri", "*")) {
            if (!handleref.equals(identifier.value)) continue;
            identifierExists = true;
        }
        if (!identifierExists) {
            item.addDC("identifier", "uri", null, handleref);
        }
    }
}

