/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class QDCCrosswalk
extends SelfNamedPlugin
implements DisseminationCrosswalk,
IngestionCrosswalk {
    private static Logger log = Logger.getLogger(QDCCrosswalk.class);
    private Map<String, Element> qdc2element = new HashMap<String, Element>();
    private Map<String, String> element2qdc = new HashMap<String, String>();
    private Namespace[] namespaces = null;
    private static final Namespace DCTERMS_NS = Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/");
    private boolean inited = false;
    private String myName = null;
    private static final String CONFIG_PREFIX = "crosswalk.qdc";
    private String schemaLocation = null;
    private static SAXBuilder builder = new SAXBuilder();
    private static String[] aliases = null;

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private String makeQualifiedTagName(Element element) {
        String qualifier;
        String nsQualifier;
        String prefix = "";
        Namespace ns = element.getNamespace();
        if (ns != null) {
            prefix = ns.getPrefix() + ":";
        }
        String tagName = (nsQualifier = element.getAttributeValue("type", DisseminationCrosswalk.XSI_NS)) == null || nsQualifier.length() < 1 ? ((qualifier = element.getAttributeValue("type")) == null || qualifier.length() < 1 ? prefix + element.getName() : prefix + element.getName() + qualifier) : prefix + element.getName() + nsQualifier;
        return tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws CrosswalkException, IOException {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.myName = this.getPluginInstanceName();
        if (this.myName == null) {
            throw new CrosswalkInternalException("Cannot determine plugin name, You must use PluginManager to instantiate QDCCrosswalk so the instance knows its name.");
        }
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        Enumeration<?> pe = ConfigurationManager.propertyNames();
        String propname = "crosswalk.qdc.namespace." + this.myName + ".";
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(propname)) continue;
            nsList.add(Namespace.getNamespace((String)key.substring(propname.length()), (String)ConfigurationManager.getProperty(key)));
        }
        nsList.add(Namespace.XML_NAMESPACE);
        this.namespaces = nsList.toArray(new Namespace[nsList.size()]);
        this.schemaLocation = ConfigurationManager.getProperty("crosswalk.qdc.schemaLocation." + this.myName);
        String cmPropName = "crosswalk.qdc.properties." + this.myName;
        String propsFilename = ConfigurationManager.getProperty(cmPropName);
        if (propsFilename == null) {
            throw new CrosswalkInternalException("Configuration error: No properties file configured for QDC crosswalk named \"" + this.myName + "\"");
        }
        String parent = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
        File propsFile = new File(parent, propsFilename);
        Properties qdcProps = new Properties();
        FileInputStream pfs = null;
        try {
            pfs = new FileInputStream(propsFile);
            qdcProps.load(pfs);
        }
        finally {
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (IOException iOException) {}
            }
        }
        String postlog = "</wrapper>";
        StringBuffer prologb = new StringBuffer("<wrapper");
        for (int i = 0; i < this.namespaces.length; ++i) {
            prologb.append(" xmlns:");
            prologb.append(this.namespaces[i].getPrefix());
            prologb.append("=\"");
            prologb.append(this.namespaces[i].getURI());
            prologb.append("\"");
        }
        prologb.append(">");
        String prolog = prologb.toString();
        pe = qdcProps.propertyNames();
        while (pe.hasMoreElements()) {
            String qdc = (String)pe.nextElement();
            String val = qdcProps.getProperty(qdc);
            try {
                Document d = builder.build((Reader)new StringReader(prolog + val + postlog));
                Element element = (Element)d.getRootElement().getContent(0);
                this.qdc2element.put(qdc, element);
                this.element2qdc.put(this.makeQualifiedTagName(element), qdc);
                log.debug((Object)("Building Maps: qdc=\"" + qdc + "\", element=\"" + element.toString() + "\""));
            }
            catch (JDOMException je) {
                throw new CrosswalkInternalException("Failed parsing XML fragment in properties file: \"" + prolog + val + postlog + "\": " + je.toString(), je);
            }
        }
    }

    @Override
    public Namespace[] getNamespaces() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Namespace[])ArrayUtils.clone((Object[])this.namespaces);
    }

    @Override
    public String getSchemaLocation() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.schemaLocation;
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        return this.disseminateListInternal(dso, true);
    }

    private List<Element> disseminateListInternal(DSpaceObject dso, boolean addSchema) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("QDCCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        this.init();
        Metadatum[] dc = item.getMetadata("*", "*", "*", "*");
        ArrayList<Element> result = new ArrayList<Element>(dc.length);
        for (int i = 0; i < dc.length; ++i) {
            String qdc = dc[i].schema + "." + (dc[i].qualifier == null ? dc[i].element : dc[i].element + "." + dc[i].qualifier);
            Element elt = this.qdc2element.get(qdc);
            if (elt == null) {
                if (!dc[i].schema.equals("dc")) continue;
                log.warn((Object)("WARNING: " + this.myName + ": No QDC mapping for \"" + qdc + "\""));
                continue;
            }
            Element qe = (Element)elt.clone();
            qe.setText(dc[i].value);
            if (addSchema && this.schemaLocation != null) {
                qe.setAttribute("schemaLocation", this.schemaLocation, XSI_NS);
            }
            if (dc[i].language != null) {
                qe.setAttribute("lang", dc[i].language, Namespace.XML_NAMESPACE);
            }
            result.add(qe);
        }
        return result;
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        this.init();
        Element root = new Element("qualifieddc", DCTERMS_NS);
        if (this.schemaLocation != null) {
            root.setAttribute("schemaLocation", this.schemaLocation, XSI_NS);
        }
        root.addContent(this.disseminateListInternal(dso, false));
        return root;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return true;
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        this.init();
        if (!root.getName().equals("qualifieddc")) {
            throw new MetadataValidationException("Wrong root element for Qualified DC: " + root.toString());
        }
        this.ingest(context, dso, root.getChildren());
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> ml) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        this.init();
        if (dso.getType() != 2) {
            throw new CrosswalkInternalException("Wrong target object type, QDCCrosswalk can only crosswalk to an Item.");
        }
        Item item = (Item)dso;
        for (Element me : ml) {
            String key = this.makeQualifiedTagName(me);
            if ("qualifieddc".equals(me.getName())) {
                this.ingest(context, dso, me.getChildren());
                continue;
            }
            if (this.element2qdc.containsKey(key)) {
                String[] qdc = this.element2qdc.get(key).split("\\.");
                String lang = me.getAttributeValue("lang", Namespace.XML_NAMESPACE);
                if (lang == null) {
                    lang = me.getAttributeValue("lang");
                }
                if (qdc.length == 3) {
                    item.addMetadata(qdc[0], qdc[1], qdc[2], lang, me.getText());
                    continue;
                }
                if (qdc.length == 2) {
                    item.addMetadata(qdc[0], qdc[1], null, lang, me.getText());
                    continue;
                }
                throw new CrosswalkInternalException("Unrecognized format in QDC element identifier for key=\"" + key + "\", qdc=\"" + this.element2qdc.get(key) + "\"");
            }
            log.warn((Object)("WARNING: " + this.myName + ": No mapping for Element=\"" + key + "\" to qdc."));
        }
    }

    @Override
    public boolean preferList() {
        return true;
    }

    static {
        ArrayList<String> aliasList = new ArrayList<String>();
        Enumeration<?> pe = ConfigurationManager.propertyNames();
        String propname = "crosswalk.qdc.properties.";
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(propname)) continue;
            aliasList.add(key.substring(propname.length()));
        }
        aliases = aliasList.toArray(new String[aliasList.size()]);
    }
}

