/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.ctask.general.AbstractTranslator;

public class MicrosoftTranslator
extends AbstractTranslator {
    private static final String PLUGIN_PREFIX = "translator";
    private static final String baseUrl = "http://api.microsofttranslator.com/V2/Http.svc/Translate";
    private static String apiKey = "";
    private static final Logger log = Logger.getLogger(MicrosoftTranslator.class);

    @Override
    protected void initApi() {
        apiKey = ConfigurationManager.getProperty(PLUGIN_PREFIX, "translate.api.key.microsoft");
    }

    @Override
    protected String translateText(String from, String to, String text) throws IOException {
        log.debug((Object)("Performing API call to translate from " + from + " to " + to));
        text = URLEncoder.encode(text, "UTF-8");
        String translatedText = null;
        String url = "http://api.microsofttranslator.com/V2/Http.svc/Translate?appId=" + apiKey;
        url = url + "&to=" + to + "&from=" + from + "&text=" + text;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet hm = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)hm);
        log.debug((Object)("Response code from API call is " + httpResponse));
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)StandardCharsets.ISO_8859_1);
            response = response.replaceAll("<string xmlns=\"http://schemas.microsoft.com/2003/10/Serialization/\">", "");
            translatedText = response = response.replaceAll("</string>", "");
        }
        return translatedText;
    }
}

