/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.event.ConsumerProfile;
import org.dspace.event.Dispatcher;

public class EventManager {
    private static Logger log = Logger.getLogger(EventManager.class);
    public static final String DEFAULT_DISPATCHER = "default";
    private static DispatcherPoolFactory dispatcherFactory = null;
    private static GenericKeyedObjectPool.Config poolConfig = null;
    private static KeyedObjectPool dispatcherPool = null;
    private static Map<String, Integer> consumerIndicies = null;
    private static final String CONSUMER_PFX = "event.consumer.";

    public EventManager() {
        EventManager.initPool();
        log.info((Object)"Event Dispatcher Pool Initialized");
    }

    private static void initPool() {
        if (dispatcherPool == null) {
            poolConfig = new GenericKeyedObjectPool.Config();
            EventManager.poolConfig.maxActive = 100;
            EventManager.poolConfig.maxIdle = 5;
            EventManager.poolConfig.maxTotal = 100;
            try {
                dispatcherFactory = new DispatcherPoolFactory();
                dispatcherPool = PoolUtils.synchronizedPool((KeyedObjectPool)new GenericKeyedObjectPool((KeyedPoolableObjectFactory)dispatcherFactory, poolConfig));
                EventManager.enumerateConsumers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Dispatcher getDispatcher(String name) {
        if (dispatcherPool == null) {
            EventManager.initPool();
        }
        if (name == null) {
            name = DEFAULT_DISPATCHER;
        }
        try {
            return (Dispatcher)dispatcherPool.borrowObject((Object)name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to aquire dispatcher named " + name, e);
        }
    }

    public static void returnDispatcher(String key, Dispatcher disp) {
        try {
            dispatcherPool.returnObject((Object)key, (Object)disp);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static int getConsumerIndex(String consumerClass) {
        Integer index = consumerIndicies.get(consumerClass);
        return index != null ? index : -1;
    }

    private static void enumerateConsumers() {
        Enumeration<?> propertyNames = ConfigurationManager.propertyNames();
        int bitSetIndex = 0;
        if (consumerIndicies == null) {
            consumerIndicies = new HashMap<String, Integer>();
        }
        while (propertyNames.hasMoreElements()) {
            String ckey = ((String)propertyNames.nextElement()).trim();
            if (!ckey.startsWith(CONSUMER_PFX) || !ckey.endsWith(".class")) continue;
            String consumerName = ckey.substring(CONSUMER_PFX.length(), ckey.length() - 6);
            consumerIndicies.put(consumerName, bitSetIndex);
            ++bitSetIndex;
        }
    }

    static class DispatcherPoolFactory
    implements KeyedPoolableObjectFactory {
        private static final String PROP_PFX = "event.dispatcher.";
        private static Map<String, String> dispatchers = new HashMap<String, String>();

        public DispatcherPoolFactory() {
            this.parseEventConfig();
            log.info((Object)"");
        }

        public Object makeObject(Object dispatcherName) throws Exception {
            Dispatcher dispatcher = null;
            String dispClass = dispatchers.get(dispatcherName);
            if (dispClass != null) {
                try {
                    Class[] argTypes = new Class[]{String.class};
                    Constructor<?> dc = Class.forName(dispClass).getConstructor(argTypes);
                    Object[] args = new Object[]{dispatcherName};
                    dispatcher = (Dispatcher)dc.newInstance(args);
                    String consumerKey = PROP_PFX + dispatcherName + ".consumers";
                    String consumerList = ConfigurationManager.getProperty(consumerKey);
                    if (consumerList == null) {
                        throw new IllegalStateException("No Configuration entry found for consumer list of event Dispatcher: \"" + consumerKey + "\"");
                    }
                    String[] consumerStanza = consumerList.trim().split("\\s*,\\s*");
                    if (consumerStanza.length < 1) {
                        throw new IllegalStateException("Cannot initialize Dispatcher, malformed Configuration value for " + consumerKey);
                    }
                    ConsumerProfile consumerProfile = null;
                    for (int i = 0; i < consumerStanza.length; ++i) {
                        consumerProfile = ConsumerProfile.makeConsumerProfile(consumerStanza[i]);
                        consumerProfile.getConsumer().initialize();
                        dispatcher.addConsumerProfile(consumerProfile);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Constructor not found for event dispatcher=" + dispatcherName, e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Error creating event dispatcher=" + dispatcherName, e);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Dispatcher/Consumer class not found for event dispatcher=" + dispatcherName, e);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Dispatcher/Consumer instantiation failure for event dispatcher=" + dispatcherName, e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Dispatcher/Consumer access failure for event dispatcher=" + dispatcherName, e);
                }
            } else {
                throw new IllegalStateException("Requested Dispatcher Does Not Exist In DSpace Configuration!");
            }
            return dispatcher;
        }

        public void activateObject(Object arg0, Object arg1) throws Exception {
        }

        public void destroyObject(Object key, Object dispatcher) throws Exception {
            Context ctx = new Context();
            try {
                for (ConsumerProfile cp : ((Dispatcher)dispatcher).getConsumers()) {
                    if (cp == null) continue;
                    cp.getConsumer().finish(ctx);
                }
                ctx.complete();
            }
            catch (Exception e) {
                ctx.abort();
                throw e;
            }
        }

        public void passivateObject(Object arg0, Object arg1) throws Exception {
        }

        public boolean validateObject(Object arg0, Object arg1) {
            return false;
        }

        private void parseEventConfig() {
            Enumeration<?> propertyNames = ConfigurationManager.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String ckey = ((String)propertyNames.nextElement()).trim();
                if (!ckey.startsWith(PROP_PFX) || !ckey.endsWith(".class")) continue;
                String name = ckey.substring(PROP_PFX.length(), ckey.length() - 6);
                String dispatcherClass = ConfigurationManager.getProperty(ckey);
                dispatchers.put(name, dispatcherClass);
            }
        }
    }
}

