/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.Console;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public final class CreateAdministrator {
    private final Context context = new Context();

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CreateAdministrator ca = new CreateAdministrator();
        options.addOption("e", "email", true, "administrator email address");
        options.addOption("f", "first", true, "administrator first name");
        options.addOption("l", "last", true, "administrator last name");
        options.addOption("c", "language", true, "administrator language");
        options.addOption("p", "password", true, "administrator password");
        CommandLine line = parser.parse(options, argv);
        if (line.hasOption("e") && line.hasOption("f") && line.hasOption("l") && line.hasOption("c") && line.hasOption("p")) {
            ca.createAdministrator(line.getOptionValue("e"), line.getOptionValue("f"), line.getOptionValue("l"), line.getOptionValue("c"), line.getOptionValue("p"));
        } else {
            ca.negotiateAdministratorDetails();
        }
    }

    private CreateAdministrator() throws Exception {
    }

    private void negotiateAdministratorDetails() throws Exception {
        Console console = System.console();
        System.out.println("Creating an initial administrator account");
        boolean dataOK = false;
        String email = null;
        String firstName = null;
        String lastName = null;
        char[] password1 = null;
        char[] password2 = null;
        String language = I18nUtil.DEFAULTLOCALE.getLanguage();
        while (!dataOK) {
            System.out.print("E-mail address: ");
            System.out.flush();
            email = console.readLine();
            if (StringUtils.isBlank((String)email)) {
                System.out.println("Please provide an email address.");
                continue;
            }
            email = email.trim();
            System.out.print("First name: ");
            System.out.flush();
            firstName = console.readLine();
            if (firstName != null) {
                firstName = firstName.trim();
            }
            System.out.print("Last name: ");
            System.out.flush();
            lastName = console.readLine();
            if (lastName != null) {
                lastName = lastName.trim();
            }
            if (ConfigurationManager.getProperty("webui.supported.locales") != null) {
                System.out.println("Select one of the following languages: " + ConfigurationManager.getProperty("webui.supported.locales"));
                System.out.print("Language: ");
                System.out.flush();
                language = console.readLine();
                if (language != null) {
                    language = language.trim();
                    language = I18nUtil.getSupportedLocale(new Locale(language)).getLanguage();
                }
            }
            System.out.println("Password will not display on screen.");
            System.out.print("Password: ");
            System.out.flush();
            password1 = console.readPassword();
            System.out.print("Again to confirm: ");
            System.out.flush();
            password2 = console.readPassword();
            if (password1.length > 1 && Arrays.equals(password1, password2)) {
                System.out.print("Is the above data correct? (y or n): ");
                System.out.flush();
                String s = console.readLine();
                if (s == null || !(s = s.trim()).toLowerCase().startsWith("y")) continue;
                dataOK = true;
                continue;
            }
            System.out.println("Passwords don't match");
        }
        this.createAdministrator(email, firstName, lastName, language, String.valueOf(password1));
        Arrays.fill(password1, ' ');
        Arrays.fill(password2, ' ');
    }

    private void createAdministrator(String email, String first, String last, String language, String pw) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group admins = Group.find(this.context, 1);
        if (admins == null) {
            throw new IllegalStateException("Error, no admin group (group 1) found");
        }
        EPerson eperson = EPerson.findByEmail(this.context, email);
        if (eperson == null) {
            eperson = EPerson.create(this.context);
            eperson.setEmail(email);
            eperson.setCanLogIn(true);
            eperson.setRequireCertificate(false);
            eperson.setSelfRegistered(false);
        }
        eperson.setLastName(last);
        eperson.setFirstName(first);
        eperson.setLanguage(language);
        eperson.setPassword(pw);
        eperson.update();
        admins.addMember(eperson);
        admins.update();
        this.context.complete();
        System.out.println("Administrator account created");
    }
}

