/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.dspace.administer.RegistryExportException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class MetadataExporter {
    static Map<Integer, String> schemaMap = new HashMap<Integer, String>();

    public static void main(String[] args) throws ParseException, SQLException, IOException, SAXException, RegistryExportException {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("f", "file", true, "output xml file for registry");
        options.addOption("s", "schema", true, "the name of the schema to export");
        CommandLine line = parser.parse(options, args);
        String file = null;
        String schema = null;
        if (line.hasOption('f')) {
            file = line.getOptionValue('f');
        } else {
            MetadataExporter.usage();
            System.exit(0);
        }
        if (line.hasOption('s')) {
            schema = line.getOptionValue('s');
        }
        MetadataExporter.saveRegistry(file, schema);
    }

    public static void saveRegistry(String file, String schema) throws SQLException, IOException, SAXException, RegistryExportException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        OutputFormat xmlFormat = new OutputFormat("xml", "UTF-8", true);
        xmlFormat.setLineWidth(120);
        xmlFormat.setIndent(4);
        XMLSerializer xmlSerializer = new XMLSerializer((Writer)new BufferedWriter(new FileWriter(file)), xmlFormat);
        xmlSerializer.startDocument();
        xmlSerializer.startElement("dspace-dc-types", null);
        MetadataExporter.saveSchema(context, xmlSerializer, schema);
        MetadataField[] mdFields = null;
        if (schema != null && !"".equals(schema)) {
            MetadataSchema mdSchema = MetadataSchema.find(context, schema);
            if (mdSchema == null) {
                throw new RegistryExportException("no schema to export");
            }
            mdFields = MetadataField.findAllInSchema(context, mdSchema.getSchemaID());
        } else {
            mdFields = MetadataField.findAll(context);
        }
        for (MetadataField mdField : mdFields) {
            MetadataExporter.saveType(context, xmlSerializer, mdField);
        }
        xmlSerializer.endElement("dspace-dc-types");
        xmlSerializer.endDocument();
        context.abort();
    }

    public static void saveSchema(Context context, XMLSerializer xmlSerializer, String schema) throws SQLException, SAXException, RegistryExportException {
        if (schema != null && !"".equals(schema)) {
            MetadataSchema mdSchema = MetadataSchema.find(context, schema);
            MetadataExporter.saveSchema(xmlSerializer, mdSchema);
        } else {
            MetadataSchema[] mdSchemas;
            for (MetadataSchema mdSchema : mdSchemas = MetadataSchema.findAll(context)) {
                MetadataExporter.saveSchema(xmlSerializer, mdSchema);
            }
        }
    }

    private static void saveSchema(XMLSerializer xmlSerializer, MetadataSchema mdSchema) throws SAXException, RegistryExportException {
        if (mdSchema == null) {
            throw new RegistryExportException("no schema to export");
        }
        String name = mdSchema.getName();
        String namespace = mdSchema.getNamespace();
        if (name == null || "".equals(name)) {
            System.out.println("name is null, skipping");
            return;
        }
        if (namespace == null || "".equals(namespace)) {
            System.out.println("namespace is null, skipping");
            return;
        }
        xmlSerializer.startElement("dc-schema", null);
        xmlSerializer.startElement("name", null);
        xmlSerializer.characters(name.toCharArray(), 0, name.length());
        xmlSerializer.endElement("name");
        xmlSerializer.startElement("namespace", null);
        xmlSerializer.characters(namespace.toCharArray(), 0, namespace.length());
        xmlSerializer.endElement("namespace");
        xmlSerializer.endElement("dc-schema");
    }

    private static void saveType(Context context, XMLSerializer xmlSerializer, MetadataField mdField) throws SAXException, RegistryExportException, SQLException, IOException {
        if (mdField == null) {
            throw new RegistryExportException("no field to export");
        }
        String schemaName = MetadataExporter.getSchemaName(context, mdField);
        String element = mdField.getElement();
        String qualifier = mdField.getQualifier();
        String scopeNote = mdField.getScopeNote();
        if (schemaName == null || element == null) {
            throw new RegistryExportException("incomplete field information");
        }
        xmlSerializer.startElement("dc-type", null);
        xmlSerializer.startElement("schema", null);
        xmlSerializer.characters(schemaName.toCharArray(), 0, schemaName.length());
        xmlSerializer.endElement("schema");
        xmlSerializer.startElement("element", null);
        xmlSerializer.characters(element.toCharArray(), 0, element.length());
        xmlSerializer.endElement("element");
        if (qualifier != null) {
            xmlSerializer.startElement("qualifier", null);
            xmlSerializer.characters(qualifier.toCharArray(), 0, qualifier.length());
            xmlSerializer.endElement("qualifier");
        } else {
            xmlSerializer.comment("unqualified");
        }
        if (scopeNote != null) {
            xmlSerializer.startElement("scope_note", null);
            xmlSerializer.characters(scopeNote.toCharArray(), 0, scopeNote.length());
            xmlSerializer.endElement("scope_note");
        } else {
            xmlSerializer.comment("no scope note");
        }
        xmlSerializer.endElement("dc-type");
    }

    private static String getSchemaName(Context context, MetadataField mdField) throws SQLException, RegistryExportException {
        String name = schemaMap.get(mdField.getSchemaID());
        if (name == null) {
            MetadataSchema mdSchema = MetadataSchema.find(context, mdField.getSchemaID());
            if (mdSchema != null) {
                name = mdSchema.getName();
                schemaMap.put(mdSchema.getSchemaID(), name);
            } else {
                throw new RegistryExportException("Can't get schema name for field");
            }
        }
        return name;
    }

    public static void usage() {
        String usage = "Use this class with the following options:\n -f <xml output file> : specify the output file for the schemas\n -s <schema> : name of the schema to export\n";
        System.out.println(usage);
    }
}

