/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.MessagingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.itemexport.ItemExportException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;

public class ItemExport {
    private static final int SUBDIR_LIMIT = 0;
    public static final String COMPRESSED_EXPORT_MIME_TYPE = "application/zip";
    private static Logger log = Logger.getLogger(ItemExport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "type", true, "type: COLLECTION or ITEM");
        options.addOption("i", "id", true, "ID or handle of thing to export");
        options.addOption("d", "dest", true, "destination where you want items to go");
        options.addOption("m", "migrate", false, "export for migration (remove handle and metadata that will be re-created in new system)");
        options.addOption("n", "number", true, "sequence number to begin exporting items with");
        options.addOption("z", "zip", true, "export as zip file (specify filename e.g. export.zip)");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, argv);
        String typeString = null;
        String destDirName = null;
        String myIDString = null;
        int seqStart = -1;
        int myType = -1;
        Item myItem = null;
        Collection mycollection = null;
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("ItemExport\n", options);
            System.out.println("\nfull collection: ItemExport -t COLLECTION -i ID -d dest -n number");
            System.out.println("singleitem:       ItemExport -t ITEM -i ID -d dest -n number");
            System.exit(0);
        }
        if (line.hasOption('t')) {
            typeString = line.getOptionValue('t');
            if ("ITEM".equals(typeString)) {
                myType = 2;
            } else if ("COLLECTION".equals(typeString)) {
                myType = 3;
            }
        }
        if (line.hasOption('i')) {
            myIDString = line.getOptionValue('i');
        }
        if (line.hasOption('d')) {
            destDirName = line.getOptionValue('d');
        }
        if (line.hasOption('n')) {
            seqStart = Integer.parseInt(line.getOptionValue('n'));
        }
        boolean migrate = false;
        if (line.hasOption('m')) {
            migrate = true;
        }
        boolean zip = false;
        String zipFileName = "";
        if (line.hasOption('z')) {
            zip = true;
            zipFileName = line.getOptionValue('z');
        }
        if (myType == -1) {
            System.out.println("type must be either COLLECTION or ITEM (-h for help)");
            System.exit(1);
        }
        if (destDirName == null) {
            System.out.println("destination directory must be set (-h for help)");
            System.exit(1);
        }
        if (seqStart == -1) {
            System.out.println("sequence start number must be set (-h for help)");
            System.exit(1);
        }
        if (myIDString == null) {
            System.out.println("ID must be set to either a database ID or a handle (-h for help)");
            System.exit(1);
        }
        Context c = new Context();
        c.turnOffAuthorisationSystem();
        if (myType == 2) {
            if (myIDString.indexOf(47) != -1) {
                myItem = (Item)HandleManager.resolveToObject(c, myIDString);
                if (myItem == null || myItem.getType() != 2) {
                    myItem = null;
                }
            } else {
                myItem = Item.find(c, Integer.parseInt(myIDString));
            }
            if (myItem == null) {
                System.out.println("Error, item cannot be found: " + myIDString);
            }
        } else {
            if (myIDString.indexOf(47) != -1) {
                mycollection = (Collection)HandleManager.resolveToObject(c, myIDString);
                if (mycollection == null || mycollection.getType() != 3) {
                    mycollection = null;
                }
            } else if (myIDString != null) {
                mycollection = Collection.find(c, Integer.parseInt(myIDString));
            }
            if (mycollection == null) {
                System.out.println("Error, collection cannot be found: " + myIDString);
                System.exit(1);
            }
        }
        if (zip) {
            ItemIterator items;
            if (myItem != null) {
                ArrayList<Integer> myItems = new ArrayList<Integer>();
                myItems.add(myItem.getID());
                items = new ItemIterator(c, myItems);
            } else {
                System.out.println("Exporting from collection: " + myIDString);
                items = mycollection.getItems();
            }
            ItemExport.exportAsZip(c, items, destDirName, zipFileName, seqStart, migrate);
        } else if (myItem != null) {
            ItemExport.exportItem(c, myItem, destDirName, seqStart, migrate);
        } else {
            System.out.println("Exporting from collection: " + myIDString);
            try (ItemIterator i = mycollection.getItems();){
                ItemExport.exportItem(c, i, destDirName, seqStart, migrate);
            }
        }
        c.complete();
    }

    private static void exportItem(Context c, ItemIterator i, String destDirName, int seqStart, boolean migrate) throws Exception {
        int mySequenceNumber = seqStart;
        int counter = -1;
        boolean subDirSuffix = false;
        String fullPath = destDirName;
        String subdir = "";
        System.out.println("Beginning export");
        while (i.hasNext()) {
            System.out.println("Exporting item to " + mySequenceNumber);
            ItemExport.exportItem(c, i.next(), fullPath, mySequenceNumber, migrate);
            ++mySequenceNumber;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void exportItem(Context c, Item myItem, String destDirName, int seqStart, boolean migrate) throws Exception {
        File destDir = new File(destDirName);
        if (!destDir.exists()) throw new Exception("Error, directory " + destDirName + " doesn't exist!");
        File itemDir = new File(destDir + "/" + seqStart);
        System.out.println("Exporting Item " + myItem.getID() + " to " + itemDir);
        if (itemDir.exists()) {
            throw new Exception("Directory " + destDir + "/" + seqStart + " already exists!");
        }
        if (!itemDir.mkdir()) throw new Exception("Error, can't make dir " + itemDir);
        ItemExport.writeMetadata(c, myItem, itemDir, migrate);
        ItemExport.writeBitstreams(c, myItem, itemDir);
        if (migrate) return;
        ItemExport.writeHandle(c, myItem, itemDir);
    }

    private static void writeMetadata(Context c, Item i, File destDir, boolean migrate) throws Exception {
        Metadatum[] dcValues;
        HashSet<String> schemas = new HashSet<String>();
        for (Metadatum dcValue : dcValues = i.getMetadata("*", "*", "*", "*")) {
            schemas.add(dcValue.schema);
        }
        for (String schema : schemas) {
            ItemExport.writeMetadata(c, schema, i, destDir, migrate);
        }
    }

    private static void writeMetadata(Context c, String schema, Item i, File destDir, boolean migrate) throws Exception {
        byte[] utf8;
        BufferedOutputStream out;
        String filename = schema.equals("dc") ? "dublin_core.xml" : "metadata_" + schema + ".xml";
        File outFile = new File(destDir, filename);
        System.out.println("Attempting to create file " + outFile);
        if (outFile.createNewFile()) {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            Metadatum[] dcorevalues = i.getMetadata(schema, "*", "*", "*");
            utf8 = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n".getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            String dcTag = "<dublin_core schema=\"" + schema + "\">\n";
            utf8 = dcTag.getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            String dateIssued = null;
            String dateAccessioned = null;
            for (Metadatum dcv : dcorevalues) {
                String language;
                String qualifier = dcv.qualifier;
                if (qualifier == null) {
                    qualifier = "none";
                }
                language = (language = dcv.language) != null ? " language=\"" + language + "\"" : "";
                utf8 = ("  <dcvalue element=\"" + dcv.element + "\" " + "qualifier=\"" + qualifier + "\"" + language + ">" + Utils.addEntities(dcv.value) + "</dcvalue>\n").getBytes("UTF-8");
                if (!(migrate && (!migrate || "date".equals(dcv.element) && "issued".equals(qualifier) || "date".equals(dcv.element) && "accessioned".equals(qualifier) || "date".equals(dcv.element) && "available".equals(qualifier) || "identifier".equals(dcv.element) && "uri".equals(qualifier) && dcv.value != null && dcv.value.startsWith("http://hdl.handle.net/" + HandleManager.getPrefix() + "/") || "description".equals(dcv.element) && "provenance".equals(qualifier) || "format".equals(dcv.element) && "extent".equals(qualifier) || "format".equals(dcv.element) && "mimetype".equals(qualifier)))) {
                    out.write(utf8, 0, utf8.length);
                }
                if ("date".equals(dcv.element) && "issued".equals(qualifier)) {
                    dateIssued = dcv.value;
                }
                if (!"date".equals(dcv.element) || !"accessioned".equals(qualifier)) continue;
                dateAccessioned = dcv.value;
            }
            if (migrate && dateIssued != null && dateAccessioned != null && !dateIssued.equals(dateAccessioned)) {
                utf8 = ("  <dcvalue element=\"date\" qualifier=\"issued\">" + Utils.addEntities(dateIssued) + "</dcvalue>\n").getBytes("UTF-8");
                out.write(utf8, 0, utf8.length);
            }
        } else {
            throw new Exception("Cannot create dublin_core.xml in " + destDir);
        }
        utf8 = "</dublin_core>\n".getBytes("UTF-8");
        out.write(utf8, 0, utf8.length);
        out.close();
    }

    private static void writeHandle(Context c, Item i, File destDir) throws Exception {
        if (i.getHandle() == null) {
            return;
        }
        String filename = "handle";
        File outFile = new File(destDir, filename);
        if (!outFile.createNewFile()) {
            throw new Exception("Cannot create file " + filename + " in " + destDir);
        }
        PrintWriter out = new PrintWriter(new FileWriter(outFile));
        out.println(i.getHandle());
        out.close();
    }

    private static void writeBitstreams(Context c, Item i, File destDir) throws Exception {
        PrintWriter out;
        File outFile = new File(destDir, "contents");
        if (outFile.createNewFile()) {
            out = new PrintWriter(new FileWriter(outFile));
            Bundle[] bundles = i.getBundles();
            for (int j = 0; j < bundles.length; ++j) {
                Bitstream[] bitstreams = bundles[j].getBitstreams();
                String bundleName = bundles[j].getName();
                for (int k = 0; k < bitstreams.length; ++k) {
                    String myName;
                    Bitstream b = bitstreams[k];
                    String oldName = myName = b.getName();
                    String description = b.getDescription();
                    description = !StringUtils.isEmpty((String)description) ? "\tdescription:" + description : "";
                    String primary = "";
                    if (bundles[j].getPrimaryBitstreamID() == b.getID()) {
                        primary = "\tprimary:true ";
                    }
                    int myPrefix = 1;
                    InputStream is = b.retrieve();
                    boolean isDone = false;
                    while (!isDone) {
                        File fout;
                        if (myName.contains(File.separator)) {
                            String dirs = myName.substring(0, myName.lastIndexOf(File.separator));
                            File fdirs = new File(destDir + File.separator + dirs);
                            if (!fdirs.exists() && !fdirs.mkdirs()) {
                                log.error((Object)"Unable to create destination directory");
                            }
                        }
                        if ((fout = new File(destDir, myName)).createNewFile()) {
                            FileOutputStream fos = new FileOutputStream(fout);
                            Utils.bufferedCopy(is, fos);
                            is.close();
                            fos.close();
                            if (b.isRegisteredBitstream()) {
                                out.println("-r -s " + b.getStoreNumber() + " -f " + myName + "\tbundle:" + bundleName + primary + description);
                            } else {
                                out.println(myName + "\tbundle:" + bundleName + primary + description);
                            }
                            isDone = true;
                            continue;
                        }
                        myName = myPrefix + "_" + oldName;
                        ++myPrefix;
                    }
                }
            }
        } else {
            throw new Exception("Cannot create contents in " + destDir);
        }
        out.close();
    }

    public static void exportAsZip(Context context, ItemIterator items, String destDirName, String zipFileName, int seqStart, boolean migrate) throws Exception {
        File dnDir;
        String workDir = ItemExport.getExportWorkDirectory() + System.getProperty("file.separator") + zipFileName;
        File wkDir = new File(workDir);
        if (!wkDir.exists() && !wkDir.mkdirs()) {
            log.error((Object)"Unable to create working direcory");
        }
        if (!(dnDir = new File(destDirName)).exists() && !dnDir.mkdirs()) {
            log.error((Object)"Unable to create destination directory");
        }
        ItemExport.exportItem(context, items, workDir, seqStart, migrate);
        ItemExport.zip(workDir, destDirName + System.getProperty("file.separator") + zipFileName);
    }

    public static void createDownloadableExport(DSpaceObject dso, Context context, boolean migrate) throws Exception {
        EPerson eperson = context.getCurrentUser();
        ArrayList<DSpaceObject> list = new ArrayList<DSpaceObject>(1);
        list.add(dso);
        ItemExport.processDownloadableExport(list, context, eperson == null ? null : eperson.getEmail(), migrate);
    }

    public static void createDownloadableExport(List<DSpaceObject> dsObjects, Context context, boolean migrate) throws Exception {
        EPerson eperson = context.getCurrentUser();
        ItemExport.processDownloadableExport(dsObjects, context, eperson == null ? null : eperson.getEmail(), migrate);
    }

    public static void createDownloadableExport(DSpaceObject dso, Context context, String additionalEmail, boolean migrate) throws Exception {
        ArrayList<DSpaceObject> list = new ArrayList<DSpaceObject>(1);
        list.add(dso);
        ItemExport.processDownloadableExport(list, context, additionalEmail, migrate);
    }

    public static void createDownloadableExport(List<DSpaceObject> dsObjects, Context context, String additionalEmail, boolean migrate) throws Exception {
        ItemExport.processDownloadableExport(dsObjects, context, additionalEmail, migrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDownloadableExport(List<DSpaceObject> dsObjects, Context context, String additionalEmail, boolean toMigrate) throws Exception {
        final EPerson eperson = context.getCurrentUser();
        final boolean migrate = toMigrate;
        ItemExport.deleteOldExportArchives();
        double size = 0.0;
        final HashMap itemsMap = new HashMap();
        for (DSpaceObject dso : dsObjects) {
            if (dso.getType() == 4) {
                Community community = (Community)dso;
                Collection[] collections = community.getAllCollections();
                for (DSpaceObject dSpaceObject : collections) {
                    ArrayList<Integer> items = new ArrayList<Integer>();
                    ItemIterator iitems = ((Collection)dSpaceObject).getItems();
                    try {
                        while (iitems.hasNext()) {
                            Item item = iitems.next();
                            Bundle[] bundles = item.getBundles();
                            for (DSpaceObject dSpaceObject2 : bundles) {
                                Bitstream[] bitstreams;
                                for (Bitstream bit : bitstreams = ((Bundle)dSpaceObject2).getBitstreams()) {
                                    size += (double)bit.getSize();
                                }
                            }
                            items.add(item.getID());
                        }
                    }
                    finally {
                        if (iitems != null) {
                            iitems.close();
                        }
                        if (items.size() > 0) {
                            itemsMap.put("collection_" + ((Collection)dSpaceObject).getID(), items);
                        }
                    }
                }
                continue;
            }
            if (dso.getType() == 3) {
                Collection collection = (Collection)dso;
                ArrayList<Integer> items = new ArrayList<Integer>();
                ItemIterator iitems = collection.getItems();
                try {
                    while (iitems.hasNext()) {
                        Bundle[] bundles;
                        Item item = iitems.next();
                        for (Bundle bundle : bundles = item.getBundles()) {
                            Bitstream[] bitstreams = bundle.getBitstreams();
                            for (DSpaceObject dSpaceObject : bitstreams) {
                                size += (double)((Bitstream)dSpaceObject).getSize();
                            }
                        }
                        items.add(item.getID());
                    }
                    continue;
                }
                finally {
                    if (iitems != null) {
                        iitems.close();
                    }
                    if (items.size() > 0) {
                        itemsMap.put("collection_" + collection.getID(), items);
                    }
                    continue;
                }
            }
            if (dso.getType() != 2) continue;
            Item item = (Item)dso;
            Bundle[] bundles = item.getBundles();
            for (DSpaceObject dSpaceObject : bundles) {
                Bitstream[] bitstreams;
                for (Bitstream bit : bitstreams = ((Bundle)dSpaceObject).getBitstreams()) {
                    size += (double)bit.getSize();
                }
            }
            ArrayList<Integer> items = new ArrayList<Integer>();
            items.add(item.getID());
            itemsMap.put("item_" + item.getID(), items);
        }
        String megaBytes = ConfigurationManager.getProperty("org.dspace.app.itemexport.max.size");
        if (megaBytes != null) {
            float maxSize = 0.0f;
            try {
                maxSize = Float.parseFloat(megaBytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxSize > 0.0f && (double)maxSize < size / 1048576.0) {
                throw new ItemExportException(0, "The overall size of this export is too large.  Please contact your administrator for more information.");
            }
        }
        if (itemsMap.size() > 0) {
            Thread go = new Thread(){

                @Override
                public void run() {
                    Context context = null;
                    ItemIterator iitems = null;
                    try {
                        context = new Context();
                        context.turnOffAuthorisationSystem();
                        String fileName = ItemExport.assembleFileName("item", eperson, new Date());
                        String workParentDir = ItemExport.getExportWorkDirectory() + System.getProperty("file.separator") + fileName;
                        String downloadDir = ItemExport.getExportDownloadDirectory(eperson.getID());
                        File dnDir = new File(downloadDir);
                        if (!dnDir.exists() && !dnDir.mkdirs()) {
                            log.error((Object)"Unable to create download directory");
                        }
                        for (String keyName : itemsMap.keySet()) {
                            iitems = new ItemIterator(context, (List)itemsMap.get(keyName));
                            String workDir = workParentDir + System.getProperty("file.separator") + keyName;
                            File wkDir = new File(workDir);
                            if (!wkDir.exists() && !wkDir.mkdirs()) {
                                log.error((Object)"Unable to create working directory");
                            }
                            ItemExport.exportItem(context, iitems, workDir, 1, migrate);
                            iitems.close();
                        }
                        ItemExport.zip(workParentDir, downloadDir + System.getProperty("file.separator") + fileName + ".zip");
                        ItemExport.emailSuccessMessage(context, eperson, fileName + ".zip");
                        context.restoreAuthSystemState();
                    }
                    catch (Exception e1) {
                        try {
                            ItemExport.emailErrorMessage(eperson, e1.getMessage());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new IllegalStateException(e1);
                    }
                    finally {
                        if (iitems != null) {
                            iitems.close();
                        }
                        try {
                            context.complete();
                        }
                        catch (SQLException sqle) {
                            context.abort();
                        }
                    }
                }
            };
            go.isDaemon();
            go.start();
        } else {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            ItemExport.emailErrorMessage(eperson, I18nUtil.getMessage("org.dspace.app.itemexport.no-result", supportedLocale));
        }
    }

    public static String assembleFileName(String type, EPerson eperson, Date date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MMM_dd");
        String downloadDir = ItemExport.getExportDownloadDirectory(eperson.getID());
        int count = 1;
        boolean exists = true;
        String fileName = null;
        while (exists) {
            fileName = type + "_export_" + sdf.format(date) + "_" + count + "_" + eperson.getID();
            exists = new File(downloadDir + System.getProperty("file.separator") + fileName + ".zip").exists();
            ++count;
        }
        return fileName;
    }

    public static String getExportDownloadDirectory(int ePersonID) throws Exception {
        String downloadDir = ConfigurationManager.getProperty("org.dspace.app.itemexport.download.dir");
        if (downloadDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.itemexport.download.dir' does not exist.");
        }
        return downloadDir + System.getProperty("file.separator") + ePersonID;
    }

    public static String getExportWorkDirectory() throws Exception {
        String exportDir = ConfigurationManager.getProperty("org.dspace.app.itemexport.work.dir");
        if (exportDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.itemexport.work.dir' does not exist.");
        }
        return exportDir;
    }

    public static InputStream getExportDownloadInputStream(String fileName, EPerson eperson) throws Exception {
        File file = new File(ItemExport.getExportDownloadDirectory(eperson.getID()) + System.getProperty("file.separator") + fileName);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static long getExportFileSize(String fileName) throws Exception {
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        File file = new File(ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("The file " + ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName + " does not exist.");
        }
        return file.length();
    }

    public static long getExportFileLastModified(String fileName) throws Exception {
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        File file = new File(ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("The file " + ItemExport.getExportDownloadDirectory(Integer.parseInt(strID)) + System.getProperty("file.separator") + fileName + " does not exist.");
        }
        return file.lastModified();
    }

    public static boolean canDownload(Context context, String fileName) {
        EPerson eperson = context.getCurrentUser();
        if (eperson == null) {
            return false;
        }
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        try {
            if (Integer.parseInt(strID) == eperson.getID()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static List<String> getExportsAvailable(EPerson eperson) throws Exception {
        File downloadDir = new File(ItemExport.getExportDownloadDirectory(eperson.getID()));
        if (!downloadDir.exists() || !downloadDir.isDirectory()) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String fileName : downloadDir.list()) {
            if (!fileName.contains("export") || !fileName.endsWith(".zip")) continue;
            fileNames.add(fileName);
        }
        if (fileNames.size() > 0) {
            return fileNames;
        }
        return null;
    }

    public static void deleteOldExportArchives(int epersonID) throws Exception {
        int hours = ConfigurationManager.getIntProperty("org.dspace.app.itemexport.life.span.hours");
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        now.add(10, -hours);
        File downloadDir = new File(ItemExport.getExportDownloadDirectory(epersonID));
        if (downloadDir.exists()) {
            File[] files;
            for (File file : files = downloadDir.listFiles()) {
                if (file.lastModified() >= now.getTimeInMillis() || file.delete()) continue;
                log.error((Object)"Unable to delete export file");
            }
        }
    }

    public static void deleteOldExportArchives() throws Exception {
        int hours = ConfigurationManager.getIntProperty("org.dspace.app.itemexport.life.span.hours");
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        now.add(10, -hours);
        File downloadDir = new File(ConfigurationManager.getProperty("org.dspace.app.itemexport.download.dir"));
        if (downloadDir.exists()) {
            File[] dirs;
            for (File dir : dirs = downloadDir.listFiles()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (file.lastModified() >= now.getTimeInMillis() || file.delete()) continue;
                    log.error((Object)"Unable to delete old files");
                }
                if (dir.listFiles().length != 0 || dir.delete()) continue;
                log.error((Object)"Unable to delete directory");
            }
        }
    }

    public static void emailSuccessMessage(Context context, EPerson eperson, String fileName) throws MessagingException {
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "export_success"));
            email.addRecipient(eperson.getEmail());
            email.addArgument(ConfigurationManager.getProperty("dspace.url") + "/exportdownload/" + fileName);
            email.addArgument(ConfigurationManager.getProperty("org.dspace.app.itemexport.life.span.hours"));
            email.send();
        }
        catch (Exception e) {
            log.warn((Object)LogManager.getHeader(context, "emailSuccessMessage", "cannot notify user of export"), (Throwable)e);
        }
    }

    public static void emailErrorMessage(EPerson eperson, String error) throws MessagingException {
        log.warn((Object)("An error occurred during item export, the user will be notified. " + error));
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "export_error"));
            email.addRecipient(eperson.getEmail());
            email.addArgument(error);
            email.addArgument(ConfigurationManager.getProperty("dspace.url") + "/feedback");
            email.send();
        }
        catch (Exception e) {
            log.warn((Object)"error during item export error notification", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String strSource, String target) throws Exception {
        String tempFileName = target + "_tmp";
        try (ZipOutputStream cpZipOutputStream = null;){
            File cpFile = new File(strSource);
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                return;
            }
            File targetFile = new File(tempFileName);
            if (!targetFile.createNewFile()) {
                log.warn((Object)("Target file already exists: " + targetFile.getName()));
            }
            FileOutputStream fos = new FileOutputStream(tempFileName);
            cpZipOutputStream = new ZipOutputStream(fos);
            cpZipOutputStream.setLevel(9);
            ItemExport.zipFiles(cpFile, strSource, tempFileName, cpZipOutputStream);
            cpZipOutputStream.finish();
            cpZipOutputStream.close();
            cpZipOutputStream = null;
            System.gc();
            ItemExport.deleteDirectory(cpFile);
            if (!targetFile.renameTo(new File(target))) {
                log.error((Object)"Unable to rename file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFiles(File cpFile, String strSource, String strTarget, ZipOutputStream cpZipOutputStream) throws Exception {
        int DATA_BLOCK_SIZE = 2048;
        FileInputStream cpFileInputStream = null;
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                ItemExport.zipFiles(fList[i], strSource, strTarget, cpZipOutputStream);
            }
        } else {
            try {
                int byteCount;
                if (cpFile.getAbsolutePath().equalsIgnoreCase(strTarget)) {
                    return;
                }
                String strAbsPath = cpFile.getPath();
                String strZipEntryName = strAbsPath.substring(strSource.length() + 1, strAbsPath.length());
                cpFileInputStream = new FileInputStream(cpFile);
                ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
                cpZipOutputStream.putNextEntry(cpZipEntry);
                byte[] b = new byte[2048];
                while ((byteCount = cpFileInputStream.read(b, 0, 2048)) != -1) {
                    cpZipOutputStream.write(b, 0, byteCount);
                }
            }
            finally {
                if (cpFileInputStream != null) {
                    cpFileInputStream.close();
                }
                cpZipOutputStream.closeEntry();
            }
        }
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ItemExport.deleteDirectory(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                log.error((Object)("Unable to delete file: " + files[i].getName()));
            }
        }
        boolean pathDeleted = path.delete();
        return pathDeleted;
    }
}

