/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Community
extends DSpaceObject {
    private static final Logger log = Logger.getLogger(Community.class);
    private final TableRow communityRow;
    private Bitstream logo;
    private String handle;
    private boolean modified;
    private Group admins;
    public static final String COPYRIGHT_TEXT = "copyright_text";
    public static final String INTRODUCTORY_TEXT = "introductory_text";
    public static final String SHORT_DESCRIPTION = "short_description";
    public static final String SIDEBAR_TEXT = "side_bar_text";

    Community(Context context, TableRow row) throws SQLException {
        super(context);
        if (null == row.getTable()) {
            row.setTable("community");
        }
        this.communityRow = row;
        this.logo = this.communityRow.isColumnNull("logo_bitstream_id") ? null : Bitstream.find(this.ourContext, this.communityRow.getIntColumn("logo_bitstream_id"));
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("community_id"));
        this.modified = false;
        this.admins = this.groupFromColumn("admin");
        this.clearDetails();
    }

    public static Community find(Context context, int id) throws SQLException {
        Community fromCache = (Community)context.fromCache(Community.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "community", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_community", "not_found,community_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_community", "community_id=" + id));
        }
        return new Community(context, row);
    }

    public static Community create(Community parent, Context context) throws SQLException, AuthorizeException {
        return Community.create(parent, context, null);
    }

    public static Community create(Community parent, Context context, String handle) throws SQLException, AuthorizeException {
        if (!(AuthorizeManager.isAdmin(context) || parent != null && AuthorizeManager.authorizeActionBoolean(context, parent, 3))) {
            throw new AuthorizeException("Only administrators can create communities");
        }
        TableRow row = DatabaseManager.create(context, "community");
        Community c = new Community(context, row);
        try {
            c.handle = handle == null ? HandleManager.createHandle(context, c) : HandleManager.createHandle(context, c, handle);
        }
        catch (IllegalStateException ie) {
            try {
                if (c != null) {
                    c.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ie;
        }
        if (parent != null) {
            parent.addSubcommunity(c);
        }
        Group anonymousGroup = Group.find(context, 0);
        ResourcePolicy myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(0);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        context.addEvent(new Event(1, 4, c.getID(), c.handle, c.getIdentifiers(context)));
        if (parent == null) {
            context.addEvent(new Event(8, 5, 0, 4, c.getID(), c.handle, c.getIdentifiers(context)));
        }
        log.info((Object)(LogManager.getHeader(context, "create_community", "community_id=" + row.getIntColumn("community_id")) + ",handle=" + c.handle));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Community[] findAll(Context context) throws SQLException {
        TableRowIterator tri = null;
        try {
            String query = "SELECT c.* FROM community c LEFT JOIN metadatavalue m on (m.resource_id = c.community_id and m.resource_type_id = ? and m.metadata_field_id = ?) ";
            query = DatabaseManager.isOracle() ? query + " ORDER BY cast(m.text_value as varchar2(128))" : query + " ORDER BY m.text_value";
            tri = DatabaseManager.query(context, query, 4, MetadataField.findByElement(context, MetadataSchema.find(context, "dc").getSchemaID(), "title", null).getFieldID());
        }
        catch (SQLException e) {
            log.error((Object)"Find all Communities - ", (Throwable)e);
            throw e;
        }
        ArrayList<Community> communities = new ArrayList<Community>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next(context);
                Community fromCache = (Community)context.fromCache(Community.class, row.getIntColumn("community_id"));
                if (fromCache != null) {
                    communities.add(fromCache);
                    continue;
                }
                communities.add(new Community(context, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Community[] findAllTop(Context context) throws SQLException {
        TableRowIterator tri = null;
        try {
            String query = "SELECT c.* FROM community c  LEFT JOIN metadatavalue m on (m.resource_id = c.community_id and m.resource_type_id = ? and m.metadata_field_id = ?) WHERE NOT c.community_id IN (SELECT child_comm_id FROM community2community) ";
            query = DatabaseManager.isOracle() ? query + " ORDER BY cast(m.text_value as varchar2(128))" : query + " ORDER BY m.text_value";
            tri = DatabaseManager.query(context, query, 4, MetadataField.findByElement(context, MetadataSchema.find(context, "dc").getSchemaID(), "title", null).getFieldID());
        }
        catch (SQLException e) {
            log.error((Object)"Find all Top Communities - ", (Throwable)e);
            throw e;
        }
        ArrayList<Community> topCommunities = new ArrayList<Community>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next(context);
                Community fromCache = (Community)context.fromCache(Community.class, row.getIntColumn("community_id"));
                if (fromCache != null) {
                    topCommunities.add(fromCache);
                    continue;
                }
                topCommunities.add(new Community(context, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Community[] communityArray = new Community[topCommunities.size()];
        communityArray = topCommunities.toArray(communityArray);
        return communityArray;
    }

    @Override
    public int getID() {
        return this.communityRow.getIntColumn("community_id");
    }

    @Override
    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    @Override
    @Deprecated
    public String getMetadata(String field) {
        String[] MDValue = this.getMDValueByLegacyField(field);
        String value = this.getMetadataFirstValue(MDValue[0], MDValue[1], MDValue[2], "*");
        return value == null ? "" : value;
    }

    @Deprecated
    public void setMetadata(String field, String value) throws MissingResourceException {
        if (field.trim().equals("name") && (value == null || value.trim().equals(""))) {
            try {
                value = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                value = "Untitled";
            }
        }
        String[] MDValue = this.getMDValueByLegacyField(field);
        if (value == null) {
            this.clearMetadata(MDValue[0], MDValue[1], MDValue[2], "*");
            this.modifiedMetadata = true;
        } else {
            this.setMetadataSingleValue(MDValue[0], MDValue[1], MDValue[2], null, value);
        }
        this.addDetails(field);
    }

    @Override
    public String getName() {
        String value = this.getMetadataFirstValue("dc", "title", null, "*");
        return value == null ? "" : value;
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public Bitstream setLogo(InputStream is) throws AuthorizeException, IOException, SQLException {
        if (is != null || !AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 2)) {
            this.canEdit();
        }
        if (this.logo != null) {
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_logo", "community_id=" + this.getID()));
            this.communityRow.setColumnNull("logo_bitstream_id");
            this.logo.delete();
            this.logo = null;
        }
        if (is != null) {
            Bitstream newLogo = Bitstream.create(this.ourContext, is);
            this.communityRow.setColumn("logo_bitstream_id", newLogo.getID());
            this.logo = newLogo;
            List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, this, 0);
            AuthorizeManager.addPolicies(this.ourContext, policies, newLogo);
            log.info((Object)LogManager.getHeader(this.ourContext, "set_logo", "community_id=" + this.getID() + "logo_bitstream_id=" + newLogo.getID()));
        }
        this.modified = true;
        return this.logo;
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        this.canEdit();
        log.info((Object)LogManager.getHeader(this.ourContext, "update_community", "community_id=" + this.getID()));
        DatabaseManager.update(this.ourContext, this.communityRow);
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 4, this.getID(), null, this.getIdentifiers(this.ourContext)));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.updateMetadata();
            this.clearDetails();
        }
    }

    public Group createAdministrators() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageAdminGroup(this.ourContext, this);
        if (this.admins == null) {
            this.ourContext.turnOffAuthorisationSystem();
            this.admins = Group.create(this.ourContext);
            this.ourContext.restoreAuthSystemState();
            this.admins.setName("COMMUNITY_" + this.getID() + "_ADMIN");
            this.admins.update();
        }
        AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 11, this.admins);
        this.communityRow.setColumn("admin", this.admins.getID());
        this.modified = true;
        return this.admins;
    }

    public void removeAdministrators() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeRemoveAdminGroup(this.ourContext, this);
        if (this.admins == null) {
            return;
        }
        this.communityRow.setColumnNull("admin");
        this.admins = null;
        this.modified = true;
    }

    public Group getAdministrators() {
        return this.admins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection[] getCollections() throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        TableRowIterator tri = null;
        try {
            String query = "SELECT c.* FROM community2collection c2c, collection c LEFT JOIN metadatavalue m on (m.resource_id = c.collection_id and m.resource_type_id = ? and m.metadata_field_id = ?) WHERE c2c.collection_id=c.collection_id AND c2c.community_id=? ";
            query = DatabaseManager.isOracle() ? query + " ORDER BY cast(m.text_value as varchar2(128))" : query + " ORDER BY m.text_value";
            tri = DatabaseManager.query(this.ourContext, query, 3, MetadataField.findByElement(this.ourContext, MetadataSchema.find(this.ourContext, "dc").getSchemaID(), "title", null).getFieldID(), this.getID());
        }
        catch (SQLException e) {
            log.error((Object)"Find all Collections for this community - ", (Throwable)e);
            throw e;
        }
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next(this.ourContext);
                Collection fromCache = (Collection)this.ourContext.fromCache(Collection.class, row.getIntColumn("collection_id"));
                if (fromCache != null) {
                    collections.add(fromCache);
                    continue;
                }
                collections.add(new Collection(this.ourContext, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Community[] getSubcommunities() throws SQLException {
        ArrayList<Community> subcommunities = new ArrayList<Community>();
        TableRowIterator tri = null;
        try {
            String query = "SELECT c.* FROM community2community c2c, community c LEFT JOIN metadatavalue m on (m.resource_id = c.community_id and m.resource_type_id = ? and m.metadata_field_id = ?) WHERE c2c.child_comm_id=c.community_id AND c2c.parent_comm_id= ? ";
            query = DatabaseManager.isOracle() ? query + " ORDER BY cast(m.text_value as varchar2(128))" : query + " ORDER BY m.text_value";
            tri = DatabaseManager.query(this.ourContext, query, 4, MetadataField.findByElement(this.ourContext, MetadataSchema.find(this.ourContext, "dc").getSchemaID(), "title", null).getFieldID(), this.getID());
        }
        catch (SQLException e) {
            log.error((Object)"Find all Sub Communities - ", (Throwable)e);
            throw e;
        }
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next(this.ourContext);
                Community fromCache = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
                if (fromCache != null) {
                    subcommunities.add(fromCache);
                    continue;
                }
                subcommunities.add(new Community(this.ourContext, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Community[] communityArray = new Community[subcommunities.size()];
        communityArray = subcommunities.toArray(communityArray);
        return communityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Community getParentCommunity() throws SQLException {
        Community parentCommunity = null;
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2community WHERE community2community.parent_comm_id=community.community_id AND community2community.child_comm_id= ? ", this.getID());){
            if (tri.hasNext()) {
                TableRow row = tri.next(this.ourContext);
                Community fromCache = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
                parentCommunity = fromCache != null ? fromCache : new Community(this.ourContext, row);
            }
        }
        return parentCommunity;
    }

    public Community[] getAllParents() throws SQLException {
        ArrayList<Community> parentList = new ArrayList<Community>();
        for (Community parent = this.getParentCommunity(); parent != null; parent = parent.getParentCommunity()) {
            parentList.add(parent);
        }
        Community[] communityArray = new Community[parentList.size()];
        communityArray = parentList.toArray(communityArray);
        return communityArray;
    }

    public Collection[] getAllCollections() throws SQLException {
        ArrayList<Collection> collectionList = new ArrayList<Collection>();
        for (Community community : this.getSubcommunities()) {
            this.addCollectionList(community, collectionList);
        }
        for (DSpaceObject dSpaceObject : this.getCollections()) {
            collectionList.add((Collection)dSpaceObject);
        }
        Collection[] collectionArray = new Collection[collectionList.size()];
        collectionArray = collectionList.toArray(collectionArray);
        return collectionArray;
    }

    private void addCollectionList(Community community, List<Collection> collectionList) throws SQLException {
        for (Community community2 : community.getSubcommunities()) {
            this.addCollectionList(community2, collectionList);
        }
        for (DSpaceObject dSpaceObject : community.getCollections()) {
            collectionList.add((Collection)dSpaceObject);
        }
    }

    public Collection createCollection() throws SQLException, AuthorizeException {
        return this.createCollection(null);
    }

    public Collection createCollection(String handle) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Collection c = Collection.create(this.ourContext, handle);
        this.addCollection(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollection(Collection c) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_collection", "community_id=" + this.getID() + ",collection_id=" + c.getID()));
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community2collection", "SELECT * FROM community2collection WHERE community_id= ? AND collection_id= ? ", this.getID(), c.getID());){
            if (!tri.hasNext()) {
                TableRow mappingRow = DatabaseManager.row("community2collection");
                mappingRow.setColumn("community_id", this.getID());
                mappingRow.setColumn("collection_id", c.getID());
                this.ourContext.addEvent(new Event(8, 4, this.getID(), 3, c.getID(), c.getHandle(), this.getIdentifiers(this.ourContext)));
                DatabaseManager.insert(this.ourContext, mappingRow);
            }
        }
    }

    public Community createSubcommunity() throws SQLException, AuthorizeException {
        return this.createSubcommunity(null);
    }

    public Community createSubcommunity(String handle) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Community c = Community.create(this, this.ourContext, handle);
        this.addSubcommunity(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubcommunity(Community c) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_subcommunity", "parent_comm_id=" + this.getID() + ",child_comm_id=" + c.getID()));
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community2community", "SELECT * FROM community2community WHERE parent_comm_id= ? AND child_comm_id= ? ", this.getID(), c.getID());){
            if (!tri.hasNext()) {
                TableRow mappingRow = DatabaseManager.row("community2community");
                mappingRow.setColumn("parent_comm_id", this.getID());
                mappingRow.setColumn("child_comm_id", c.getID());
                this.ourContext.addEvent(new Event(8, 4, this.getID(), 4, c.getID(), c.getHandle(), this.getIdentifiers(this.ourContext)));
                DatabaseManager.insert(this.ourContext, mappingRow);
            }
        }
    }

    public void removeCollection(Collection c) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        try {
            int removedId = c.getID();
            String removedHandle = c.getHandle();
            String[] removedIdentifiers = c.getIdentifiers(this.ourContext);
            TableRow trow = DatabaseManager.querySingle(this.ourContext, "SELECT COUNT(DISTINCT community_id) AS num FROM community2collection WHERE collection_id= ? ", c.getID());
            long numParents = trow.getLongColumn("num");
            DatabaseManager.updateQuery(this.ourContext, "DELETE FROM community2collection WHERE community_id= ? AND collection_id= ? ", this.getID(), c.getID());
            if (numParents == 1L) {
                c.delete();
            }
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_collection", "community_id=" + this.getID() + ",collection_id=" + removedId));
            this.ourContext.addEvent(new Event(16, 4, this.getID(), 3, removedId, removedHandle, removedIdentifiers));
        }
        catch (IOException | SQLException e) {
            this.ourContext.abort();
            throw e;
        }
    }

    public void removeSubcommunity(Community c) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        try {
            int removedId = c.getID();
            String removedHandle = c.getHandle();
            String[] removedIdentifiers = c.getIdentifiers(this.ourContext);
            TableRow trow = DatabaseManager.querySingle(this.ourContext, "SELECT COUNT(DISTINCT parent_comm_id) AS num FROM community2community WHERE child_comm_id= ? ", c.getID());
            long numParents = trow.getLongColumn("num");
            DatabaseManager.updateQuery(this.ourContext, "DELETE FROM community2community WHERE parent_comm_id= ?  AND child_comm_id= ? ", this.getID(), c.getID());
            if (numParents == 1L) {
                c.rawDelete();
            }
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_subcommunity", "parent_comm_id=" + this.getID() + ",child_comm_id=" + removedId));
            this.ourContext.addEvent(new Event(16, 4, this.getID(), 4, removedId, removedHandle, removedIdentifiers));
        }
        catch (IOException | SQLException e) {
            this.ourContext.abort();
            throw e;
        }
    }

    public void delete() throws SQLException, AuthorizeException, IOException {
        Community parent = this.getParentCommunity();
        if (parent != null && !AuthorizeManager.authorizeActionBoolean(this.ourContext, parent, 4)) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 2);
        }
        if (parent == null) {
            this.rawDelete();
            this.ourContext.addEvent(new Event(16, 5, 0, 4, this.getID(), this.getHandle(), this.getIdentifiers(this.ourContext)));
        } else {
            parent.removeSubcommunity(this);
        }
    }

    private void rawDelete() throws SQLException, AuthorizeException, IOException {
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_community", "community_id=" + this.getID()));
        int deletedId = this.getID();
        String deletedHandle = this.getHandle();
        String[] deletedIdentifiers = this.getIdentifiers(this.ourContext);
        this.ourContext.removeCached(this, this.getID());
        for (Collection collection : this.getCollections()) {
            this.removeCollection(collection);
        }
        for (DSpaceObject dSpaceObject : this.getSubcommunities()) {
            this.removeSubcommunity((Community)dSpaceObject);
        }
        this.setLogo(null);
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        this.removeMetadataFromDatabase();
        try {
            ItemCounter ic = new ItemCounter(this.ourContext);
            ic.remove(this);
        }
        catch (ItemCountException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        HandleManager.unbindHandle(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.communityRow);
        Group g = this.getAdministrators();
        if (g != null) {
            g.delete();
        }
        this.ourContext.addEvent(new Event(32, 4, deletedId, deletedHandle, deletedIdentifiers));
    }

    public boolean equals(Object other) {
        if (!(other instanceof Community)) {
            return false;
        }
        return this.getID() == ((Community)other).getID();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getID()).toHashCode();
    }

    private Group groupFromColumn(String col) throws SQLException {
        if (this.communityRow.isColumnNull(col)) {
            return null;
        }
        return Group.find(this.ourContext, this.communityRow.getIntColumn(col));
    }

    @Override
    public int getType() {
        return 4;
    }

    public boolean canEditBoolean() throws SQLException {
        try {
            this.canEdit();
            return true;
        }
        catch (AuthorizeException e) {
            return false;
        }
    }

    public void canEdit() throws AuthorizeException, SQLException {
        Community[] parents = this.getAllParents();
        for (int i = 0; i < parents.length; ++i) {
            if (AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 1)) {
                return;
            }
            if (!AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 3)) continue;
            return;
        }
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
    }

    public int countItems() throws SQLException {
        int total = 0;
        Collection[] cols = this.getCollections();
        for (int i = 0; i < cols.length; ++i) {
            total += cols[i].countItems();
        }
        Community[] comms = this.getSubcommunities();
        for (int j = 0; j < comms.length; ++j) {
            total += comms[j].countItems();
        }
        return total;
    }

    @Override
    public DSpaceObject getAdminObject(int action) throws SQLException {
        Community adminObject = null;
        switch (action) {
            case 4: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementDeletion()) break;
                adminObject = this;
                break;
            }
            case 2: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementDeletion()) break;
                adminObject = this.getParentCommunity();
                break;
            }
            case 3: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementCreation()) break;
                adminObject = this;
                break;
            }
            default: {
                adminObject = this;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        Community pCommunity = this.getParentCommunity();
        if (pCommunity != null) {
            return pCommunity;
        }
        return null;
    }

    @Override
    public void updateLastModified() {
        this.ourContext.addEvent(new Event(2, 4, this.getID(), null, this.getIdentifiers(this.ourContext)));
    }
}

