/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.storage.URIGenerator;

public class LocalURIGenerator
implements URIGenerator {
    private static final Logger log = Logger.getLogger(LocalURIGenerator.class);

    @Override
    public String generateIdentifier(Context context, int type, int id, String handle, String[] identifiers) throws SQLException {
        String urlPrefix = RDFConfiguration.getDSpaceRDFModuleURI() + "/resource/";
        if (type == 5) {
            return urlPrefix + Site.getSiteHandle();
        }
        if (type == 4 || type == 3 || type == 2) {
            if (StringUtils.isEmpty((String)handle)) {
                throw new IllegalArgumentException("Handle is null");
            }
            return urlPrefix + handle;
        }
        return null;
    }

    @Override
    public String generateIdentifier(Context context, DSpaceObject dso) throws SQLException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            return null;
        }
        return this.generateIdentifier(context, dso.getType(), dso.getID(), dso.getHandle(), dso.getIdentifiers(context));
    }
}

