- [Introduction](#Introduction)
- [Additional Config](#Additional-config)
- [Pubmed specific Config](#Pubmed-specific)
	- [Metadata mapping classes](#Metadata-classes)
	- [Service classes](#Service-classes)


# Introduction <a name="Introduction"></a> #

**[First read the base documentation on external importing](../README.md)**
This documentation explains the implementation of the importer framework using pubmed as an example.

The configuration done for pubmed specifically is located at pubmed-integration.xml in dspace/config/spring/api
I will not go into detail to what exactly is configured for the pubmed integration as it is simply a usage of the classes explained [here](../README.md)

# Additional Config <a name="Additional-config"></a> #

To be able to do the lookup for our configured import-service, we need to be able to know what url to use to check for publications.
This can be done by setting the publication.url property though maven using 2 different ways.

- Setting the publication.url property to the address as defined in the configured importservice (PubmedImportService in this case) in the file spring-dspace-addon-import-services.xml. This will check this single configured url for publications.
- Setting the publication url property to an askterisk '*'. This will check all configured importServices for their urls to base the search for publications on.

# Pubmed specific classes Config <a name="Pubmed-specific"></a> #

These classes are simply implementations based of the base classes defined in importer/external. They add characteristic behaviour for services/mapping for the pubmed specific data.

## Metadata mapping classes <a name="Metadata-classes"></a> ##

- "PubmedFieldMapping". An implementation of AbstractMetadataFieldMapping, linking to the bean that serves as the entry point of other metadata mapping
- "PubmedDateMetadatumContributor"/"PubmedLanguageMetadatumContributor". Pubmed specific implementations of the "MetadataContributor" interface

## Service classes <a name="Service-classes"></a> ##

- "GeneratePubmedQueryService". Generates the pubmed query which is used to retrieve the records. This is based on a given item.
- "ImportMetadataSourceServiceImpl". Child class of "AbstractImportMetadataSourceService", retrieving the records from pubmed.