/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;

@Entity
@Table(name="requestitem")
public class RequestItem
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="requestitem_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="requestitem_seq")
    @SequenceGenerator(name="requestitem_seq", sequenceName="requestitem_seq", allocationSize=1)
    private int requestitem_id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="bitstream_id")
    private Bitstream bitstream;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id")
    private Item item;
    @Column(name="request_email", length=64)
    private String reqEmail;
    @Column(name="request_name", length=64)
    private String reqName;
    @Column(name="request_message", columnDefinition="text")
    private String reqMessage;
    @Column(name="token", unique=true, length=48)
    private String token;
    @Column(name="allfiles")
    private boolean allfiles;
    @Column(name="decision_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date decision_date = null;
    @Column(name="expires")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expires = null;
    @Column(name="request_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date request_date = null;
    @Column(name="accept_request")
    private Boolean accept_request = null;

    protected RequestItem() {
    }

    @Override
    public Integer getID() {
        return this.requestitem_id;
    }

    void setAllfiles(boolean allfiles) {
        this.allfiles = allfiles;
    }

    public boolean isAllfiles() {
        return this.allfiles;
    }

    void setReqMessage(String reqMessage) {
        this.reqMessage = reqMessage;
    }

    public String getReqMessage() {
        return this.reqMessage;
    }

    void setReqName(String reqName) {
        this.reqName = reqName;
    }

    public String getReqName() {
        return this.reqName;
    }

    void setReqEmail(String reqEmail) {
        this.reqEmail = reqEmail;
    }

    public String getReqEmail() {
        return this.reqEmail;
    }

    void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    void setItem(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    void setBitstream(Bitstream bitstream) {
        this.bitstream = bitstream;
    }

    public Bitstream getBitstream() {
        return this.bitstream;
    }

    public Date getDecision_date() {
        return this.decision_date;
    }

    public void setDecision_date(Date decision_date) {
        this.decision_date = decision_date;
    }

    public boolean isAccept_request() {
        return this.accept_request;
    }

    public void setAccept_request(boolean accept_request) {
        this.accept_request = accept_request;
    }

    public Date getExpires() {
        return this.expires;
    }

    void setExpires(Date expires) {
        this.expires = expires;
    }

    public Date getRequest_date() {
        return this.request_date;
    }

    void setRequest_date(Date request_date) {
        this.request_date = request_date;
    }
}

