/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.dspace.app.util.WebApp;
import org.dspace.app.util.dao.WebAppDAO;
import org.dspace.app.util.service.WebAppService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class WebAppServiceImpl
implements WebAppService {
    private final Logger log = Logger.getLogger(WebAppServiceImpl.class);
    @Autowired(required=true)
    protected WebAppDAO webAppDAO;

    protected WebAppServiceImpl() {
    }

    @Override
    public WebApp create(Context context, String appName, String url, Date started, int isUI) throws SQLException {
        WebApp webApp = this.webAppDAO.create(context, new WebApp());
        webApp.setAppName(appName);
        webApp.setUrl(url);
        webApp.setStarted(started);
        webApp.setIsui(isUI);
        this.webAppDAO.save(context, webApp);
        return webApp;
    }

    @Override
    public void delete(Context context, WebApp webApp) throws SQLException {
        this.webAppDAO.delete(context, webApp);
    }

    @Override
    public List<WebApp> findAll(Context context) throws SQLException {
        return this.webAppDAO.findAll(context, WebApp.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WebApp> getApps() {
        ArrayList<WebApp> apps = new ArrayList<WebApp>();
        Context context = null;
        HttpHead method = null;
        try {
            context = new Context();
            List<WebApp> webApps = this.findAll(context);
            Iterator<WebApp> i$ = webApps.iterator();
            while (i$.hasNext()) {
                DefaultHttpClient client = new DefaultHttpClient();
                WebApp app = i$.next();
                method = new HttpHead(app.getUrl());
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status != 200) {
                    this.delete(context, app);
                    continue;
                }
                apps.add(app);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)"Unable to list running applications", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"Failure checking for a running webapp", (Throwable)e);
        }
        finally {
            if (null != method) {
                method.releaseConnection();
            }
            if (null != context) {
                context.abort();
            }
        }
        return apps;
    }
}

