/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.xml.DOMConfigurator;
import org.dspace.services.ConfigurationService;
import org.dspace.services.KernelStartupCallbackService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class LoggerServiceImpl
implements KernelStartupCallbackService {
    private static Logger log = Logger.getLogger(LoggerServiceImpl.class);
    private final String LOG_DISABLE_PROPERTY = "dspace.log.init.disable";
    private final String LOG_CONFIG_PROPERTY = "log.init.config";

    public void executeCallback() {
        block19: {
            try {
                ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
                String dsLogConfiguration = config.getProperty("log.init.config");
                if (dsLogConfiguration == null || System.getProperty("dspace.log.init.disable") != null) {
                    this.info("Using default log4j provided log configuration.  If unintended, check your dspace.cfg for (log.init.config)");
                    break block19;
                }
                this.info("Using dspace provided log configuration (log.init.config)");
                File logConfigFile = new File(dsLogConfiguration);
                if (logConfigFile.exists()) {
                    this.info("Loading: " + dsLogConfiguration);
                    if (logConfigFile.getName().endsWith(".xml")) {
                        DOMConfigurator.configure((URL)logConfigFile.toURI().toURL());
                        break block19;
                    }
                    Properties log4jProps = new Properties();
                    try (FileInputStream fis = new FileInputStream(logConfigFile);){
                        log4jProps.load(fis);
                    }
                    catch (IOException e) {
                        this.fatal("Can't load dspace provided log4j configuration from " + logConfigFile.getAbsolutePath(), e);
                    }
                    PropertyConfigurator.configure((Properties)log4jProps);
                    break block19;
                }
                this.info("File does not exist: " + dsLogConfiguration);
            }
            catch (MalformedURLException e) {
                this.fatal("Can't load dspace provided log4j configuration", e);
                throw new IllegalStateException("Cannot load dspace provided log4j configuration", e);
            }
        }
    }

    private void info(String string) {
        if (!this.isLog4jConfigured()) {
            System.out.println("INFO: " + string);
        } else {
            log.info((Object)string);
        }
    }

    private void warn(String string) {
        if (!this.isLog4jConfigured()) {
            System.out.println("WARN: " + string);
        } else {
            log.warn((Object)string);
        }
    }

    private void fatal(String string, Exception e) {
        if (!this.isLog4jConfigured()) {
            System.err.println("FATAL: " + string);
            e.printStackTrace(System.err);
        } else {
            log.fatal((Object)string, (Throwable)e);
        }
    }

    private boolean isLog4jConfigured() {
        Enumeration appenders = LogManager.getRootLogger().getAllAppenders();
        if (!(appenders instanceof NullEnumeration)) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger c = (Logger)loggers.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }
}

