/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;

public class BitstreamsIntoMetadata
extends AbstractCurationTask {
    protected int status = -2;
    protected List<String> results = null;
    private static Logger log = Logger.getLogger(BitstreamsIntoMetadata.class);

    @Override
    public int perform(DSpaceObject dso) {
        StringBuilder results = new StringBuilder();
        this.status = 2;
        boolean changed = false;
        this.logDebugMessage("The target dso is " + dso.getName());
        if (dso instanceof Item) {
            try {
                Item item = (Item)dso;
                this.itemService.clearMetadata(Curator.curationContext(), item, "dc", "format", "*", "*");
                for (Bundle bundle : item.getBundles()) {
                    if ("ORIGINAL".equals(bundle.getName())) {
                        for (Bitstream bitstream : bundle.getBitstreams()) {
                            this.addMetadata(item, bitstream, "original");
                            changed = true;
                        }
                    } else if ("THUMBNAIL".equals(bundle.getName())) {
                        for (Bitstream bitstream : bundle.getBitstreams()) {
                            this.addMetadata(item, bitstream, "thumbnail");
                            changed = true;
                        }
                    }
                    if (!changed) continue;
                    this.itemService.update(Curator.curationContext(), item);
                    this.status = 0;
                }
            }
            catch (AuthorizeException ae) {
                this.logDebugMessage(ae.getMessage());
                this.status = -1;
            }
            catch (SQLException sqle) {
                this.logDebugMessage(sqle.getMessage());
                this.status = -1;
            }
        }
        this.logDebugMessage("About to report: " + results.toString());
        this.setResult(results.toString());
        this.report(results.toString());
        return this.status;
    }

    protected void logDebugMessage(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }

    protected void addMetadata(Item item, Bitstream bitstream, String type) throws SQLException {
        String value = bitstream.getFormat(Curator.curationContext()).getMIMEType() + "##";
        value = value + bitstream.getName() + "##";
        value = value + bitstream.getSize() + "##";
        value = value + item.getHandle() + "##";
        value = value + bitstream.getSequenceID() + "##";
        value = value + bitstream.getChecksum() + "##";
        if (bitstream.getDescription() != null) {
            value = value + bitstream.getDescription();
        }
        this.itemService.addMetadata(Curator.curationContext(), item, "dc", "format", type, "en", value);
    }
}

