/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.curate.Curator;
import org.dspace.curate.service.WorkflowCuratorService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.BasicWorkflowService;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowCuratorServiceImpl
implements WorkflowCuratorService {
    private Logger log = Logger.getLogger(WorkflowCuratorServiceImpl.class);
    protected Map<String, TaskSet> tsMap = new HashMap<String, TaskSet>();
    protected final String[] flowSteps = new String[]{"step1", "step2", "step3", "archive"};
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected GroupService groupService;
    protected BasicWorkflowItemService basicWorkflowItemService;
    protected BasicWorkflowService basicWorkflowService;
    @Autowired(required=true)
    protected WorkflowServiceFactory workflowServiceFactory;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    public void init() throws Exception {
        File cfgFile = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "workflow-curation.xml");
        try {
            this.loadTaskConfig(cfgFile);
            if (this.workflowServiceFactory.getWorkflowService() instanceof BasicWorkflowItemService) {
                this.basicWorkflowService = (BasicWorkflowService)this.workflowServiceFactory.getWorkflowService();
                this.basicWorkflowItemService = (BasicWorkflowItemService)this.workflowServiceFactory.getWorkflowItemService();
            }
        }
        catch (IOException e) {
            this.log.fatal((Object)("Unable to load config: " + cfgFile.getAbsolutePath()));
        }
    }

    protected WorkflowCuratorServiceImpl() {
    }

    @Override
    public boolean needsCuration(BasicWorkflowItem wfi) {
        return this.getFlowStep(wfi) != null;
    }

    @Override
    public boolean doCuration(Context c, BasicWorkflowItem wfi) throws AuthorizeException, IOException, SQLException {
        FlowStep step = this.getFlowStep(wfi);
        if (step != null) {
            Curator curator = new Curator();
            if (step.queue != null) {
                for (Task task : step.tasks) {
                    curator.addTask(task.name);
                }
                curator.queue(c, String.valueOf(wfi.getID()), step.queue);
                this.basicWorkflowItemService.update(c, wfi);
                return false;
            }
            return this.curate(curator, c, wfi);
        }
        return true;
    }

    @Override
    public boolean curate(Curator curator, Context c, String wfId) throws AuthorizeException, IOException, SQLException {
        BasicWorkflowItem wfi = (BasicWorkflowItem)this.basicWorkflowItemService.find(c, Integer.parseInt(wfId));
        if (wfi != null) {
            if (this.curate(curator, c, wfi)) {
                this.basicWorkflowService.advance(c, wfi, c.getCurrentUser(), false, true);
                return true;
            }
        } else {
            this.log.warn((Object)LogManager.getHeader(c, "No workflow item found for id: " + wfId, null));
        }
        return false;
    }

    @Override
    public boolean curate(Curator curator, Context c, BasicWorkflowItem wfi) throws AuthorizeException, IOException, SQLException {
        FlowStep step = this.getFlowStep(wfi);
        if (step != null) {
            Item item = wfi.getItem();
            item.setOwningCollection(wfi.getCollection());
            for (Task task : step.tasks) {
                curator.addTask(task.name);
                curator.curate(item);
                int status = curator.getStatus(task.name);
                String result = curator.getResult(task.name);
                String action = "none";
                if (status == 1) {
                    if (task.powers.contains("reject")) {
                        action = "reject";
                    }
                    this.notifyContacts(c, wfi, task, "fail", action, result);
                    if ("reject".equals(action)) {
                        this.basicWorkflowService.sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), null, task.name + ": " + result);
                        return false;
                    }
                } else if (status == 0) {
                    if (task.powers.contains("approve")) {
                        action = "approve";
                    }
                    this.notifyContacts(c, wfi, task, "success", action, result);
                    if ("approve".equals(action)) {
                        return true;
                    }
                } else if (status == -1) {
                    this.notifyContacts(c, wfi, task, "error", action, result);
                }
                curator.clear();
            }
        }
        return true;
    }

    protected void notifyContacts(Context c, BasicWorkflowItem wfi, Task task, String status, String action, String message) throws AuthorizeException, IOException, SQLException {
        List<EPerson> epa = this.resolveContacts(c, task.getContacts(status), wfi);
        if (epa.size() > 0) {
            this.basicWorkflowService.notifyOfCuration(c, wfi, epa, task.name, action, message);
        }
    }

    protected List<EPerson> resolveContacts(Context c, List<String> contacts, BasicWorkflowItem wfi) throws AuthorizeException, IOException, SQLException {
        ArrayList<EPerson> epList = new ArrayList<EPerson>();
        for (String contact : contacts) {
            if ("$flowgroup".equals(contact)) {
                Group wfGroup;
                int step = this.state2step(wfi.getState());
                if (step >= 4 || (wfGroup = this.collectionService.getWorkflowGroup(wfi.getCollection(), step)) == null) continue;
                epList.addAll(this.groupService.allMembers(c, wfGroup));
                continue;
            }
            if ("$colladmin".equals(contact)) {
                Group adGroup = wfi.getCollection().getAdministrators();
                if (adGroup == null) continue;
                epList.addAll(this.groupService.allMembers(c, adGroup));
                continue;
            }
            if ("$siteadmin".equals(contact)) {
                EPerson siteEp = this.ePersonService.findByEmail(c, this.configurationService.getProperty("mail.admin"));
                if (siteEp == null) continue;
                epList.add(siteEp);
                continue;
            }
            if (contact.indexOf("@") > 0) {
                EPerson ep = this.ePersonService.findByEmail(c, contact);
                if (ep == null) continue;
                epList.add(ep);
                continue;
            }
            Group group = this.groupService.findByName(c, contact);
            if (group == null) continue;
            epList.addAll(this.groupService.allMembers(c, group));
        }
        return epList;
    }

    protected FlowStep getFlowStep(BasicWorkflowItem wfi) {
        Collection coll = wfi.getCollection();
        String key = this.tsMap.containsKey(coll.getHandle()) ? coll.getHandle() : "default";
        TaskSet ts = this.tsMap.get(key);
        if (ts != null) {
            int myStep = this.state2step(wfi.getState());
            for (FlowStep fstep : ts.steps) {
                if (fstep.step != myStep) continue;
                return fstep;
            }
        }
        return null;
    }

    protected int state2step(int state) {
        if (state <= 1) {
            return 1;
        }
        if (state <= 3) {
            return 2;
        }
        if (state <= 5) {
            return 3;
        }
        return 4;
    }

    protected int stepName2step(String name) {
        for (int i = 0; i < this.flowSteps.length; ++i) {
            if (!this.flowSteps[i].equals(name)) continue;
            return i + 1;
        }
        this.log.warn((Object)("Invalid step: '" + name + "' provided"));
        return -1;
    }

    protected void loadTaskConfig(File cfgFile) throws IOException {
        HashMap<String, String> collMap = new HashMap<String, String>();
        HashMap<String, TaskSet> setMap = new HashMap<String, TaskSet>();
        TaskSet taskSet = null;
        FlowStep flowStep = null;
        Task task = null;
        String type = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(new FileInputStream(cfgFile), "UTF-8");
            while (reader.hasNext()) {
                String eName;
                int event = reader.next();
                if (event == 1) {
                    eName = reader.getLocalName();
                    if ("mapping".equals(eName)) {
                        collMap.put(reader.getAttributeValue(0), reader.getAttributeValue(1));
                        continue;
                    }
                    if ("taskset".equals(eName)) {
                        taskSet = new TaskSet(reader.getAttributeValue(0));
                        continue;
                    }
                    if ("flowstep".equals(eName)) {
                        int count = reader.getAttributeCount();
                        String queue = count == 2 ? reader.getAttributeValue(1) : null;
                        flowStep = new FlowStep(reader.getAttributeValue(0), queue);
                        continue;
                    }
                    if ("task".equals(eName)) {
                        task = new Task(reader.getAttributeValue(0));
                        continue;
                    }
                    if ("workflow".equals(eName)) {
                        type = "power";
                        continue;
                    }
                    if (!"notify".equals(eName)) continue;
                    type = reader.getAttributeValue(0);
                    continue;
                }
                if (event == 4) {
                    if (task == null) continue;
                    if ("power".equals(type)) {
                        task.addPower(reader.getText());
                        continue;
                    }
                    task.addContact(type, reader.getText());
                    continue;
                }
                if (event != 2) continue;
                eName = reader.getLocalName();
                if ("task".equals(eName)) {
                    flowStep.addTask(task);
                    task = null;
                    continue;
                }
                if ("flowstep".equals(eName)) {
                    taskSet.addStep(flowStep);
                    continue;
                }
                if (!"taskset".equals(eName)) continue;
                setMap.put(taskSet.setName, taskSet);
            }
            reader.close();
            for (Map.Entry collEntry : collMap.entrySet()) {
                if ("none".equals(collEntry.getValue()) || !setMap.containsKey(collEntry.getValue())) continue;
                this.tsMap.put((String)collEntry.getKey(), (TaskSet)setMap.get(collEntry.getValue()));
            }
        }
        catch (XMLStreamException xsE) {
            throw new IOException(xsE.getMessage(), xsE);
        }
    }

    protected class Task {
        public String name = null;
        public List<String> powers = new ArrayList<String>();
        public Map<String, List<String>> contacts = new HashMap<String, List<String>>();

        public Task(String name) {
            this.name = name;
        }

        public void addPower(String power) {
            this.powers.add(power);
        }

        public void addContact(String status, String contact) {
            List<String> sContacts = this.contacts.get(status);
            if (sContacts == null) {
                sContacts = new ArrayList<String>();
                this.contacts.put(status, sContacts);
            }
            sContacts.add(contact);
        }

        public List<String> getContacts(String status) {
            ArrayList ret = this.contacts.get(status);
            return ret != null ? ret : new ArrayList();
        }
    }

    protected class FlowStep {
        public int step = -1;
        public String queue = null;
        public List<Task> tasks = null;

        public FlowStep(String stepStr, String queueStr) {
            this.step = WorkflowCuratorServiceImpl.this.stepName2step(stepStr);
            this.queue = queueStr;
            this.tasks = new ArrayList<Task>();
        }

        public void addTask(Task task) {
            this.tasks.add(task);
        }
    }

    protected class TaskSet {
        public String setName = null;
        public List<FlowStep> steps = null;

        public TaskSet(String setName) {
            this.setName = setName;
            this.steps = new ArrayList<FlowStep>();
        }

        public void addStep(FlowStep step) {
            this.steps.add(step);
        }
    }
}

