/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.services.factory.DSpaceServicesFactory;

public class IndexClient {
    private static final Logger log = Logger.getLogger(IndexClient.class);

    public static void main(String[] args) throws SQLException, IOException, SearchServiceException {
        Context context = new Context();
        context.setIgnoreAuthorization(true);
        String usage = "org.dspace.discovery.IndexClient [-cbhf] | [-r <handle>] | [-i <handle>] or nothing to update/clean an existing index.";
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine line = null;
        OptionBuilder.withArgName((String)"handle to remove");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"remove an Item, Collection or Community from index based on its handle");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withArgName((String)"handle to add or update");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"add or update an Item, Collection or Community based on its handle");
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"clean existing index removing any documents that no longer exist in the db");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"(re)build index, wiping out current one if it exists");
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Rebuild the spellchecker, can be combined with -b and -f.");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"if updating existing index, force each handle to be reindexed even if uptodate");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"print this help message");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"optimize search core");
        options.addOption(OptionBuilder.create((String)"o"));
        try {
            line = new PosixParser().parse(options, args);
        }
        catch (Exception e) {
            formatter.printHelp(usage, e.getMessage(), options, "");
            System.exit(1);
        }
        if (line.hasOption("h")) {
            formatter.printHelp(usage, options);
            System.exit(1);
        }
        IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
        if (line.hasOption("r")) {
            log.info((Object)("Removing " + line.getOptionValue("r") + " from Index"));
            indexer.unIndexContent(context, line.getOptionValue("r"));
        } else if (line.hasOption("c")) {
            log.info((Object)"Cleaning Index");
            indexer.cleanIndex(line.hasOption("f"));
        } else if (line.hasOption("b")) {
            log.info((Object)"(Re)building index from scratch.");
            indexer.createIndex(context);
            IndexClient.checkRebuildSpellCheck(line, indexer);
        } else if (line.hasOption("o")) {
            log.info((Object)"Optimizing search core.");
            indexer.optimize();
        } else if (line.hasOption('s')) {
            IndexClient.checkRebuildSpellCheck(line, indexer);
        } else if (line.hasOption('i')) {
            String handle = line.getOptionValue('i');
            DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, handle);
            if (dso == null) {
                throw new IllegalArgumentException("Cannot resolve " + handle + " to a DSpace object");
            }
            log.info((Object)("Forcibly Indexing " + handle));
            context.enableBatchMode(true);
            long startTimeMillis = System.currentTimeMillis();
            long count = IndexClient.indexAll(indexer, ContentServiceFactory.getInstance().getItemService(), context, dso);
            long seconds = (System.currentTimeMillis() - startTimeMillis) / 1000L;
            log.info((Object)("Indexed " + count + " DSpace object" + (count > 1L ? "s" : "") + " in " + seconds + " seconds"));
        } else {
            log.info((Object)"Updating and Cleaning Index");
            indexer.cleanIndex(line.hasOption("f"));
            indexer.updateIndex(context, line.hasOption("f"));
            IndexClient.checkRebuildSpellCheck(line, indexer);
        }
        log.info((Object)"Done with indexing");
    }

    private static long indexAll(IndexingService indexingService, ItemService itemService, Context context, DSpaceObject dso) throws IOException, SearchServiceException, SQLException {
        long count = 0L;
        indexingService.indexContent(context, dso, true, true);
        ++count;
        if (dso.getType() == 4) {
            Community community = (Community)dso;
            String communityHandle = community.getHandle();
            for (Community subcommunity : community.getSubcommunities()) {
                count += IndexClient.indexAll(indexingService, itemService, context, subcommunity);
                context.uncacheEntity(subcommunity);
            }
            Community reloadedCommunity = (Community)HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, communityHandle);
            for (Collection collection : reloadedCommunity.getCollections()) {
                ++count;
                indexingService.indexContent(context, collection, true, true);
                count += IndexClient.indexItems(indexingService, itemService, context, collection);
                context.uncacheEntity(collection);
            }
        } else if (dso.getType() == 3) {
            count += IndexClient.indexItems(indexingService, itemService, context, (Collection)dso);
        }
        return count;
    }

    private static long indexItems(IndexingService indexingService, ItemService itemService, Context context, Collection collection) throws IOException, SearchServiceException, SQLException {
        long count = 0L;
        Iterator<Item> itemIterator = itemService.findByCollection(context, collection);
        while (itemIterator.hasNext()) {
            Item item = itemIterator.next();
            indexingService.indexContent(context, item, true, false);
            ++count;
            context.uncacheEntity(item);
        }
        indexingService.commit();
        return count;
    }

    protected static void checkRebuildSpellCheck(CommandLine line, IndexingService indexer) throws SearchServiceException {
        if (line.hasOption("s")) {
            log.info((Object)"Rebuilding spell checker.");
            indexer.buildSpellCheck();
        }
    }
}

