/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.util.Date;
import java.util.UUID;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class EPersonConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(EPersonConsumer.class);
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context context, Event event) throws Exception {
        int st = event.getSubjectType();
        int et = event.getEventType();
        UUID id = event.getSubjectID();
        switch (st) {
            case 7: {
                if (et == 1) {
                    String notifyRecipient = ConfigurationManager.getProperty("registration.notify");
                    if (notifyRecipient == null) {
                        notifyRecipient = "";
                    }
                    if ((notifyRecipient = notifyRecipient.trim()).equals("")) break;
                    try {
                        EPerson eperson = (EPerson)this.ePersonService.find(context, id);
                        Email adminEmail = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "registration_notify"));
                        adminEmail.addRecipient(notifyRecipient);
                        adminEmail.addArgument(ConfigurationManager.getProperty("dspace.name"));
                        adminEmail.addArgument(ConfigurationManager.getProperty("dspace.url"));
                        adminEmail.addArgument(eperson.getFirstName() + " " + eperson.getLastName());
                        adminEmail.addArgument(eperson.getEmail());
                        adminEmail.addArgument(new Date());
                        adminEmail.setReplyTo(eperson.getEmail());
                        adminEmail.send();
                        log.info((Object)LogManager.getHeader(context, "registerion_alert", "user=" + eperson.getEmail()));
                    }
                    catch (MessagingException me) {
                        log.warn((Object)LogManager.getHeader(context, "error_emailing_administrator", ""), (Throwable)me);
                    }
                    break;
                }
                if (et != 32) break;
                break;
            }
            default: {
                log.warn((Object)("consume() got unrecognized event: " + event.toString()));
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) {
    }
}

