/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.utils.DSpace;

public class DOIOrganiser {
    private static final Logger LOG = Logger.getLogger(DOIOrganiser.class);
    private DOIIdentifierProvider provider;
    private Context context;
    private boolean quiet;
    protected HandleService handleService;
    protected ItemService itemService;
    protected DOIService doiService;

    public DOIOrganiser(Context context, DOIIdentifierProvider provider) {
        this.context = context;
        this.provider = provider;
        this.quiet = false;
        this.handleService = HandleServiceFactory.getInstance().getHandleService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.doiService = IdentifierServiceFactory.getInstance().getDOIService();
    }

    public static void main(String[] args) {
        LOG.debug((Object)"Starting DOI organiser ");
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        DOIOrganiser organiser = new DOIOrganiser(context, (DOIIdentifierProvider)new DSpace().getSingletonService(DOIIdentifierProvider.class));
        DOIOrganiser.runCLI(context, organiser, args);
        try {
            context.complete();
        }
        catch (SQLException sqle) {
            System.err.println("Cannot save changes to database: " + sqle.getMessage());
            System.exit(-1);
        }
    }

    public static void runCLI(Context context, DOIOrganiser organiser, String[] args) {
        DOI doiRow;
        String identifier;
        List<DOI> dois;
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("l", "list", false, "List all objects to be reserved, registered, deleted of updated ");
        options.addOption("r", "register-all", false, "Perform online registration for all identifiers queued for registration.");
        options.addOption("s", "reserve-all", false, "Perform online reservation for all identifiers queued for reservation.");
        options.addOption("u", "update-all", false, "Perform online metadata update for all identifiers queued for metadata update.");
        options.addOption("d", "delete-all", false, "Perform online deletion for all identifiers queued for deletion.");
        options.addOption("q", "quiet", false, "Turn the command line output off.");
        OptionBuilder.withArgName((String)"DOI|ItemID|handle");
        OptionBuilder.withLongOpt((String)"register-doi");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Register a specified identifier. You can specify the identifier by ItemID, Handle or DOI.");
        Option registerDoi = OptionBuilder.create();
        options.addOption(registerDoi);
        OptionBuilder.withArgName((String)"DOI|ItemID|handle");
        OptionBuilder.withLongOpt((String)"reserve-doi");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Reserve a specified identifier online. You can specify the identifier by ItemID, Handle or DOI.");
        Option reserveDoi = OptionBuilder.create();
        options.addOption(reserveDoi);
        OptionBuilder.withArgName((String)"DOI|ItemID|handle");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Update online an object for a given DOI identifier or ItemID or Handle. A DOI identifier or an ItemID or a Handle is needed.\n");
        OptionBuilder.withLongOpt((String)"update-doi");
        Option update = OptionBuilder.create();
        options.addOption(update);
        OptionBuilder.withArgName((String)"DOI identifier");
        OptionBuilder.withLongOpt((String)"delete-doi");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Delete a specified identifier.");
        Option delete = OptionBuilder.create();
        options.addOption(delete);
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        HelpFormatter helpformater = new HelpFormatter();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            LOG.fatal((Object)ex);
            System.exit(1);
        }
        if (line.hasOption('h') || 0 == line.getOptions().length) {
            helpformater.printHelp("\nDOI organiser\n", options);
        }
        if (line.hasOption('q')) {
            organiser.setQuiet();
        }
        if (line.hasOption('l')) {
            organiser.list("reservation", null, null, DOIIdentifierProvider.TO_BE_RESERVED);
            organiser.list("registration", null, null, DOIIdentifierProvider.TO_BE_REGISTERED);
            organiser.list("update", null, null, DOIIdentifierProvider.UPDATE_BEFORE_REGISTRATION, DOIIdentifierProvider.UPDATE_REGISTERED, DOIIdentifierProvider.UPDATE_RESERVED);
            organiser.list("deletion", null, null, DOIIdentifierProvider.TO_BE_DELETED);
        }
        DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
        if (line.hasOption('s')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.TO_BE_RESERVED));
                if (0 == dois.size()) {
                    System.err.println("There are no objects in the database that could be reserved.");
                }
                for (DOI doi : dois) {
                    organiser.reserve(doi);
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('r')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.TO_BE_REGISTERED));
                if (0 == dois.size()) {
                    System.err.println("There are no objects in the database that could be registered.");
                }
                for (DOI doi : dois) {
                    organiser.register(doi);
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('u')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.UPDATE_BEFORE_REGISTRATION, DOIIdentifierProvider.UPDATE_RESERVED, DOIIdentifierProvider.UPDATE_REGISTERED));
                if (0 == dois.size()) {
                    System.err.println("There are no objects in the database whose metadata needs an update.");
                }
                for (DOI doi : dois) {
                    organiser.update(doi);
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('d')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.TO_BE_DELETED));
                if (0 == dois.size()) {
                    System.err.println("There are no objects in the database that could be deleted.");
                }
                Iterator<DOI> iterator = dois.iterator();
                while (iterator.hasNext()) {
                    DOI doi;
                    doi = iterator.next();
                    iterator.remove();
                    organiser.delete(doi.getDoi());
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption("reserve-doi")) {
            identifier = line.getOptionValue("reserve-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.resolveToDOI(identifier);
                    organiser.reserve(doiRow);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex);
                }
                catch (IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("register-doi")) {
            identifier = line.getOptionValue("register-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.resolveToDOI(identifier);
                    organiser.register(doiRow);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex);
                }
                catch (IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("update-doi")) {
            identifier = line.getOptionValue("update-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.resolveToDOI(identifier);
                    organiser.update(doiRow);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex);
                }
                catch (IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("delete-doi")) {
            identifier = line.getOptionValue("delete-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    organiser.delete(identifier);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
    }

    public void list(String processName, PrintStream out, PrintStream err, Integer ... status) {
        String indent = "    ";
        if (null == out) {
            out = System.out;
        }
        if (null == err) {
            err = System.err;
        }
        try {
            List<DOI> doiList = this.doiService.getDOIsByStatus(this.context, Arrays.asList(status));
            if (0 < doiList.size()) {
                out.println("DOIs queued for " + processName + ": ");
            } else {
                out.println("There are no DOIs queued for " + processName + ".");
            }
            for (DOI doiRow : doiList) {
                out.print(indent + "doi:" + doiRow.getDoi());
                DSpaceObject dso = doiRow.getDSpaceObject();
                if (null != dso) {
                    out.println(" (belongs to item with handle " + dso.getHandle() + ")");
                    continue;
                }
                out.println(" (cannot determine handle of assigned object)");
            }
            out.println("");
        }
        catch (SQLException ex) {
            err.println("Error in database Connection: " + ex.getMessage());
            ex.printStackTrace(err);
        }
    }

    public void register(DOI doiRow) throws SQLException {
        DSpaceObject dso = doiRow.getDSpaceObject();
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.registerOnline(this.context, dso, "doi:" + doiRow.getDoi());
            if (!this.quiet) {
                System.out.println("This identifier: doi:" + doiRow.getDoi() + " is successfully registered.");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error((Object)("It wasn't possible to register this identifier: doi:" + doiRow.getDoi() + " online. "), (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Register", dso, "doi:" + doiRow.getDoi(), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error((Object)"Couldn't send mail", (Throwable)ioe);
            }
            LOG.error((Object)("It wasn't possible to register this identifier : doi:" + doiRow.getDoi() + " online. Exceptions code: " + DOIIdentifierException.codeToString(doiIdentifierException.getCode())), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getDoi());
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getDoi() + "!"), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getDoi());
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getDoi() + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error while trying to get data from database", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getDoi());
            }
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    public void reserve(DOI doiRow) throws SQLException {
        DSpaceObject dso = doiRow.getDSpaceObject();
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.reserveOnline(this.context, dso, "doi:" + doiRow.getDoi());
            if (!this.quiet) {
                System.out.println("This identifier : doi:" + doiRow.getDoi() + " is successfully reserved.");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error((Object)("It wasn't possible to register this identifier : doi:" + doiRow.getDoi() + " online. "), (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Reserve", dso, "doi:" + doiRow.getDoi(), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error((Object)"Couldn't send mail", (Throwable)ioe);
            }
            LOG.error((Object)("It wasn't possible to reserve the identifier online.  Exceptions code:  " + DOIIdentifierException.codeToString(doiIdentifierException.getCode())), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getDoi());
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getDoi() + "!"), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getDoi());
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getDoi() + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error while trying to get data from database", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getDoi());
            }
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    public void update(DOI doiRow) {
        DSpaceObject dso = doiRow.getDSpaceObject();
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.updateMetadataOnline(this.context, dso, "doi:" + doiRow.getDoi());
            if (!this.quiet) {
                System.out.println("Successfully updated metadata of DOI doi:" + doiRow.getDoi() + ".");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error((Object)"It wasn't possible to register the identifier online. ", (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Update", dso, "doi:" + doiRow.getDoi(), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error((Object)"Couldn't send mail", (Throwable)ioe);
            }
            LOG.error((Object)("It wasn't possible to update this identifier:  doi:" + doiRow.getDoi() + " Exceptions code:  " + DOIIdentifierException.codeToString(doiIdentifierException.getCode())), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to update this identifier: doi:" + doiRow.getDoi());
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getDoi() + "!"), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to update this identifier: doi:" + doiRow.getDoi());
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getDoi() + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error((Object)"It wasn't possible to connect to the Database!", (Throwable)ex);
        }
    }

    public void delete(String identifier) throws SQLException {
        block6: {
            String doi = null;
            DOI doiRow = null;
            try {
                doi = this.doiService.formatIdentifier(identifier);
                doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                if (null == doiRow) {
                    throw new IllegalStateException("You specified a valid DOI, that is not stored in our database.");
                }
                this.provider.deleteOnline(this.context, doi);
                if (!this.quiet) {
                    System.err.println("It was possible to delete this identifier: doi:" + doiRow.getDoi() + " online.");
                }
            }
            catch (DOIIdentifierException ex) {
                LOG.error((Object)("It wasn't possible to detect this identifier:  " + identifier + " Exceptions code:  " + DOIIdentifierException.codeToString(ex.getCode())), (Throwable)ex);
                if (!this.quiet) {
                    System.err.println("It wasn't possible to detect this identifier: " + identifier);
                }
            }
            catch (IllegalArgumentException ex) {
                if (this.quiet) break block6;
                System.err.println("It wasn't possible to delete this identifier: doi:" + doiRow.getDoi() + " online. Take a look in log file.");
            }
        }
    }

    public DOI resolveToDOI(String identifier) throws SQLException, IllegalArgumentException, IllegalStateException, IdentifierException {
        DOI doiRow;
        block10: {
            if (null == identifier || identifier.isEmpty()) {
                throw new IllegalArgumentException("Identifier is null or empty.");
            }
            doiRow = null;
            String doi = null;
            if (identifier.matches("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[34][0-9a-fA-F]{3}-[89ab][0-9a-fA-F]{3}-[0-9a-fA-F]{12}")) {
                Object dso = this.itemService.find(this.context, UUID.fromString(identifier));
                if (null != dso) {
                    doiRow = this.doiService.findDOIByDSpaceObject(this.context, (DSpaceObject)dso);
                    if (null == doiRow) {
                        doi = this.provider.mint(this.context, (DSpaceObject)dso);
                        doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                        return doiRow;
                    }
                    return doiRow;
                }
                throw new IllegalStateException("You specified an ItemID, that is not stored in our database.");
            }
            DSpaceObject dso = this.handleService.resolveToObject(this.context, identifier);
            if (null != dso) {
                if (dso.getType() != 2) {
                    throw new IllegalArgumentException("Currently DSpace supports DOIs for Items only. Cannot process specified handle as it does not identify an Item.");
                }
                doiRow = this.doiService.findDOIByDSpaceObject(this.context, dso);
                if (null == doiRow) {
                    doi = this.provider.mint(this.context, dso);
                    doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                }
                return doiRow;
            }
            try {
                doi = this.doiService.formatIdentifier(identifier);
                doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                if (null == doiRow) {
                    throw new IllegalStateException("You specified a valid DOI, that is not stored in our database.");
                }
            }
            catch (DOIIdentifierException ex) {
                LOG.error((Object)("It wasn't possible to detect this identifier:  " + identifier + " Exceptions code:  " + DOIIdentifierException.codeToString(ex.getCode())), (Throwable)ex);
                if (this.quiet) break block10;
                System.err.println("It wasn't possible to detect this identifier: doi:" + doiRow.getDoi());
            }
        }
        return doiRow;
    }

    private void sendAlertMail(String action, DSpaceObject dso, String doi, String reason) throws IOException {
        block4: {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            try {
                if (recipient != null) {
                    Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "doi_maintenance_error"));
                    email.addRecipient(recipient);
                    email.addArgument(action);
                    email.addArgument(new Date());
                    email.addArgument(ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso));
                    email.addArgument(dso.getID().toString());
                    email.addArgument(doi);
                    email.addArgument(reason);
                    email.send();
                    if (!this.quiet) {
                        System.err.println("Email alert is sent.");
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to send email alert", (Throwable)e);
                if (this.quiet) break block4;
                System.err.println("Unable to send email alert.");
            }
        }
    }

    private void setQuiet() {
        this.quiet = true;
    }
}

