/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.rdf.RDFUtil;
import org.dspace.rdf.conversion.ConverterPlugin;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleDSORelationsConverterPlugin
implements ConverterPlugin {
    public static final String SIMPLE_RELATIONS_PREFIXES_KEY = "rdf.simplerelations.prefixes";
    public static final String SIMPLE_RELATIONS_SITE2COMMUNITY_KEY = "rdf.simplerelations.site2community";
    public static final String SIMPLE_RELATIONS_COMMUNITY2SITE_KEY = "rdf.simplerelations.community2site";
    public static final String SIMPLE_RELATIONS_COMMUNITY2SUBCOMMUNITY_KEY = "rdf.simplerelations.community2subcommunity";
    public static final String SIMPLE_RELATIONS_SUBCOMMUNITY2COMMUNITY_KEY = "rdf.simplerelations.subcommunity2community";
    public static final String SIMPLE_RELATIONS_COMMUNITY2COLLECTION_KEY = "rdf.simplerelations.community2collection";
    public static final String SIMPLE_RELATIONS_COLLECTION2COMMUNITY_KEY = "rdf.simplerelations.collection2community";
    public static final String SIMPLE_RELATIONS_COLLECTION2ITEM_KEY = "rdf.simplerelations.collection2item";
    public static final String SIMPLE_RELATIONS_ITEM2COLLECTION_KEY = "rdf.simplerelations.item2collection";
    public static final String SIMPLE_RELATIONS_ITEM2BITSTREAM_KEY = "rdf.simplerelations.item2bitstream";
    private static final Logger log = Logger.getLogger(SimpleDSORelationsConverterPlugin.class);
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected SiteService siteService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    protected Model getPrefixes() {
        Model m = ModelFactory.createDefaultModel();
        String prefixesPath = this.configurationService.getProperty(SIMPLE_RELATIONS_PREFIXES_KEY);
        if (!StringUtils.isEmpty((String)prefixesPath)) {
            InputStream is = FileManager.get().open(prefixesPath);
            if (is == null) {
                log.warn((Object)("Cannot find file '" + prefixesPath + "', ignoring..."));
            } else {
                m.read(is, null, FileUtils.guessLang((String)prefixesPath));
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            log.warn((Object)"Configuration does not contain path to prefixes file for SimpleDSORelationsConverterPlugin. Will proceed without prefixes.");
        }
        return m;
    }

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public Model convert(Context context, DSpaceObject dso) throws SQLException {
        switch (dso.getType()) {
            case 5: {
                return this.convertSite(context, (Site)dso);
            }
            case 4: {
                return this.convertCommunity(context, (Community)dso);
            }
            case 3: {
                return this.convertCollection(context, (Collection)dso);
            }
            case 2: {
                return this.convertItem(context, (Item)dso);
            }
        }
        return null;
    }

    public Model convertSite(Context context, Site site) throws SQLException {
        String[] site2community = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_SITE2COMMUNITY_KEY);
        if (site2community == null || site2community.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from the repository (SITE) to the top level communities is disabled. Won't link from the repostitory (SITE) to the top level communities.");
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, site);
        if (myId == null) {
            return null;
        }
        List<Community> topLevelCommies = this.communityService.findAllTop(context);
        for (Community community : topLevelCommies) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, community) || (id = RDFUtil.generateIdentifier(context, community)) == null) continue;
            for (String link : site2community) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        if (m.isEmpty()) {
            log.info((Object)"There were no public sub communities we could link to.");
            m.close();
            return null;
        }
        return m;
    }

    public Model convertCommunity(Context context, Community community) throws SQLException {
        String[] community2collection;
        String[] subcommunity2community;
        String[] community2subcommunity;
        String[] community2site = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_COMMUNITY2SITE_KEY);
        if (community2site == null || community2site.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from the top level communities to the repository (SITE) is disabled. Won't link from the top level communities to the repository (SITE).");
            community2site = new String[]{};
        }
        if ((community2subcommunity = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_COMMUNITY2SUBCOMMUNITY_KEY)) == null || community2subcommunity.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from communities to subcommunities was disabled. Won't link from communities to subcommunities.");
            community2subcommunity = new String[]{};
        }
        if ((subcommunity2community = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_SUBCOMMUNITY2COMMUNITY_KEY)) == null || subcommunity2community.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from subcommunities to communities was disabled. Won't link from subcommunities to communities.");
            subcommunity2community = new String[]{};
        }
        if ((community2collection = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_COMMUNITY2COLLECTION_KEY)) == null || community2collection.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from communities to collections was disabled. Won't link from collections to subcommunities.");
            community2collection = new String[]{};
        }
        if (community2site.length == 0 && community2subcommunity.length == 0 && subcommunity2community.length == 0 && community2collection.length == 0) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, community);
        if (myId == null) {
            return null;
        }
        List<Community> communityParentList = this.communityService.getAllParents(context, community);
        DSpaceObject[] parents = communityParentList.toArray(new DSpaceObject[communityParentList.size()]);
        if (parents.length == 0) {
            parents = new DSpaceObject[]{this.siteService.findSite(context)};
        }
        for (DSpaceObject parent : parents) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, parent) || (id = RDFUtil.generateIdentifier(context, parent)) == null) continue;
            if (parent instanceof Site) {
                for (String link : community2site) {
                    m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
                }
                continue;
            }
            if (!(parent instanceof Community)) continue;
            for (String link : subcommunity2community) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        for (Community sub : community.getSubcommunities()) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, sub) || (id = RDFUtil.generateIdentifier(context, sub)) == null) continue;
            for (String link : community2subcommunity) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        for (Collection col : this.communityService.getAllCollections(context, community)) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, col) || (id = RDFUtil.generateIdentifier(context, col)) == null) continue;
            for (String link : community2collection) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        if (m.isEmpty()) {
            m.close();
            return null;
        }
        return m;
    }

    public Model convertCollection(Context context, Collection collection) throws SQLException {
        String[] collection2item;
        String[] collection2community = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_COLLECTION2COMMUNITY_KEY);
        if (collection2community == null || collection2community.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from collections to communities was disabled. Won't link from collections to communities.");
            collection2community = new String[]{};
        }
        if ((collection2item = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_COLLECTION2ITEM_KEY)) == null || collection2item.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from collections to items was disabled. Won't link from collections to items.");
            collection2item = new String[]{};
        }
        if (collection2community.length == 0 && collection2item.length == 0) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, collection);
        if (myId == null) {
            return null;
        }
        for (DSpaceObject dSpaceObject : this.communityService.getAllParents(context, collection)) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, dSpaceObject) || (id = RDFUtil.generateIdentifier(context, dSpaceObject)) == null) continue;
            for (String link : collection2community) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        Iterator<Item> items = this.itemService.findAllByCollection(context, collection);
        while (items.hasNext()) {
            String string = RDFUtil.generateIdentifier(context, items.next());
            if (string == null) continue;
            for (String link : collection2item) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(string));
            }
        }
        if (m.isEmpty()) {
            m.close();
            return null;
        }
        return m;
    }

    public Model convertItem(Context context, Item item) throws SQLException {
        String[] item2bitstream;
        String[] item2collection = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_ITEM2COLLECTION_KEY);
        if (item2collection == null || item2collection.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from items to collections was disabled. Won't link from items to collections.");
            item2collection = new String[]{};
        }
        if ((item2bitstream = this.configurationService.getArrayProperty(SIMPLE_RELATIONS_ITEM2BITSTREAM_KEY)) == null || item2bitstream.length == 0) {
            log.info((Object)"Either there was a problem loading the configuration or linking from items to bitstreams was disabled. Won't link from items to bitstreams.");
            item2bitstream = new String[]{};
        }
        if (item2collection.length == 0 && item2bitstream.length == 0) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, item);
        if (myId == null) {
            return null;
        }
        for (DSpaceObject dSpaceObject : item.getCollections()) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, dSpaceObject) || (id = RDFUtil.generateIdentifier(context, dSpaceObject)) == null) continue;
            for (String link : item2collection) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        for (Bundle bundle : item.getBundles()) {
            if (!bundle.getName().equals("ORIGINAL")) continue;
            for (Bitstream bs : bundle.getBitstreams()) {
                String url;
                if (!RDFUtil.isPublicBoolean(context, bs) || (url = this.bitstreamURI(context, bs)) == null) continue;
                for (String link : item2bitstream) {
                    m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(url));
                }
            }
        }
        if (m.isEmpty()) {
            m.close();
            return null;
        }
        return m;
    }

    public String bitstreamURI(Context context, Bitstream bitstream) throws SQLException {
        DSpaceObject parent = this.bitstreamService.getParentObject(context, bitstream);
        if (!(parent instanceof Item)) {
            return null;
        }
        String dspaceURL = this.configurationService.getProperty("dspace.url");
        String link = "";
        try {
            link = dspaceURL + "/bitstream/" + parent.getHandle() + "/" + bitstream.getSequenceID() + "/" + Util.encodeBitstreamName(bitstream.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("DSpace's default encoding is not supported.", ex);
        }
        return link;
    }

    @Override
    public boolean supports(int type) {
        switch (type) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }
}

