/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.dspace.core.I18nUtil;

public class LocationUtils {
    private static final Logger logger = Logger.getLogger(LocationUtils.class);
    private static final Properties countryToContinent = new Properties();
    private static final String CONTINENT_NAMES_BUNDLE = LocationUtils.class.getPackage().getName() + ".continent-names";

    public static String getContinentCode(String countryCode) {
        String continent;
        if (null == countryCode) {
            logger.info((Object)"Null country code");
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-continent");
        }
        if (countryToContinent.isEmpty()) {
            try {
                countryToContinent.load(LocationUtils.class.getResourceAsStream("country-continent-codes.properties"));
            }
            catch (IOException e) {
                logger.error((Object)"Could not load country/continent map file", (Throwable)e);
            }
        }
        if (null == (continent = countryToContinent.getProperty(countryCode))) {
            logger.info((Object)("Unknown country code " + countryCode));
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-continent");
        }
        return continent;
    }

    @Deprecated
    public static String getContinentName(String continentCode) {
        return LocationUtils.getContinentName(continentCode, Locale.getDefault());
    }

    public static String getContinentName(String continentCode, Locale locale) {
        String name;
        ResourceBundle names;
        if (null == locale) {
            locale = Locale.US;
        }
        if (null == continentCode) {
            logger.info((Object)"Null continentCode");
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-continent");
        }
        try {
            names = ResourceBundle.getBundle(CONTINENT_NAMES_BUNDLE, locale);
        }
        catch (MissingResourceException e) {
            logger.error((Object)"Could not load continent code/name resource bundle", (Throwable)e);
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-continent");
        }
        try {
            name = names.getString(continentCode);
        }
        catch (MissingResourceException e) {
            logger.info((Object)("No continent code " + continentCode + " in bundle " + names.getLocale().getDisplayName()));
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-continent");
        }
        return name;
    }

    @Deprecated
    public static String getCountryName(String countryCode) {
        return LocationUtils.getCountryName(countryCode, Locale.getDefault());
    }

    public static String getCountryName(String countryCode, Locale locale) {
        if (null == countryCode) {
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-country");
        }
        Locale country = new Locale("EN", countryCode);
        String name = country.getDisplayCountry(locale);
        if (name.isEmpty()) {
            return I18nUtil.getMessage("org.dspace.statistics.util.LocationUtils.unknown-country");
        }
        return name;
    }
}

