/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public abstract class AbstractProcessingStep {
    public static final String PREVIOUS_BUTTON = "submit_prev";
    public static final String NEXT_BUTTON = "submit_next";
    public static final String SELECT_CHANGE = "submit_change";
    public static final String CANCEL_BUTTON = "submit_cancel";
    public static final String PROGRESS_BAR_PREFIX = "submit_jump_";
    public static final int LAST_PAGE_REACHED = Integer.MAX_VALUE;
    public static final int STATUS_COMPLETE = 0;
    private Map<Integer, String> errorMessages = null;
    private static final String ERROR_FIELDS_ATTRIBUTE = "dspace.submit.error_fields";
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public abstract int doProcessing(Context var1, HttpServletRequest var2, HttpServletResponse var3, SubmissionInfo var4) throws ServletException, IOException, SQLException, AuthorizeException;

    public static final List<String> getErrorFields(HttpServletRequest request) {
        return (List)request.getAttribute(ERROR_FIELDS_ATTRIBUTE);
    }

    private static final void setErrorFields(HttpServletRequest request, List<String> errorFields) {
        if (errorFields == null) {
            request.removeAttribute(ERROR_FIELDS_ATTRIBUTE);
        } else {
            request.setAttribute(ERROR_FIELDS_ATTRIBUTE, errorFields);
        }
    }

    protected static final void addErrorField(HttpServletRequest request, String fieldName) {
        List<String> errorFields = AbstractProcessingStep.getErrorFields(request);
        if (errorFields == null) {
            errorFields = new ArrayList<String>();
        }
        errorFields.add(fieldName);
        AbstractProcessingStep.setErrorFields(request, errorFields);
    }

    protected static final void clearErrorFields(HttpServletRequest request) {
        List<String> errorFields = AbstractProcessingStep.getErrorFields(request);
        if (errorFields != null) {
            AbstractProcessingStep.setErrorFields(request, null);
        }
    }

    public final String getErrorMessage(int errorFlag) {
        if (this.errorMessages == null || this.errorMessages.size() == 0) {
            return null;
        }
        return this.errorMessages.get(errorFlag);
    }

    protected final void addErrorMessage(int errorFlag, String errorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new HashMap<Integer, String>();
        }
        this.errorMessages.put(errorFlag, errorMessage);
    }

    public abstract int getNumberOfPages(HttpServletRequest var1, SubmissionInfo var2) throws ServletException;

    public static final int getCurrentPage(HttpServletRequest request) {
        int pageNum = -1;
        Integer currentPage = (Integer)request.getAttribute("submission.page");
        if (currentPage == null) {
            String val = request.getParameter("page");
            try {
                pageNum = Integer.parseInt(val.trim());
            }
            catch (Exception e) {
                pageNum = -1;
            }
            if (pageNum < 0) {
                pageNum = 1;
                AbstractProcessingStep.setCurrentPage(request, pageNum);
            } else {
                AbstractProcessingStep.setCurrentPage(request, pageNum);
            }
        } else {
            pageNum = currentPage;
        }
        return pageNum;
    }

    public static final void setCurrentPage(HttpServletRequest request, int pageNumber) {
        request.setAttribute("submission.page", (Object)pageNumber);
    }
}

