/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.lookup.ArxivUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArXivService {
    private int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public List<Record> getByDOIs(Set<String> dois) throws HttpException, IOException {
        if (dois != null && dois.size() > 0) {
            String doisQuery = StringUtils.join(dois.iterator(), (String)" OR ");
            return this.search(doisQuery, null, 100);
        }
        return null;
    }

    public List<Record> searchByTerm(String title, String author, int year) throws HttpException, IOException {
        StringBuffer query = new StringBuffer();
        if (StringUtils.isNotBlank((String)title)) {
            query.append("ti:\"").append(title).append("\"");
        }
        if (StringUtils.isNotBlank((String)author)) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append("au:\"").append(author).append("\"");
        }
        return this.search(query.toString(), "", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Record> search(String query, String arxivid, int max_result) throws IOException, HttpException {
        ArrayList<Record> results = new ArrayList<Record>();
        HttpGet method = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpParams params = client.getParams();
            params.setIntParameter("http.connection.timeout", this.timeout);
            try {
                URIBuilder uriBuilder = new URIBuilder("http://export.arxiv.org/api/query");
                uriBuilder.addParameter("id_list", arxivid);
                uriBuilder.addParameter("search_query", query);
                uriBuilder.addParameter("max_results", String.valueOf(max_result));
                method = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new HttpException(ex.getMessage());
            }
            HttpResponse response = client.execute((HttpUriRequest)method);
            StatusLine responseStatus = response.getStatusLine();
            int statusCode = responseStatus.getStatusCode();
            if (statusCode != 200) {
                if (statusCode == 400) {
                    throw new RuntimeException("arXiv query is not valid");
                }
                throw new RuntimeException("Http call failed: " + responseStatus);
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                factory.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = factory.newDocumentBuilder();
                Document inDoc = db.parse(response.getEntity().getContent());
                Element xmlRoot = inDoc.getDocumentElement();
                List<Element> dataRoots = XMLUtils.getElementList(xmlRoot, "entry");
                for (Element dataRoot : dataRoots) {
                    Record crossitem = ArxivUtils.convertArxixDomToRecord(dataRoot);
                    if (crossitem == null) continue;
                    results.add(crossitem);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("ArXiv identifier is not valid or not exist");
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return results;
    }

    public Record getByArXivIDs(String raw) throws HttpException, IOException {
        if (StringUtils.isNotBlank((String)raw)) {
            if ((raw = raw.trim()).startsWith("http://arxiv.org/abs/")) {
                raw = raw.substring("http://arxiv.org/abs/".length());
            } else if (raw.toLowerCase().startsWith("arxiv:")) {
                raw = raw.substring("arxiv:".length());
            }
            List<Record> result = this.search("", raw, 1);
            if (result != null && result.size() > 0) {
                return result.get(0);
            }
        }
        return null;
    }
}

