/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.license.CCLookup;
import org.dspace.license.LicenseMetadataValue;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.submit.AbstractProcessingStep;

public class CCLicenseStep
extends AbstractProcessingStep {
    public static final int STATUS_LICENSE_REJECTED = 1;
    private static Logger log = Logger.getLogger(CCLicenseStep.class);
    protected final CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException, IOException {
        HttpSession session = request.getSession();
        session.setAttribute("inProgress", (Object)"TRUE");
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        if ("submit_grant".equalsIgnoreCase(buttonPressed) || "submit_no_cc".equalsIgnoreCase(buttonPressed)) {
            return this.processCC(context, request, response, subInfo);
        }
        String choiceButton = Util.getSubmitButton(request, "submit_change");
        Enumeration e = request.getParameterNames();
        String isFieldRequired = "FALSE";
        while (e.hasMoreElements()) {
            String parameterName = (String)e.nextElement();
            if (!parameterName.equals("button_required")) continue;
            isFieldRequired = "TRUE";
            break;
        }
        session.setAttribute("isFieldRequired", (Object)isFieldRequired);
        if (choiceButton.equals("submit_change")) {
            Item item = subInfo.getSubmissionItem().getItem();
            LicenseMetadataValue uriField = this.creativeCommonsService.getCCField("uri");
            LicenseMetadataValue nameField = this.creativeCommonsService.getCCField("name");
            String licenseUri = uriField.ccItemValue(item);
            if (licenseUri != null) {
                uriField.removeItemValue(context, item, licenseUri);
                if (this.configurationService.getBooleanProperty("cc.submit.setname")) {
                    String licenseName = nameField.keyedItemValue(item, licenseUri);
                    nameField.removeItemValue(context, item, licenseName);
                }
                if (this.configurationService.getBooleanProperty("cc.submit.addBitstream")) {
                    this.creativeCommonsService.removeLicense(context, item);
                }
                this.removeRequiredAttributes(session);
                this.itemService.update(context, item);
                context.dispatchEvents();
            }
            return 0;
        }
        if (buttonPressed.startsWith("submit_jump_") || buttonPressed.equals("submit_prev")) {
            this.removeRequiredAttributes(session);
        }
        if (buttonPressed.equals("submit_next") || buttonPressed.equals("submit_cancel")) {
            return this.processCCWS(context, request, response, subInfo);
        }
        this.removeRequiredAttributes(session);
        session.removeAttribute("inProgress");
        return 0;
    }

    protected int processCC(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        String ccLicenseUrl = request.getParameter("cc_license_url");
        if (buttonPressed.equals("submit_no_cc")) {
            this.creativeCommonsService.removeLicense(context, subInfo.getSubmissionItem().getItem());
        } else if (ccLicenseUrl != null && ccLicenseUrl.length() > 0) {
            Item item = subInfo.getSubmissionItem().getItem();
            this.creativeCommonsService.setLicense(context, item, ccLicenseUrl);
        }
        context.dispatchEvents();
        return 0;
    }

    protected int processCCWS(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String jurisdiction;
        HttpSession session = request.getSession();
        HashMap<String, String> map = new HashMap<String, String>();
        String licenseclass = request.getParameter("licenseclass_chooser") != null ? request.getParameter("licenseclass_chooser") : "";
        String string = jurisdiction = this.configurationService.getProperty("cc.license.jurisdiction") != null ? this.configurationService.getProperty("cc.license.jurisdiction") : "";
        if (licenseclass.equals("standard")) {
            map.put("commercial", request.getParameter("commercial_chooser"));
            map.put("derivatives", request.getParameter("derivatives_chooser"));
        } else if (licenseclass.equals("recombo")) {
            map.put("sampling", request.getParameter("sampling_chooser"));
        }
        map.put("jurisdiction", jurisdiction);
        CCLookup ccLookup = new CCLookup();
        LicenseMetadataValue uriField = this.creativeCommonsService.getCCField("uri");
        LicenseMetadataValue nameField = this.creativeCommonsService.getCCField("name");
        ccLookup.issue(licenseclass, map, this.configurationService.getProperty("cc.license.locale"));
        Item item = subInfo.getSubmissionItem().getItem();
        if (licenseclass.equals("xmlui.Submission.submit.CCLicenseStep.no_license")) {
            String licenseUri = uriField.ccItemValue(item);
            if (licenseUri != null) {
                uriField.removeItemValue(context, item, licenseUri);
                if (this.configurationService.getBooleanProperty("cc.submit.setname")) {
                    String licenseName = nameField.keyedItemValue(item, licenseUri);
                    nameField.removeItemValue(context, item, licenseName);
                }
                if (this.configurationService.getBooleanProperty("cc.submit.addBitstream")) {
                    this.creativeCommonsService.removeLicense(context, item);
                }
                this.itemService.update(context, item);
                context.dispatchEvents();
                this.removeRequiredAttributes(session);
            }
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)licenseclass) || licenseclass.equals("xmlui.Submission.submit.CCLicenseStep.select_change")) {
            this.removeRequiredAttributes(session);
            return 0;
        }
        if (ccLookup.isSuccess()) {
            uriField.addItemValue(context, item, ccLookup.getLicenseUrl());
            if (this.configurationService.getBooleanProperty("cc.submit.addbitstream")) {
                this.creativeCommonsService.setLicenseRDF(context, item, ccLookup.getRdf());
            }
            if (this.configurationService.getBooleanProperty("cc.submit.setname")) {
                nameField.addItemValue(context, item, ccLookup.getLicenseName());
            }
        } else {
            request.getSession().setAttribute("ccError", (Object)ccLookup.getErrorMessage());
            String licenseUri = uriField.ccItemValue(item);
            if (licenseUri != null) {
                uriField.removeItemValue(context, item, licenseUri);
            }
            return 1;
        }
        this.itemService.update(context, item);
        context.dispatchEvents();
        this.removeRequiredAttributes(session);
        session.removeAttribute("inProgress");
        return 0;
    }

    private void removeRequiredAttributes(HttpSession session) {
        session.removeAttribute("ccError");
        session.removeAttribute("isFieldRequired");
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

