/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class SelectCollectionStep
extends AbstractProcessingStep {
    public static final int STATUS_NO_COLLECTION = 1;
    public static final int STATUS_INVALID_COLLECTION = 2;
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        UUID id = Util.getUUIDParameter(request, "collection");
        if (id == null) {
            return 1;
        }
        Collection col = (Collection)this.collectionService.find(context, id);
        if (col == null) {
            return 2;
        }
        WorkspaceItem wi = this.workspaceItemService.create(context, col, true);
        subInfo.setSubmissionItem(wi);
        context.dispatchEvents();
        subInfo.reloadSubmissionConfig(request);
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

