/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractVersionProvider {
    private Set<String> ignoredMetadataFields;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected BitstreamStorageService bitstreamStorageService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected ItemService itemService;

    protected void copyMetadata(Context context, Item itemNew, Item nativeItem) throws SQLException {
        List<MetadataValue> md = this.itemService.getMetadata(nativeItem, "*", "*", "*", "*");
        for (MetadataValue aMd : md) {
            MetadataField metadataField = aMd.getMetadataField();
            MetadataSchema metadataSchema = metadataField.getMetadataSchema();
            String unqualifiedMetadataField = metadataSchema.getName() + "." + metadataField.getElement();
            if (this.getIgnoredMetadataFields().contains(metadataField.toString('.')) || this.getIgnoredMetadataFields().contains(unqualifiedMetadataField + "." + "*")) continue;
            this.itemService.addMetadata(context, itemNew, metadataField, aMd.getLanguage(), aMd.getValue(), aMd.getAuthority(), aMd.getConfidence());
        }
    }

    protected void createBundlesAndAddBitstreams(Context c, Item itemNew, Item nativeItem) throws SQLException, AuthorizeException, IOException {
        for (Bundle nativeBundle : nativeItem.getBundles()) {
            Bundle bundleNew = this.bundleService.create(c, itemNew, nativeBundle.getName());
            List<ResourcePolicy> bundlePolicies = this.authorizeService.findPoliciesByDSOAndType(c, nativeBundle, ResourcePolicy.TYPE_CUSTOM);
            this.authorizeService.addPolicies(c, bundlePolicies, bundleNew);
            for (Bitstream nativeBitstream : nativeBundle.getBitstreams()) {
                Bitstream bitstreamNew = this.createBitstream(c, nativeBitstream);
                this.bundleService.addBitstream(c, bundleNew, bitstreamNew);
                this.authorizeService.removeAllPoliciesByDSOAndType(c, bitstreamNew, ResourcePolicy.TYPE_CUSTOM);
                List<ResourcePolicy> bitstreamPolicies = this.authorizeService.findPoliciesByDSOAndType(c, nativeBitstream, ResourcePolicy.TYPE_CUSTOM);
                this.authorizeService.addPolicies(c, bitstreamPolicies, bitstreamNew);
                if (nativeBundle.getPrimaryBitstream() != null && nativeBundle.getPrimaryBitstream().equals(nativeBitstream)) {
                    bundleNew.setPrimaryBitstreamID(bitstreamNew);
                }
                this.bitstreamService.update(c, bitstreamNew);
            }
        }
    }

    protected Bitstream createBitstream(Context context, Bitstream nativeBitstream) throws AuthorizeException, SQLException, IOException {
        Bitstream newBitstream = this.bitstreamStorageService.clone(context, nativeBitstream);
        List<MetadataValue> bitstreamMeta = this.bitstreamService.getMetadata(nativeBitstream, "*", "*", "*", "*");
        for (MetadataValue value : bitstreamMeta) {
            this.bitstreamService.addMetadata(context, newBitstream, value.getMetadataField(), value.getLanguage(), value.getValue(), value.getAuthority(), value.getConfidence());
        }
        return newBitstream;
    }

    public void setIgnoredMetadataFields(Set<String> ignoredMetadataFields) {
        this.ignoredMetadataFields = ignoredMetadataFields;
    }

    public Set getIgnoredMetadataFields() {
        return this.ignoredMetadataFields;
    }
}

