/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageWorkflowEvent;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowUtils;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.Action;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.UserSelectionActionConfig;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class XmlWorkflowServiceImpl
implements XmlWorkflowService {
    protected Map<UUID, Boolean> noEMail = new HashMap<UUID, Boolean>();
    private Logger log = Logger.getLogger(XmlWorkflowServiceImpl.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CollectionRoleService collectionRoleService;
    @Autowired(required=true)
    protected ClaimedTaskService claimedTaskService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected InstallItemService installItemService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected PoolTaskService poolTaskService;
    @Autowired(required=true)
    protected WorkflowItemRoleService workflowItemRoleService;
    @Autowired(required=true)
    protected WorkflowRequirementsService workflowRequirementsService;
    @Autowired(required=true)
    protected XmlWorkflowFactory xmlWorkflowFactory;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected XmlWorkflowItemService xmlWorkflowItemService;
    @Autowired(required=true)
    protected GroupService groupService;

    protected XmlWorkflowServiceImpl() {
    }

    @Override
    public void addInitialWorkspaceItemPolicies(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
    }

    @Override
    public void deleteCollection(Context context, Collection collection) throws SQLException, IOException, AuthorizeException {
        this.xmlWorkflowItemService.deleteByCollection(context, collection);
        this.collectionRoleService.deleteByCollection(context, collection);
    }

    @Override
    public List<String> getEPersonDeleteConstraints(Context context, EPerson ePerson) throws SQLException {
        ArrayList<String> constraints = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.claimedTaskService.findByEperson(context, ePerson))) {
            constraints.add("cwf_claimtask");
        }
        if (CollectionUtils.isNotEmpty(this.poolTaskService.findByEPerson(context, ePerson))) {
            constraints.add("cwf_pooltask");
        }
        if (CollectionUtils.isNotEmpty(this.workflowItemRoleService.findByEPerson(context, ePerson))) {
            constraints.add("cwf_workflowitemrole");
        }
        return constraints;
    }

    @Override
    public Group getWorkflowRoleGroup(Context context, Collection collection, String roleName, Group roleGroup) throws SQLException, IOException, WorkflowException, AuthorizeException {
        try {
            Role role = WorkflowUtils.getCollectionAndRepositoryRoles(collection).get(roleName);
            if ((role.getScope() == Role.Scope.COLLECTION || role.getScope() == Role.Scope.REPOSITORY) && (roleGroup = WorkflowUtils.getRoleGroup(context, collection, role)) == null) {
                this.authorizeService.authorizeAction(context, collection, 1);
                roleGroup = this.groupService.create(context);
                if (role.getScope() == Role.Scope.COLLECTION) {
                    this.groupService.setName(roleGroup, "COLLECTION_" + collection.getID().toString() + "_WORKFLOW_ROLE_" + roleName);
                } else {
                    this.groupService.setName(roleGroup, role.getName());
                }
                this.groupService.update(context, roleGroup);
                this.authorizeService.addPolicy(context, (DSpaceObject)collection, 3, roleGroup);
                if (role.getScope() == Role.Scope.COLLECTION) {
                    WorkflowUtils.createCollectionWorkflowRole(context, collection, roleName, roleGroup);
                }
            }
            return roleGroup;
        }
        catch (WorkflowConfigurationException e) {
            throw new WorkflowException(e);
        }
    }

    @Override
    public List<String> getFlywayMigrationLocations() {
        return Collections.singletonList("classpath:org.dspace.storage.rdbms.xmlworkflow");
    }

    @Override
    public XmlWorkflowItem start(Context context, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException, WorkflowException {
        try {
            Item myitem = wsi.getItem();
            Collection collection = wsi.getCollection();
            Workflow wf = this.xmlWorkflowFactory.getWorkflow(collection);
            XmlWorkflowItem wfi = (XmlWorkflowItem)this.xmlWorkflowItemService.create(context, myitem, collection);
            wfi.setMultipleFiles(wsi.hasMultipleFiles());
            wfi.setMultipleTitles(wsi.hasMultipleTitles());
            wfi.setPublishedBefore(wsi.isPublishedBefore());
            this.xmlWorkflowItemService.update(context, wfi);
            this.removeUserItemPolicies(context, myitem, myitem.getSubmitter());
            this.grantSubmitterReadPolicies(context, myitem);
            context.turnOffAuthorisationSystem();
            Step firstStep = wf.getFirstStep();
            if (firstStep.isValidStep(context, wfi)) {
                this.activateFirstStep(context, wf, firstStep, wfi);
            } else if ((firstStep = wf.getNextStep(context, wfi, firstStep, 0)) == null) {
                this.archive(context, wfi);
            } else {
                this.activateFirstStep(context, wf, firstStep, wfi);
            }
            this.workspaceItemService.deleteWrapper(context, wsi);
            context.restoreAuthSystemState();
            return wfi;
        }
        catch (WorkflowConfigurationException e) {
            throw new WorkflowException(e);
        }
    }

    @Override
    public XmlWorkflowItem startWithoutNotify(Context context, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException, WorkflowException {
        this.noEMail.put(wsi.getItem().getID(), Boolean.TRUE);
        return this.start(context, wsi);
    }

    @Override
    public void alertUsersOnTaskActivation(Context c, XmlWorkflowItem wfi, String emailTemplate, List<EPerson> epa, String ... arguments) throws IOException, SQLException, MessagingException {
        if (this.noEMail.containsKey(wfi.getItem().getID())) {
            this.noEMail.remove(wfi.getItem().getID());
        } else {
            Email mail = Email.getEmail(I18nUtil.getEmailFilename(c.getCurrentLocale(), emailTemplate));
            for (String argument : arguments) {
                mail.addArgument(argument);
            }
            for (EPerson anEpa : epa) {
                mail.addRecipient(anEpa.getEmail());
            }
            mail.send();
        }
    }

    protected void grantSubmitterReadPolicies(Context context, Item item) throws SQLException, AuthorizeException {
        ArrayList<Integer> userHasPolicies = new ArrayList<Integer>();
        List<ResourcePolicy> itempols = this.authorizeService.getPolicies(context, item);
        EPerson submitter = item.getSubmitter();
        for (ResourcePolicy resourcePolicy : itempols) {
            if (!submitter.equals(resourcePolicy.getEPerson())) continue;
            userHasPolicies.add(resourcePolicy.getAction());
        }
        if (!userHasPolicies.contains(0)) {
            this.addPolicyToItem(context, item, 0, submitter);
        }
    }

    protected void activateFirstStep(Context context, Workflow wf, Step firstStep, XmlWorkflowItem wfi) throws AuthorizeException, IOException, SQLException, WorkflowException, WorkflowConfigurationException {
        UserSelectionActionConfig firstActionConfig = firstStep.getUserSelectionMethod();
        ((WorkflowActionConfig)firstActionConfig).getProcessingAction().activate(context, wfi);
        this.log.info((Object)LogManager.getHeader(context, "start_workflow", ((WorkflowActionConfig)firstActionConfig).getProcessingAction() + " workflow_item_id=" + wfi.getID() + "item_id=" + wfi.getItem().getID() + "collection_id=" + wfi.getCollection().getID()));
        this.recordStart(context, wfi.getItem(), ((WorkflowActionConfig)firstActionConfig).getProcessingAction());
        this.logWorkflowEvent(context, firstStep.getWorkflow().getID(), null, null, wfi, null, firstStep, firstActionConfig);
        if (!firstActionConfig.requiresUI()) {
            ActionResult outcome = ((WorkflowActionConfig)firstActionConfig).getProcessingAction().execute(context, wfi, firstStep, null);
            this.processOutcome(context, null, wf, firstStep, firstActionConfig, outcome, wfi, true);
        }
    }

    @Override
    public WorkflowActionConfig doState(Context c, EPerson user, HttpServletRequest request, int workflowItemId, Workflow workflow, WorkflowActionConfig currentActionConfig) throws SQLException, AuthorizeException, IOException, MessagingException, WorkflowException {
        try {
            XmlWorkflowItem wi = (XmlWorkflowItem)this.xmlWorkflowItemService.find(c, workflowItemId);
            Step currentStep = currentActionConfig.getStep();
            if (currentActionConfig.getProcessingAction().isAuthorized(c, request, wi)) {
                ActionResult outcome = currentActionConfig.getProcessingAction().execute(c, wi, currentStep, request);
                return this.processOutcome(c, user, workflow, currentStep, currentActionConfig, outcome, wi, false);
            }
            throw new AuthorizeException("You are not allowed to to perform this task.");
        }
        catch (WorkflowConfigurationException e) {
            this.log.error((Object)LogManager.getHeader(c, "error while executing state", "workflow:  " + workflow.getID() + " action: " + currentActionConfig.getId() + " workflowItemId: " + workflowItemId), (Throwable)e);
            WorkflowUtils.sendAlert(request, e);
            throw new WorkflowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowActionConfig processOutcome(Context c, EPerson user, Workflow workflow, Step currentStep, WorkflowActionConfig currentActionConfig, ActionResult currentOutcome, XmlWorkflowItem wfi, boolean enteredNewStep) throws IOException, AuthorizeException, SQLException, WorkflowException {
        if (currentOutcome.getType() == ActionResult.TYPE.TYPE_PAGE || currentOutcome.getType() == ActionResult.TYPE.TYPE_ERROR) {
            c.restoreAuthSystemState();
            return currentActionConfig;
        }
        if (currentOutcome.getType() == ActionResult.TYPE.TYPE_CANCEL || currentOutcome.getType() == ActionResult.TYPE.TYPE_SUBMISSION_PAGE) {
            c.restoreAuthSystemState();
            return null;
        }
        if (currentOutcome.getType() == ActionResult.TYPE.TYPE_OUTCOME) {
            Step nextStep = null;
            WorkflowActionConfig nextActionConfig = null;
            try {
                if (currentOutcome.getResult() == 0) {
                    nextActionConfig = currentStep.getNextAction(currentActionConfig);
                }
                if (nextActionConfig != null) {
                    nextStep = currentStep;
                    nextActionConfig.getProcessingAction().activate(c, wfi);
                    if (nextActionConfig.requiresUI() && !enteredNewStep) {
                        this.createOwnedTask(c, wfi, currentStep, nextActionConfig, user);
                        WorkflowActionConfig workflowActionConfig = nextActionConfig;
                        return workflowActionConfig;
                    }
                    if (nextActionConfig.requiresUI() && enteredNewStep) {
                        c.restoreAuthSystemState();
                        WorkflowActionConfig workflowActionConfig = null;
                        return workflowActionConfig;
                    }
                    ActionResult newOutcome = nextActionConfig.getProcessingAction().execute(c, wfi, currentStep, null);
                    WorkflowActionConfig workflowActionConfig = this.processOutcome(c, user, workflow, currentStep, nextActionConfig, newOutcome, wfi, enteredNewStep);
                    return workflowActionConfig;
                }
                if (enteredNewStep) {
                    nextStep = workflow.getNextStep(c, wfi, currentStep, currentOutcome.getResult());
                    c.turnOffAuthorisationSystem();
                    nextActionConfig = this.processNextStep(c, user, workflow, currentOutcome, wfi, nextStep);
                    if (nextActionConfig == null || nextActionConfig.requiresUI()) {
                        WorkflowActionConfig newOutcome = null;
                        return newOutcome;
                    }
                    WorkflowActionConfig newOutcome = nextActionConfig;
                    return newOutcome;
                }
                ClaimedTask task = this.claimedTaskService.findByWorkflowIdAndEPerson(c, wfi, user);
                this.workflowRequirementsService.addFinishedUser(c, wfi, user);
                c.turnOffAuthorisationSystem();
                if (currentStep.isFinished(c, wfi) && currentOutcome.getResult() == 0 || currentOutcome.getResult() != 0) {
                    this.workflowRequirementsService.clearInProgressUsers(c, wfi);
                    this.deleteAllTasks(c, wfi);
                    nextStep = workflow.getNextStep(c, wfi, currentStep, currentOutcome.getResult());
                    nextActionConfig = this.processNextStep(c, user, workflow, currentOutcome, wfi, nextStep);
                    if (nextActionConfig == null || nextActionConfig.requiresUI()) {
                        WorkflowActionConfig workflowActionConfig = null;
                        return workflowActionConfig;
                    }
                    WorkflowActionConfig workflowActionConfig = nextActionConfig;
                    return workflowActionConfig;
                }
                this.deleteClaimedTask(c, wfi, task);
                c.restoreAuthSystemState();
                nextStep = currentStep;
                nextActionConfig = currentActionConfig;
                WorkflowActionConfig workflowActionConfig = null;
                return workflowActionConfig;
            }
            catch (Exception e) {
                this.log.error((Object)"error while processing workflow outcome", (Throwable)e);
                e.printStackTrace();
            }
            finally {
                if (nextStep != null && currentStep != null && nextActionConfig != null || wfi.getItem().isArchived() && currentStep != null) {
                    this.logWorkflowEvent(c, currentStep.getWorkflow().getID(), currentStep.getId(), currentActionConfig.getId(), wfi, user, nextStep, nextActionConfig);
                }
            }
        }
        this.log.error((Object)LogManager.getHeader(c, "Invalid step outcome", "Workflow item id: " + wfi.getID()));
        throw new WorkflowException("Invalid step outcome");
    }

    protected void logWorkflowEvent(Context c, String workflowId, String previousStepId, String previousActionConfigId, XmlWorkflowItem wfi, EPerson actor, Step newStep, WorkflowActionConfig newActionConfig) throws SQLException {
        try {
            Item item = wfi.getItem();
            Collection myCollection = wfi.getCollection();
            String workflowStepString = null;
            ArrayList<EPerson> currentEpersonOwners = new ArrayList<EPerson>();
            ArrayList<Group> currentGroupOwners = new ArrayList<Group>();
            if (newStep != null && newActionConfig != null) {
                workflowStepString = workflowId + "." + newStep.getId() + "." + newActionConfig.getId();
                List<ClaimedTask> claimedTasks = this.claimedTaskService.find(c, wfi, newStep.getId());
                List<PoolTask> pooledTasks = this.poolTaskService.find(c, wfi);
                for (PoolTask poolTask : pooledTasks) {
                    if (poolTask.getEperson() != null) {
                        currentEpersonOwners.add(poolTask.getEperson());
                        continue;
                    }
                    currentGroupOwners.add(poolTask.getGroup());
                }
                for (ClaimedTask claimedTask : claimedTasks) {
                    currentEpersonOwners.add(claimedTask.getOwner());
                }
            }
            String previousWorkflowStepString = null;
            if (previousStepId != null && previousActionConfigId != null) {
                previousWorkflowStepString = workflowId + "." + previousStepId + "." + previousActionConfigId;
            }
            UsageWorkflowEvent usageWorkflowEvent = new UsageWorkflowEvent(c, item, wfi, workflowStepString, previousWorkflowStepString, myCollection, actor);
            usageWorkflowEvent.setEpersonOwners(currentEpersonOwners.toArray(new EPerson[currentEpersonOwners.size()]));
            usageWorkflowEvent.setGroupOwners(currentGroupOwners.toArray(new Group[currentGroupOwners.size()]));
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)usageWorkflowEvent);
        }
        catch (Exception e) {
            this.log.error((Object)LogManager.getHeader(c, "Error while logging workflow event", "Workflow Item: " + wfi.getID()), (Throwable)e);
        }
    }

    protected WorkflowActionConfig processNextStep(Context c, EPerson user, Workflow workflow, ActionResult currentOutcome, XmlWorkflowItem wfi, Step nextStep) throws SQLException, IOException, AuthorizeException, WorkflowException, WorkflowConfigurationException {
        if (nextStep != null) {
            UserSelectionActionConfig nextActionConfig = nextStep.getUserSelectionMethod();
            ((WorkflowActionConfig)nextActionConfig).getProcessingAction().activate(c, wfi);
            if (nextActionConfig.requiresUI()) {
                c.restoreAuthSystemState();
                return nextActionConfig;
            }
            ActionResult newOutcome = ((WorkflowActionConfig)nextActionConfig).getProcessingAction().execute(c, wfi, nextStep, null);
            c.restoreAuthSystemState();
            return this.processOutcome(c, user, workflow, nextStep, nextActionConfig, newOutcome, wfi, true);
        }
        if (currentOutcome.getResult() != 0) {
            c.restoreAuthSystemState();
            throw new WorkflowException("No alternate step was found for outcome: " + currentOutcome.getResult());
        }
        this.archive(c, wfi);
        c.restoreAuthSystemState();
        return null;
    }

    @Override
    public Item archive(Context context, XmlWorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item item = wfi.getItem();
        Collection collection = wfi.getCollection();
        this.workflowItemRoleService.deleteForWorkflowItem(context, wfi);
        this.log.info((Object)LogManager.getHeader(context, "archive_item", "workflow_item_id=" + wfi.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        this.installItemService.installItem(context, wfi);
        this.notifyOfArchive(context, item, collection);
        this.itemService.clearMetadata(context, item, "workflow", "*", "*", "*");
        this.itemService.update(context, item);
        this.log.info((Object)LogManager.getHeader(context, "install_item", "workflow_item_id=" + wfi.getID() + ", item_id=" + item.getID() + "handle=FIXME"));
        return item;
    }

    protected void notifyOfArchive(Context context, Item item, Collection coll) throws SQLException, IOException {
        try {
            EPerson ep = item.getSubmitter();
            Locale supportedLocale = I18nUtil.getEPersonLocale(ep);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_archive"));
            String handle = this.handleService.findHandle(context, item);
            List<MetadataValue> titles = this.itemService.getMetadata(item, "dc", "title", null, "*");
            String title = "";
            try {
                title = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                title = "Untitled";
            }
            if (titles.size() > 0) {
                title = titles.iterator().next().getValue();
            }
            email.addRecipient(ep.getEmail());
            email.addArgument(title);
            email.addArgument(coll.getName());
            email.addArgument(this.handleService.getCanonicalForm(handle));
            email.send();
        }
        catch (MessagingException e) {
            this.log.warn((Object)LogManager.getHeader(context, "notifyOfArchive", "cannot email user item_id=" + item.getID()));
        }
    }

    @Override
    public void deleteAllTasks(Context context, XmlWorkflowItem wi) throws SQLException, AuthorizeException {
        this.deleteAllPooledTasks(context, wi);
        Iterator<ClaimedTask> allClaimedTasks = this.claimedTaskService.findByWorkflowItem(context, wi).iterator();
        while (allClaimedTasks.hasNext()) {
            ClaimedTask task = allClaimedTasks.next();
            allClaimedTasks.remove();
            this.deleteClaimedTask(context, wi, task);
        }
    }

    @Override
    public void deleteAllPooledTasks(Context context, XmlWorkflowItem wi) throws SQLException, AuthorizeException {
        Iterator<PoolTask> allPooledTasks = this.poolTaskService.find(context, wi).iterator();
        while (allPooledTasks.hasNext()) {
            PoolTask poolTask = allPooledTasks.next();
            allPooledTasks.remove();
            this.deletePooledTask(context, wi, poolTask);
        }
    }

    @Override
    public void deletePooledTask(Context context, XmlWorkflowItem wi, PoolTask task) throws SQLException, AuthorizeException {
        if (task != null) {
            if (task.getEperson() != null) {
                this.removeUserItemPolicies(context, wi.getItem(), task.getEperson());
            } else {
                this.removeGroupItemPolicies(context, wi.getItem(), task.getGroup());
            }
            this.poolTaskService.delete(context, task);
        }
    }

    @Override
    public void deleteClaimedTask(Context c, XmlWorkflowItem wi, ClaimedTask task) throws SQLException, AuthorizeException {
        if (task != null) {
            this.removeUserItemPolicies(c, wi.getItem(), task.getOwner());
            this.claimedTaskService.delete(c, task);
        }
    }

    @Override
    public void createPoolTasks(Context context, XmlWorkflowItem wi, RoleMembers assignees, Step step, WorkflowActionConfig action) throws SQLException, AuthorizeException {
        PoolTask task;
        for (EPerson anEpa : assignees.getEPersons()) {
            task = (PoolTask)this.poolTaskService.create(context);
            task.setStepID(step.getId());
            task.setWorkflowID(step.getWorkflow().getID());
            task.setEperson(anEpa);
            task.setActionID(action.getId());
            task.setWorkflowItem(wi);
            this.poolTaskService.update(context, task);
            this.grantUserAllItemPolicies(context, wi.getItem(), anEpa);
        }
        for (Group group : assignees.getGroups()) {
            task = (PoolTask)this.poolTaskService.create(context);
            task.setStepID(step.getId());
            task.setWorkflowID(step.getWorkflow().getID());
            task.setGroup(group);
            task.setActionID(action.getId());
            task.setWorkflowItem(wi);
            this.poolTaskService.update(context, task);
            this.grantGroupAllItemPolicies(context, wi.getItem(), group);
        }
    }

    @Override
    public void createOwnedTask(Context context, XmlWorkflowItem wi, Step step, WorkflowActionConfig action, EPerson e) throws SQLException, AuthorizeException {
        ClaimedTask task = (ClaimedTask)this.claimedTaskService.create(context);
        task.setWorkflowItem(wi);
        task.setStepID(step.getId());
        task.setActionID(action.getId());
        task.setOwner(e);
        task.setWorkflowID(step.getWorkflow().getID());
        this.claimedTaskService.update(context, task);
        this.grantUserAllItemPolicies(context, wi.getItem(), e);
    }

    protected void grantUserAllItemPolicies(Context context, Item item, EPerson epa) throws AuthorizeException, SQLException {
        if (epa != null) {
            ArrayList<Integer> userHasPolicies = new ArrayList<Integer>();
            List<ResourcePolicy> itempols = this.authorizeService.getPolicies(context, item);
            for (ResourcePolicy resourcePolicy : itempols) {
                if (!epa.equals(resourcePolicy.getEPerson())) continue;
                userHasPolicies.add(resourcePolicy.getAction());
            }
            if (!userHasPolicies.contains(0)) {
                this.addPolicyToItem(context, item, 0, epa);
            }
            if (!userHasPolicies.contains(1)) {
                this.addPolicyToItem(context, item, 1, epa);
            }
            if (!userHasPolicies.contains(2)) {
                this.addPolicyToItem(context, item, 2, epa);
            }
            if (!userHasPolicies.contains(3)) {
                this.addPolicyToItem(context, item, 3, epa);
            }
            if (!userHasPolicies.contains(4)) {
                this.addPolicyToItem(context, item, 4, epa);
            }
        }
    }

    protected void grantGroupAllItemPolicies(Context context, Item item, Group group) throws AuthorizeException, SQLException {
        if (group != null) {
            ArrayList<Integer> groupHasPolicies = new ArrayList<Integer>();
            List<ResourcePolicy> itempols = this.authorizeService.getPolicies(context, item);
            for (ResourcePolicy resourcePolicy : itempols) {
                if (!group.equals(resourcePolicy.getGroup())) continue;
                groupHasPolicies.add(resourcePolicy.getAction());
            }
            if (!groupHasPolicies.contains(0)) {
                this.addGroupPolicyToItem(context, item, 0, group);
            }
            if (!groupHasPolicies.contains(1)) {
                this.addGroupPolicyToItem(context, item, 1, group);
            }
            if (!groupHasPolicies.contains(2)) {
                this.addGroupPolicyToItem(context, item, 2, group);
            }
            if (!groupHasPolicies.contains(3)) {
                this.addGroupPolicyToItem(context, item, 3, group);
            }
            if (!groupHasPolicies.contains(4)) {
                this.addGroupPolicyToItem(context, item, 4, group);
            }
        }
    }

    protected void addPolicyToItem(Context context, Item item, int type, EPerson epa) throws AuthorizeException, SQLException {
        if (epa != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, type, epa);
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                this.authorizeService.addPolicy(context, (DSpaceObject)bundle, type, epa);
                List<Bitstream> bits = bundle.getBitstreams();
                for (Bitstream bit : bits) {
                    this.authorizeService.addPolicy(context, (DSpaceObject)bit, type, epa);
                }
            }
        }
    }

    protected void addGroupPolicyToItem(Context context, Item item, int type, Group group) throws AuthorizeException, SQLException {
        if (group != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, type, group);
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                this.authorizeService.addPolicy(context, (DSpaceObject)bundle, type, group);
                List<Bitstream> bits = bundle.getBitstreams();
                for (Bitstream bit : bits) {
                    this.authorizeService.addPolicy(context, (DSpaceObject)bit, type, group);
                }
            }
        }
    }

    protected void removeUserItemPolicies(Context context, Item item, EPerson e) throws SQLException, AuthorizeException {
        if (e != null) {
            this.authorizeService.removeEPersonPolicies(context, item, e);
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                this.authorizeService.removeEPersonPolicies(context, bundle, e);
                List<Bitstream> bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    this.authorizeService.removeEPersonPolicies(context, bitstream, e);
                }
            }
            if (e.getID().equals(item.getSubmitter().getID())) {
                this.grantSubmitterReadPolicies(context, item);
            }
        }
    }

    protected void removeGroupItemPolicies(Context context, Item item, Group e) throws SQLException, AuthorizeException {
        if (e != null) {
            this.authorizeService.removeGroupPolicies(context, item, e);
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                this.authorizeService.removeGroupPolicies(context, bundle, e);
                List<Bitstream> bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    this.authorizeService.removeGroupPolicies(context, bitstream, e);
                }
            }
        }
    }

    @Override
    public WorkspaceItem sendWorkflowItemBackSubmission(Context context, XmlWorkflowItem wi, EPerson e, String provenance, String rejection_message) throws SQLException, AuthorizeException, IOException {
        String workflowID = null;
        String currentStepId = null;
        String currentActionConfigId = null;
        ClaimedTask claimedTask = this.claimedTaskService.findByWorkflowIdAndEPerson(context, wi, e);
        if (claimedTask != null) {
            workflowID = claimedTask.getWorkflowID();
            currentStepId = claimedTask.getStepID();
            currentActionConfigId = claimedTask.getActionID();
        }
        context.turnOffAuthorisationSystem();
        Item myitem = wi.getItem();
        String now = DCDate.getCurrent().toString();
        String usersName = this.getEPersonName(e);
        String provDescription = provenance + " Rejected by " + usersName + ", reason: " + rejection_message + " on " + now + " (GMT) ";
        this.itemService.addMetadata(context, myitem, "dc", "description", "provenance", "en", provDescription);
        this.itemService.clearMetadata(context, myitem, "workflow", "*", "*", "*");
        this.itemService.update(context, myitem);
        WorkspaceItem wsi = this.returnToWorkspace(context, wi);
        this.notifyOfReject(context, wi, e, rejection_message);
        this.log.info((Object)LogManager.getHeader(context, "reject_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        this.logWorkflowEvent(context, workflowID, currentStepId, currentActionConfigId, wi, e, null, null);
        context.restoreAuthSystemState();
        return wsi;
    }

    @Override
    public WorkspaceItem abort(Context c, XmlWorkflowItem wi, EPerson e) throws AuthorizeException, SQLException, IOException {
        if (!this.authorizeService.isAdmin(c)) {
            throw new AuthorizeException("You must be an admin to abort a workflow");
        }
        c.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.returnToWorkspace(c, wi);
        this.log.info((Object)LogManager.getHeader(c, "abort_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wsi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        c.restoreAuthSystemState();
        return wsi;
    }

    protected WorkspaceItem returnToWorkspace(Context c, XmlWorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        this.deleteAllTasks(c, wfi);
        c.turnOffAuthorisationSystem();
        this.workflowRequirementsService.clearInProgressUsers(c, wfi);
        this.workflowItemRoleService.deleteForWorkflowItem(c, wfi);
        Item myitem = wfi.getItem();
        this.grantUserAllItemPolicies(c, myitem, myitem.getSubmitter());
        WorkspaceItem workspaceItem = this.workspaceItemService.create(c, wfi);
        workspaceItem.setMultipleFiles(wfi.hasMultipleFiles());
        workspaceItem.setMultipleTitles(wfi.hasMultipleTitles());
        workspaceItem.setPublishedBefore(wfi.isPublishedBefore());
        this.workspaceItemService.update(c, workspaceItem);
        this.log.info((Object)LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + workspaceItem.getID()));
        this.xmlWorkflowItemService.deleteWrapper(c, wfi);
        return workspaceItem;
    }

    @Override
    public String getEPersonName(EPerson ePerson) {
        String submitter = ePerson.getFullName();
        submitter = submitter + "(" + ePerson.getEmail() + ")";
        return submitter;
    }

    protected void recordStart(Context context, Item myitem, Action action) throws SQLException, IOException, AuthorizeException {
        DCDate now = DCDate.getCurrent();
        String provmessage = "";
        provmessage = myitem.getSubmitter() != null ? "Submitted by " + myitem.getSubmitter().getFullName() + " (" + myitem.getSubmitter().getEmail() + ") on " + now.toString() + " workflow start=" + action.getProvenanceStartId() + "\n" : "Submitted by unknown (probably automated) on" + now.toString() + " workflow start=" + action.getProvenanceStartId() + "\n";
        provmessage = provmessage + this.installItemService.getBitstreamProvenanceMessage(context, myitem);
        this.itemService.addMetadata(context, myitem, "dc", "description", "provenance", "en", provmessage);
        this.itemService.update(context, myitem);
    }

    protected void notifyOfReject(Context c, XmlWorkflowItem wi, EPerson e, String reason) {
        try {
            String title = wi.getItem().getName();
            Collection coll = wi.getCollection();
            String rejector = this.getEPersonName(e);
            Locale supportedLocale = I18nUtil.getEPersonLocale(e);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_reject"));
            email.addRecipient(wi.getSubmitter().getEmail());
            email.addArgument(title);
            email.addArgument(coll.getName());
            email.addArgument(rejector);
            email.addArgument(reason);
            email.addArgument(ConfigurationManager.getProperty("dspace.url") + "/mydspace");
            email.send();
        }
        catch (Exception ex) {
            this.log.warn((Object)LogManager.getHeader(c, "notify_of_reject", "cannot email user eperson_id" + e.getID() + " eperson_email" + e.getEmail() + " workflow_item_id" + wi.getID()));
        }
    }

    @Override
    public String getMyDSpaceLink() {
        return ConfigurationManager.getProperty("dspace.url") + "/mydspace";
    }
}

