/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.LicenseService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(CollectionTest.class);
    private LicenseService licenseService = CoreServiceFactory.getInstance().getLicenseService();
    private Collection collection;
    private Community owningCommunity;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.dspaceObject = this.collection;
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            if (this.collection != null) {
                this.context.turnOffAuthorisationSystem();
                this.collectionService.update(this.context, (DSpaceObject)this.collection);
                this.communityService.update(this.context, (DSpaceObject)this.owningCommunity);
                this.collection = (Collection)this.collectionService.find(this.context, this.collection.getID());
                if (this.collection != null) {
                    this.collectionService.delete(this.context, (DSpaceObject)this.collection);
                    this.communityService.delete(this.context, this.communityService.find(this.context, this.owningCommunity.getID()));
                }
                this.context.restoreAuthSystemState();
            }
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in init", (Throwable)ex);
            Assert.fail((String)("IO Error in init: " + ex.getMessage()));
        }
        super.destroy();
    }

    @Test
    public void testCollectionFind() throws Exception {
        UUID id = this.collection.getID();
        Collection found = (Collection)this.collectionService.find(this.context, id);
        Assert.assertThat((String)"testCollectionFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCollectionFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testCollectionFind 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreate() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
            }
        };
        Collection created = this.collectionService.create(this.context, this.owningCommunity);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreateWithValidHandle() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
            }
        };
        Collection created = this.collectionService.create(this.context, this.owningCommunity, "987654321/100");
        Assert.assertThat((String)"testCreateWithValidHandle 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateWithValidHandle 1", (Object)created.getHandle(), (Matcher)CoreMatchers.equalTo((Object)"987654321/100"));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWithInvalidHandle() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
            }
        };
        String inUseHandle = this.collection.getHandle();
        Collection created = this.collectionService.create(this.context, this.owningCommunity, inUseHandle);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        List all = this.collectionService.findAll(this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (all.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Collection cl : all) {
            if (!cl.equals((Object)this.collection)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testGetItems() throws Exception {
        Iterator items = this.itemService.findByCollection(this.context, this.collection);
        Assert.assertThat((String)"testGetItems 0", (Object)items, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testGetItems 1", (boolean)items.hasNext());
    }

    @Test
    public void testGetAllItems() throws Exception {
        Iterator items = this.itemService.findByCollection(this.context, this.collection);
        Assert.assertThat((String)"testGetAllItems 0", (Object)items, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testGetAllItems 1", (boolean)items.hasNext());
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.collection.getID() != null ? 1 : 0) != 0);
    }

    @Test
    public void testLegacyID() {
        Assert.assertTrue((String)"testGetLegacyID 0", (this.collection.getLegacyId() == null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertTrue((String)"testGetHandle 0", (boolean)this.collection.getHandle().contains("123456789/"));
    }

    @Test
    public void testGetMetadata() {
        Assert.assertThat((String)"testGetMetadata 0", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "name"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 1", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "short_description"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 2", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "introductory_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 4", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "copyright_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 6", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "provenance_description"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 7", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 8", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "license"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testSetMetadata() throws SQLException {
        String name = "name";
        String sdesc = "short description";
        String itext = "introductory text";
        String copy = "copyright declaration";
        String sidebar = "side bar text";
        String tempItem = "3";
        String provDesc = "provenance description";
        String license = "license text";
        this.collectionService.setMetadata(this.context, this.collection, "name", name);
        this.collectionService.setMetadata(this.context, this.collection, "short_description", sdesc);
        this.collectionService.setMetadata(this.context, this.collection, "introductory_text", itext);
        this.collectionService.setMetadata(this.context, this.collection, "copyright_text", copy);
        this.collectionService.setMetadata(this.context, this.collection, "side_bar_text", sidebar);
        this.collectionService.setMetadata(this.context, this.collection, "provenance_description", provDesc);
        this.collectionService.setMetadata(this.context, this.collection, "license", license);
        Assert.assertThat((String)"testSetMetadata 0", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "name"), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((String)"testSetMetadata 1", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "short_description"), (Matcher)CoreMatchers.equalTo((Object)sdesc));
        Assert.assertThat((String)"testSetMetadata 2", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "introductory_text"), (Matcher)CoreMatchers.equalTo((Object)itext));
        Assert.assertThat((String)"testSetMetadata 4", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "copyright_text"), (Matcher)CoreMatchers.equalTo((Object)copy));
        Assert.assertThat((String)"testSetMetadata 5", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)sidebar));
        Assert.assertThat((String)"testGetMetadata 7", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "provenance_description"), (Matcher)CoreMatchers.equalTo((Object)provDesc));
        Assert.assertThat((String)"testGetMetadata 8", (Object)this.collectionService.getMetadata((DSpaceObject)this.collection, "license"), (Matcher)CoreMatchers.equalTo((Object)license));
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.collection.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testGetLogo() {
        Assert.assertThat((String)"testGetLogo 0", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.collectionService.setLogo(this.context, this.collection, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth 0", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.collection.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth 1", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.collectionService.setLogo(this.context, this.collection, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth2 0", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.collection.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth2 1", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.collectionService.setLogo(this.context, this.collection, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth3 0", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.collection.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth3 1", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth4() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.collectionService.setLogo(this.context, this.collection, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth4 0", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.collection.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth4 1", (Object)this.collection.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testSetLogoNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.collectionService.setLogo(this.context, this.collection, (InputStream)new FileInputStream(f));
        Assert.fail((String)"EXception expected");
    }

    @Test
    public void testCreateWorkflowGroupAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageWorkflowsGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        int step = 1;
        Group result = this.collectionService.createWorkflowGroup(this.context, this.collection, step);
        Assert.assertThat((String)"testCreateWorkflowGroupAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateWorkflowGroupNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageWorkflowsGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        int step = 1;
        Group result = this.collectionService.createWorkflowGroup(this.context, this.collection, step);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testSetWorkflowGroup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        int step = 1;
        Group g = this.groupService.create(this.context);
        this.context.restoreAuthSystemState();
        this.collection.setWorkflowGroup(step, g);
        Assert.assertThat((String)"testSetWorkflowGroup 0", (Object)this.collectionService.getWorkflowGroup(this.collection, step), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetWorkflowGroup 1", (Object)this.collectionService.getWorkflowGroup(this.collection, step), (Matcher)CoreMatchers.equalTo((Object)g));
    }

    @Test
    public void testGetWorkflowGroup() {
        int step = 1;
        Assert.assertThat((String)"testGetWorkflowGroup 0", (Object)this.collectionService.getWorkflowGroup(this.collection, step), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreateSubmittersAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        Group result = this.collectionService.createSubmitters(this.context, this.collection);
        Assert.assertThat((String)"testCreateSubmittersAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSubmittersNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        Group result = this.collectionService.createSubmitters(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveSubmittersAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        this.collectionService.removeSubmitters(this.context, this.collection);
        Assert.assertThat((String)"testRemoveSubmittersAuth 0", (Object)this.collection.getSubmitters(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveSubmittersNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.removeSubmitters(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetSubmitters() {
        Assert.assertThat((String)"testGetSubmitters 0", (Object)this.collection.getSubmitters(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreateAdministratorsAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        Group result = this.collectionService.createAdministrators(this.context, this.collection);
        Assert.assertThat((String)"testCreateAdministratorsAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        Group result = this.collectionService.createAdministrators(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveAdministratorsAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        Group result = this.collectionService.createAdministrators(this.context, this.collection);
        Assert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.collection.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.collection.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.collectionService.removeAdministrators(this.context, this.collection);
        Assert.assertThat((String)"testRemoveAdministratorsAuth 2", (Object)this.collection.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        Group result = this.collectionService.createAdministrators(this.context, this.collection);
        Assert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.collection.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.collection.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.collectionService.removeAdministrators(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetAdministrators() {
        Assert.assertThat((String)"testGetAdministrators 0", (Object)this.collection.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetLicense() {
        Assert.assertThat((String)"testGetLicense 0", (Object)this.collectionService.getLicense(this.collection), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetLicense 1", (Object)this.collectionService.getLicense(this.collection), (Matcher)CoreMatchers.equalTo((Object)this.licenseService.getDefaultSubmissionLicense()));
    }

    @Test
    public void testGetLicenseCollection() {
        Assert.assertThat((String)"testGetLicenseCollection 0", (Object)this.collection.getLicenseCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetLicenseCollection 1", (Object)this.collection.getLicenseCollection(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testHasCustomLicense() {
        Assert.assertFalse((String)"testHasCustomLicense 0", (boolean)this.collectionService.hasCustomLicense(this.collection));
    }

    @Test
    public void testSetLicense() throws SQLException {
        String license = "license for test";
        this.collection.setLicense(this.context, license);
        Assert.assertThat((String)"testSetLicense 0", (Object)this.collectionService.getLicense(this.collection), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetLicense 1", (Object)this.collectionService.getLicense(this.collection), (Matcher)CoreMatchers.equalTo((Object)license));
        Assert.assertThat((String)"testSetLicense 2", (Object)this.collection.getLicenseCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetLicense 3", (Object)this.collection.getLicenseCollection(), (Matcher)CoreMatchers.equalTo((Object)license));
    }

    @Test
    public void testGetTemplateItem() throws Exception {
        Assert.assertThat((String)"testGetTemplateItem 0", (Object)this.collection.getTemplateItem(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreateTemplateItemAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        this.itemService.createTemplateItem(this.context, this.collection);
        Assert.assertThat((String)"testCreateTemplateItemAuth 0", (Object)this.collection.getTemplateItem(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateTemplateItemNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        this.itemService.createTemplateItem(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveTemplateItemAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
            }
        };
        this.collectionService.removeTemplateItem(this.context, this.collection);
        Assert.assertThat((String)"testRemoveTemplateItemAuth 0", (Object)this.collection.getTemplateItem(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveTemplateItemNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.removeTemplateItem(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddItemAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.collectionService.addItem(this.context, this.collection, item);
        boolean added = false;
        Iterator ii = this.itemService.findByCollection(this.context, this.collection);
        while (ii.hasNext()) {
            if (!((Item)ii.next()).equals((Object)item)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testAddItemAuth 0", (boolean)added);
    }

    @Test(expected=AuthorizeException.class)
    public void testAddItemNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.collectionService.addItem(this.context, this.collection, item);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveItemAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 4);
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 2);
                this.result = null;
            }
        };
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.collectionService.addItem(this.context, this.collection, item);
        this.collectionService.removeItem(this.context, this.collection, item);
        boolean isthere = false;
        Iterator ii = this.itemService.findByCollection(this.context, this.collection);
        while (ii.hasNext()) {
            if (!((Item)ii.next()).equals((Object)item)) continue;
            isthere = true;
        }
        Assert.assertFalse((String)"testRemoveItemAuth 0", (boolean)isthere);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveItemNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 4);
                this.result = new AuthorizeException();
            }
        };
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.collectionService.addItem(this.context, this.collection, item);
        this.collectionService.removeItem(this.context, this.collection, item);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
    }

    @Test
    public void testUpdateAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
    }

    @Test
    public void testUpdateAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
    }

    @Test
    public void testUpdateAuth4() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.update(this.context, (DSpaceObject)this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection));
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection));
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection));
    }

    @Test
    public void testCanEditBooleanAuth4() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection));
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection));
    }

    @Test
    public void testCanEditBooleanAuth_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, true));
    }

    @Test
    public void testCanEditBooleanAuth2_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, true));
    }

    @Test
    public void testCanEditBooleanAuth3_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth3_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, true));
    }

    @Test
    public void testCanEditBooleanAuth4_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, true));
    }

    @Test
    public void testCanEditBooleanAuth5_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth5_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, false));
    }

    @Test
    public void testCanEditBooleanAuth6_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth6_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, false));
    }

    @Test
    public void testCanEditBooleanAuth7_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth7_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, false));
    }

    @Test
    public void testCanEditBooleanAuth8_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth8_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, false));
    }

    @Test
    public void testCanEditBooleanNoAuth_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, true));
    }

    @Test
    public void testCanEditBooleanNoAuth2_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth_boolean 0", (boolean)this.collectionService.canEditBoolean(this.context, this.collection, false));
    }

    @Test
    public void testCanEditAuth_0args() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection);
    }

    @Test
    public void testCanEditAuth2_0args() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection);
    }

    @Test
    public void testCanEditAuth3_0args() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection);
    }

    @Test
    public void testCanEditAuth4_0args() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection);
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth_0args() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.canEdit(this.context, this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCanEditAuth_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, true);
    }

    @Test
    public void testCanEditAuth2_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, true);
    }

    @Test
    public void testCanEditAuth3_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, true);
    }

    @Test
    public void testCanEditAuth4_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, true);
    }

    @Test
    public void testCanEditAuth5_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, false);
    }

    @Test
    public void testCanEditAuth6_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, false);
    }

    @Test
    public void testCanEditAuth7_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = true;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, false);
    }

    @Test
    public void testCanEditAuth8_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = null;
            }
        };
        this.collectionService.canEdit(this.context, this.collection, false);
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.canEdit(this.context, this.collection, false);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth2_boolean() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 1, false);
                this.result = false;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, false);
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.canEdit(this.context, this.collection, true);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class, this.authorizeService.getClass()}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, this.anyBoolean.booleanValue());
                this.result = null;
            }
        };
        UUID id = this.collection.getID();
        this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        this.collection = (Collection)this.collectionService.find(this.context, id);
        Assert.assertThat((String)"testDelete 0", (Object)this.collection, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class, this.authorizeService.getClass()}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = new AuthorizeException();
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, this.anyBoolean.booleanValue());
                this.result = null;
            }
        };
        this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth2() throws Exception {
        new NonStrictExpectations(new Object[]{AuthorizeUtil.class, this.authorizeService.getClass()}){
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)this.any), (Collection)((Collection)this.any));
                this.result = null;
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, this.anyBoolean.booleanValue());
                this.result = new AuthorizeException();
            }
        };
        this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetCommunities() throws Exception {
        Assert.assertThat((String)"testGetCommunities 0", (Object)this.collection.getCommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCommunities 1", (this.collection.getCommunities().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                CollectionTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = null;
            }
        };
        Assert.assertFalse((String)"testEquals 0", (boolean)this.collection.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)this.collection.equals((Object)this.collectionService.create(this.context, this.owningCommunity)));
        Assert.assertTrue((String)"testEquals 2", (boolean)this.collection.equals((Object)this.collection));
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.collection.getType(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testFindAuthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = this.communityService.create(null, this.context);
        this.context.restoreAuthSystemState();
        List found = this.collectionService.findAuthorized(this.context, com, 1);
        Assert.assertThat((String)"testFindAuthorized 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 1", (found.size() == 0 ? 1 : 0) != 0);
        found = this.collectionService.findAuthorized(this.context, null, 1);
        Assert.assertThat((String)"testFindAuthorized 2", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 3", (found.size() == 0 ? 1 : 0) != 0);
        found = this.collectionService.findAuthorized(this.context, com, 3);
        Assert.assertThat((String)"testFindAuthorized 3", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 4", (found.size() == 0 ? 1 : 0) != 0);
        found = this.collectionService.findAuthorized(this.context, null, 3);
        Assert.assertThat((String)"testFindAuthorized 5", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 6", (found.size() == 0 ? 1 : 0) != 0);
        found = this.collectionService.findAuthorized(this.context, com, 0);
        Assert.assertThat((String)"testFindAuthorized 7", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 8", (found.size() == 0 ? 1 : 0) != 0);
        found = this.collectionService.findAuthorized(this.context, null, 0);
        Assert.assertThat((String)"testFindAuthorized 9", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 10", (found.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testFindAuthorizedOptimized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = this.communityService.create(null, this.context);
        Collection collectionA = this.collectionService.create(this.context, com);
        Collection collectionB = this.collectionService.create(this.context, com);
        Collection collectionC = this.collectionService.create(this.context, com);
        com.addCollection(collectionA);
        com.addCollection(collectionB);
        com.addCollection(collectionC);
        EPerson epersonA = this.ePersonService.create(this.context);
        EPerson epersonB = this.ePersonService.create(this.context);
        EPerson epersonC = this.ePersonService.create(this.context);
        EPerson epersonD = this.ePersonService.create(this.context);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)collectionA, 3, epersonA);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)collectionC, 3, epersonA);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)collectionB, 3, epersonB);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)collectionC, 3, epersonB);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)collectionC, 3, epersonC);
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(epersonA);
        List personACollections = this.collectionService.findAuthorizedOptimized(this.context, 3);
        Assert.assertTrue((String)"testFindAuthorizeOptimized A", (personACollections.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testFindAuthorizeOptimized A.A", (boolean)personACollections.contains(collectionA));
        Assert.assertFalse((String)"testFindAuthorizeOptimized A.A", (boolean)personACollections.contains(collectionB));
        Assert.assertTrue((String)"testFindAuthorizeOptimized A.A", (boolean)personACollections.contains(collectionC));
        this.context.setCurrentUser(epersonB);
        List personBCollections = this.collectionService.findAuthorizedOptimized(this.context, 3);
        Assert.assertTrue((String)"testFindAuthorizeOptimized B", (personBCollections.size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((String)"testFindAuthorizeOptimized B.A", (boolean)personBCollections.contains(collectionA));
        Assert.assertTrue((String)"testFindAuthorizeOptimized B.B", (boolean)personBCollections.contains(collectionB));
        Assert.assertTrue((String)"testFindAuthorizeOptimized B.C", (boolean)personBCollections.contains(collectionC));
        this.context.setCurrentUser(epersonC);
        List personCCollections = this.collectionService.findAuthorizedOptimized(this.context, 3);
        Assert.assertTrue((String)"testFindAuthorizeOptimized C", (personCCollections.size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((String)"testFindAuthorizeOptimized collection.A", (boolean)personCCollections.contains(collectionA));
        Assert.assertFalse((String)"testFindAuthorizeOptimized collection.B", (boolean)personCCollections.contains(collectionB));
        Assert.assertTrue((String)"testFindAuthorizeOptimized collection.C", (boolean)personCCollections.contains(collectionC));
        this.context.setCurrentUser(epersonD);
        List personDCollections = this.collectionService.findAuthorizedOptimized(this.context, 3);
        Assert.assertTrue((String)"testFindAuthorizeOptimized D", (personDCollections.size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"testFindAuthorizeOptimized D.A", (boolean)personDCollections.contains(collectionA));
        Assert.assertFalse((String)"testFindAuthorizeOptimized D.B", (boolean)personDCollections.contains(collectionB));
        Assert.assertFalse((String)"testFindAuthorizeOptimized D.C", (boolean)personDCollections.contains(collectionC));
    }

    @Test
    public void testCountItems() throws Exception {
        Assert.assertTrue((String)"testCountItems 0", (this.itemService.countItems(this.context, this.collection) == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)((Collection)this.collectionService.getAdminObject(this.context, (DSpaceObject)this.collection, 4)), (Matcher)CoreMatchers.equalTo((Object)this.collection));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)((Collection)this.collectionService.getAdminObject(this.context, (DSpaceObject)this.collection, 3)), (Matcher)CoreMatchers.equalTo((Object)this.collection));
        Assert.assertThat((String)"testGetAdminObject 2", (Object)this.collectionService.getAdminObject(this.context, (DSpaceObject)this.collection, 2), (Matcher)CoreMatchers.instanceOf(Community.class));
        Assert.assertThat((String)"testGetAdminObject 3", (Object)this.collectionService.getAdminObject(this.context, (DSpaceObject)this.collection, 11), (Matcher)CoreMatchers.instanceOf(Collection.class));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        Assert.assertThat((String)"testGetParentObject 1", (Object)this.collectionService.getParentObject(this.context, (DSpaceObject)this.collection), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetParentObject 2", (Object)((Community)this.collectionService.getParentObject(this.context, (DSpaceObject)this.collection)), (Matcher)CoreMatchers.equalTo((Object)this.owningCommunity));
    }
}

