/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.Required;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITCommunityCollection
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(ITCommunityCollection.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    @PerfTest(invocations=25, threads=1)
    @Required(percentile95=1200, average=700, throughput=1)
    public void testCreateTree() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Community parent = this.communityService.create(null, this.context);
        Community child1 = this.communityService.create(parent, this.context);
        Collection col1 = this.collectionService.create(this.context, child1);
        Collection col2 = this.collectionService.create(this.context, child1);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testCreateTree 0", (Object)parent.getParentCommunities().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((String)"testCreateTree 1", child1.getParentCommunities().get(0), (Matcher)CoreMatchers.equalTo((Object)parent));
        Assert.assertThat((String)"testCreateTree 2", (Object)((Community)this.collectionService.getParentObject(this.context, (DSpaceObject)col1)), (Matcher)CoreMatchers.equalTo((Object)child1));
        Assert.assertThat((String)"testCreateTree 3", (Object)((Community)this.collectionService.getParentObject(this.context, (DSpaceObject)col2)), (Matcher)CoreMatchers.equalTo((Object)child1));
    }

    @Test
    @PerfTest(invocations=25, threads=1)
    @Required(percentile95=1200, average=700, throughput=1)
    public void testCreateItems() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Community parent = this.communityService.create(null, this.context);
        Community child1 = this.communityService.create(parent, this.context);
        Collection col1 = this.collectionService.create(this.context, child1);
        Collection col2 = this.collectionService.create(this.context, child1);
        Item item1 = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, col1, false));
        Item item2 = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, col2, false));
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testCreateItems 0", (Object)((Collection)this.itemService.getParentObject(this.context, (DSpaceObject)item1)), (Matcher)CoreMatchers.equalTo((Object)col1));
        Assert.assertThat((String)"testCreateItems 1", (Object)((Collection)this.itemService.getParentObject(this.context, (DSpaceObject)item2)), (Matcher)CoreMatchers.equalTo((Object)col2));
    }

    @Test
    @PerfTest(invocations=10, threads=1)
    @Required(percentile95=2000, average=1800)
    public void testCountItems() throws SQLException, AuthorizeException, IOException {
        int items_per_collection = 2;
        this.context.turnOffAuthorisationSystem();
        Community parentCom = this.communityService.create(null, this.context);
        Community childCom = this.communityService.create(parentCom, this.context);
        Collection col1 = this.collectionService.create(this.context, childCom);
        Collection col2 = this.collectionService.create(this.context, childCom);
        for (int count = 0; count < items_per_collection; ++count) {
            Item item1 = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, col1, false));
            Item item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, col2, false));
        }
        Item item3 = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, col1, false));
        this.collectionService.addItem(this.context, col2, item3);
        int totalitems = items_per_collection * 2 + 1;
        int collTotalItems = items_per_collection + 1;
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testCountItems 0", (Object)this.itemService.countItems(this.context, col1), (Matcher)CoreMatchers.equalTo((Object)collTotalItems));
        Assert.assertThat((String)"testCountItems 1", (Object)this.itemService.countItems(this.context, col2), (Matcher)CoreMatchers.equalTo((Object)collTotalItems));
        Assert.assertThat((String)"testCountItems 2", (Object)this.itemService.countItems(this.context, childCom), (Matcher)CoreMatchers.equalTo((Object)totalitems));
        Assert.assertThat((String)"testCountItems 3", (Object)this.itemService.countItems(this.context, parentCom), (Matcher)CoreMatchers.equalTo((Object)totalitems));
    }

    @Test
    public void testCommunityAdminDeletions() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        EPerson commAdmin = this.ePersonService.create(this.context);
        commAdmin.setEmail("comm-admin@dspace.org");
        this.ePersonService.update(this.context, (DSpaceObject)commAdmin);
        Community parentCom = this.communityService.create(null, this.context);
        Group adminGroup = this.communityService.createAdministrators(this.context, parentCom);
        this.groupService.addMember(this.context, adminGroup, commAdmin);
        this.groupService.update(this.context, (DSpaceObject)adminGroup);
        Community child = this.communityService.createSubcommunity(this.context, parentCom);
        Community child2 = this.communityService.createSubcommunity(this.context, parentCom);
        Community grandchild = this.communityService.createSubcommunity(this.context, child);
        Collection childCol = this.collectionService.create(this.context, child);
        Collection grandchildCol = this.collectionService.create(this.context, grandchild);
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, childCol, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        wsItem = this.workspaceItemService.create(this.context, childCol, false);
        Item item2 = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bitstream = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item);
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(commAdmin);
        UUID bitstreamId = bitstream.getID();
        this.bitstreamService.delete(this.context, (DSpaceObject)bitstream);
        Assert.assertTrue((String)"Community Admin unable to flag Bitstream as deleted", (boolean)bitstream.isDeleted());
        UUID itemId = item2.getID();
        this.itemService.delete(this.context, (DSpaceObject)item2);
        Assert.assertThat((String)"Community Admin unable to delete sub-Item", (Object)this.itemService.find(this.context, itemId), (Matcher)CoreMatchers.nullValue());
        UUID collId = grandchildCol.getID();
        this.collectionService.delete(this.context, (DSpaceObject)grandchildCol);
        Assert.assertThat((String)"Community Admin unable to delete sub-Collection", (Object)this.collectionService.find(this.context, collId), (Matcher)CoreMatchers.nullValue());
        UUID commId = child2.getID();
        this.communityService.delete(this.context, (DSpaceObject)child2);
        Assert.assertThat((String)"Community Admin unable to delete sub-Community", (Object)this.communityService.find(this.context, commId), (Matcher)CoreMatchers.nullValue());
        commId = child.getID();
        collId = childCol.getID();
        itemId = item.getID();
        this.communityService.delete(this.context, (DSpaceObject)child);
        Assert.assertThat((String)"Community Admin unable to delete sub-Community in hierarchy", (Object)this.communityService.find(this.context, commId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Community Admin unable to delete sub-Collection in hierarchy", (Object)this.collectionService.find(this.context, collId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Community Admin unable to delete sub-Item in hierarchy", (Object)this.itemService.find(this.context, itemId), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCollectionAdminDeletions() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        EPerson collAdmin = this.ePersonService.create(this.context);
        collAdmin.setEmail("coll-admin@dspace.org");
        this.ePersonService.update(this.context, (DSpaceObject)collAdmin);
        Community parentCom = this.communityService.create(null, this.context);
        Collection collection = this.collectionService.create(this.context, parentCom);
        Group adminGroup = this.collectionService.createAdministrators(this.context, collection);
        this.groupService.addMember(this.context, adminGroup, collAdmin);
        this.groupService.update(this.context, (DSpaceObject)adminGroup);
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, collection, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        Bundle bundle = this.bundleService.create(this.context, item, "Bundle1");
        Bundle bundle2 = this.bundleService.create(this.context, item, "Bundle2");
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bitstream = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item, "Bundle1");
        Bitstream bitstream2 = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item, "Bundle2");
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(collAdmin);
        UUID bitstreamId = bitstream2.getID();
        this.bitstreamService.delete(this.context, (DSpaceObject)bitstream2);
        Assert.assertTrue((String)"Collection Admin unable to flag Bitstream as deleted", (boolean)bitstream2.isDeleted());
        UUID bundleId = bundle2.getID();
        this.bundleService.delete(this.context, (DSpaceObject)bundle2);
        Assert.assertThat((String)"Collection Admin unable to delete Bundle", (Object)this.bundleService.find(this.context, bundleId), (Matcher)CoreMatchers.nullValue());
        UUID itemId = item.getID();
        bundleId = bundle.getID();
        bitstreamId = bitstream.getID();
        this.itemService.delete(this.context, (DSpaceObject)item);
        Assert.assertThat((String)"Collection Admin unable to delete sub-Item", (Object)this.itemService.find(this.context, itemId), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"Collection Admin unable to delete sub-Bundle", (Object)this.bundleService.find(this.context, bundleId), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((String)"Collection Admin unable to flag sub-Bitstream as deleted", (boolean)bitstream.isDeleted());
    }
}

