/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InstallItemTest
extends AbstractUnitTest {
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private Collection collection;
    private Community owningCommunity;
    private static final Logger log = Logger.getLogger(InstallItemTest.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.context.restoreAuthSystemState();
        }
        catch (SQLException | AuthorizeException ex) {
            log.error((Object)"SQL Error in init", ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
            this.context.restoreAuthSystemState();
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error((Object)"SQL Error in destroy", ex);
            Assert.fail((String)("SQL Error in destroy: " + ex.getMessage()));
            this.context.abort();
        }
        super.destroy();
    }

    @Test
    public void testInstallItem_Context_InProgressSubmission() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        Item result = this.installItemService.installItem(this.context, (InProgressSubmission)is);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testInstallItem_Context_InProgressSubmission 0", (Object)result, (Matcher)CoreMatchers.equalTo((Object)is.getItem()));
    }

    @Test
    public void testInstallItem_validHandle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "123456789/567";
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        Item result = this.installItemService.installItem(this.context, (InProgressSubmission)is, handle);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testInstallItem_validHandle", (Object)result, (Matcher)CoreMatchers.equalTo((Object)is.getItem()));
        Assert.assertThat((String)"testInstallItem_validHandle", (Object)result.getHandle(), (Matcher)CoreMatchers.equalTo((Object)handle));
    }

    @Test
    public void testInstallItem_invalidHandle() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                InstallItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Community)this.any), 3);
                this.result = false;
                InstallItemTest.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        String handle = "123456789/567";
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        WorkspaceItem is2 = this.workspaceItemService.create(this.context, this.collection, false);
        this.installItemService.installItem(this.context, (InProgressSubmission)is, handle);
        this.thrown.expect(RuntimeException.class);
        this.installItemService.installItem(this.context, (InProgressSubmission)is2, handle);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRestoreItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "123456789/567";
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        DCDate now = DCDate.getCurrent();
        String dayAndTime = now.toString();
        String date = dayAndTime.substring(0, dayAndTime.indexOf("T"));
        String provDescriptionBegins = "Made available in DSpace on " + date;
        Item result = this.installItemService.restoreItem(this.context, (InProgressSubmission)is, handle);
        this.context.restoreAuthSystemState();
        Assert.assertThat((String)"testRestoreItem 0", (Object)result, (Matcher)CoreMatchers.equalTo((Object)is.getItem()));
        List provMsgValues = this.itemService.getMetadata((DSpaceObject)result, "dc", "description", "provenance", "*");
        int i = 1;
        for (MetadataValue val : provMsgValues) {
            Assert.assertFalse((String)("testRestoreItem " + i), (boolean)val.getValue().startsWith(provDescriptionBegins));
            ++i;
        }
    }

    @Test
    public void testGetBitstreamProvenanceMessage() throws Exception {
        File f = new File(testProps.get("test.bitstream").toString());
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)is);
        Bitstream one = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item);
        one.setName(this.context, "one");
        Bitstream two = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item);
        two.setName(this.context, "two");
        this.context.restoreAuthSystemState();
        String testMessage = "No. of bitstreams: 2\n";
        testMessage = testMessage + "one: " + one.getSize() + " bytes, checksum: " + one.getChecksum() + " (" + one.getChecksumAlgorithm() + ")\n";
        testMessage = testMessage + "two: " + two.getSize() + " bytes, checksum: " + two.getChecksum() + " (" + two.getChecksumAlgorithm() + ")\n";
        Assert.assertThat((String)"testGetBitstreamProvenanceMessage 0", (Object)this.installItemService.getBitstreamProvenanceMessage(this.context, item), (Matcher)CoreMatchers.equalTo((Object)testMessage));
    }

    @Test
    public void testInstallItem_todayAsIssuedDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "123456789/567";
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        this.itemService.addMetadata(this.context, (DSpaceObject)is.getItem(), "dc", "date", "issued", "*", "today");
        this.itemService.addMetadata(this.context, (DSpaceObject)is.getItem(), "dc", "date", "issued", "*", "2011-01-01");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(calendar.getTime());
        Item result = this.installItemService.installItem(this.context, (InProgressSubmission)is, handle);
        this.context.restoreAuthSystemState();
        List issuedDates = this.itemService.getMetadata((DSpaceObject)result, "dc", "date", "issued", "*");
        Assert.assertThat((String)"testInstallItem_todayAsIssuedDate 0", (Object)((MetadataValue)issuedDates.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)date));
        Assert.assertThat((String)"testInstallItem_todayAsIssuedDate 1", (Object)((MetadataValue)issuedDates.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2011-01-01"));
    }

    @Test
    public void testInstallItem_nullIssuedDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "123456789/567";
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        Item result = this.installItemService.installItem(this.context, (InProgressSubmission)is, handle);
        this.context.restoreAuthSystemState();
        List issuedDates = this.itemService.getMetadata((DSpaceObject)result, "dc", "date", "issued", "*");
        Assert.assertThat((String)"testInstallItem_nullIssuedDate 0", (Object)issuedDates.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testRestoreItem_todayAsIssuedDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = "123456789/567";
        WorkspaceItem is = this.workspaceItemService.create(this.context, this.collection, false);
        this.itemService.addMetadata(this.context, (DSpaceObject)is.getItem(), "dc", "date", "issued", "*", "today");
        this.itemService.addMetadata(this.context, (DSpaceObject)is.getItem(), "dc", "date", "issued", "*", "2011-01-01");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(calendar.getTime());
        Item result = this.installItemService.restoreItem(this.context, (InProgressSubmission)is, handle);
        this.context.restoreAuthSystemState();
        List issuedDates = this.itemService.getMetadata((DSpaceObject)result, "dc", "date", "issued", "*");
        Assert.assertThat((String)"testRestoreItem_todayAsIssuedDate 0", (Object)((MetadataValue)issuedDates.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)date));
        Assert.assertThat((String)"testRestoreItem_todayAsIssuedDate 1", (Object)((MetadataValue)issuedDates.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2011-01-01"));
    }
}

