/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.LicenseService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LicenseUtilsTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(LicenseUtilsTest.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected LicenseService licenseService = CoreServiceFactory.getInstance().getLicenseService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private Community owningCommunity;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.context.restoreAuthSystemState();
        }
        catch (SQLException | AuthorizeException ex) {
            log.error((Object)"SQL Error in init", ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testGetLicenseText_5args() throws SQLException, AuthorizeException, IOException {
        Locale locale = null;
        Collection collection = null;
        Item item = null;
        EPerson person = null;
        HashMap<String, String> additionalInfo = null;
        String template = "Template license: %1$s %2$s %3$s %5$s %6$s";
        String templateLong = "Template license: %1$s %2$s %3$s %5$s %6$s %8$s %9$s %10$s %11$s";
        String templateResult = "Template license: first name last name testgetlicensetext_5args@email.com  ";
        String templateLongResult = "Template license: first name last name testgetlicensetext_5args@email.com   arg1 arg2 arg3 arg4";
        String defaultLicense = this.licenseService.getDefaultSubmissionLicense();
        this.context.turnOffAuthorisationSystem();
        person = this.ePersonService.create(this.context);
        person.setFirstName(this.context, "first name");
        person.setLastName(this.context, "last name");
        person.setEmail("testGetLicenseText_5args@email.com");
        locale = Locale.ENGLISH;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 0", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.GERMAN;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 1", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.ENGLISH;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        additionalInfo = new HashMap<String, String>();
        additionalInfo.put("arg1", "arg1");
        additionalInfo.put("arg2", "arg2");
        additionalInfo.put("arg3", "arg3");
        Assert.assertThat((String)"testGetLicenseText_5args 2", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.ENGLISH;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        collection.setLicense(this.context, template);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 3", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        locale = Locale.GERMAN;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        collection.setLicense(this.context, template);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        additionalInfo = null;
        Assert.assertThat((String)"testGetLicenseText_5args 4", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        locale = Locale.ENGLISH;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        collection.setLicense(this.context, templateLong);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        additionalInfo = new LinkedHashMap();
        additionalInfo.put("arg1", "arg1");
        additionalInfo.put("arg2", "arg2");
        additionalInfo.put("arg3", "arg3");
        additionalInfo.put("arg4", "arg4");
        Assert.assertThat((String)"testGetLicenseText_5args 5", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person, additionalInfo), (Matcher)CoreMatchers.equalTo((Object)templateLongResult));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetLicenseText_4args() throws SQLException, AuthorizeException, IOException {
        Locale locale = null;
        Collection collection = null;
        Item item = null;
        EPerson person = null;
        String template = "Template license: %1$s %2$s %3$s %5$s %6$s";
        String templateResult = "Template license: first name last name testgetlicensetext_4args@email.com  ";
        this.context.turnOffAuthorisationSystem();
        person = this.ePersonService.create(this.context);
        person.setFirstName(this.context, "first name");
        person.setLastName(this.context, "last name");
        person.setEmail("testGetLicenseText_4args@email.com");
        this.ePersonService.update(this.context, (DSpaceObject)person);
        String defaultLicense = this.licenseService.getDefaultSubmissionLicense();
        this.context.turnOffAuthorisationSystem();
        locale = Locale.ENGLISH;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        Assert.assertThat((String)"testGetLicenseText_5args 0", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.GERMAN;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        Assert.assertThat((String)"testGetLicenseText_5args 1", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        locale = Locale.ENGLISH;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        collection.setLicense(this.context, template);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        Assert.assertThat((String)"testGetLicenseText_5args 3", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        locale = Locale.GERMAN;
        collection = this.collectionService.create(this.context, this.owningCommunity);
        collection.setLicense(this.context, template);
        item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        Assert.assertThat((String)"testGetLicenseText_5args 4", (Object)LicenseUtils.getLicenseText((Locale)locale, (Collection)collection, (Item)item, (EPerson)person), (Matcher)CoreMatchers.equalTo((Object)templateResult));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGrantLicense() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = this.collectionService.create(this.context, this.owningCommunity);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, collection, false));
        String defaultLicense = this.licenseService.getDefaultSubmissionLicense();
        LicenseUtils.grantLicense((Context)this.context, (Item)item, (String)defaultLicense);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)this.bitstreamService.retrieve(this.context, (Bitstream)((Bundle)this.itemService.getBundles(item, "LICENSE").get(0)).getBitstreams().get(0)), (Writer)writer);
        String license = writer.toString();
        Assert.assertThat((String)"testGrantLicense 0", (Object)license, (Matcher)CoreMatchers.equalTo((Object)defaultLicense));
        this.context.restoreAuthSystemState();
    }
}

