/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkspaceItemTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(WorkspaceItemTest.class);
    private WorkspaceItem wi;
    private Community owningCommunity;
    private Collection collection;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.wi = this.workspaceItemService.create(this.context, this.collection, true);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.wi = null;
        try {
            this.context.turnOffAuthorisationSystem();
            this.communityService.removeCollection(this.context, this.owningCommunity, this.collection);
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in init", (Throwable)ex);
            Assert.fail((String)("IO Error in init: " + ex.getMessage()));
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.context.restoreAuthSystemState();
        super.destroy();
    }

    @Test
    public void testFind() throws Exception {
        int id = this.wi.getID();
        WorkspaceItem found = this.workspaceItemService.find(this.context, id);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testFind 2", (Object)found, (Matcher)CoreMatchers.equalTo((Object)this.wi));
        Assert.assertThat((String)"testFind 3", (Object)found.getCollection(), (Matcher)CoreMatchers.equalTo((Object)this.wi.getCollection()));
    }

    @Test
    public void testCreateAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                WorkspaceItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
            }
        };
        boolean template = false;
        WorkspaceItem created = null;
        template = false;
        created = this.workspaceItemService.create(this.context, this.collection, template);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreate 1", (created.getID() >= 0 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 2", (Object)created.getCollection(), (Matcher)CoreMatchers.equalTo((Object)this.collection));
        template = true;
        created = this.workspaceItemService.create(this.context, this.collection, template);
        Assert.assertThat((String)"testCreate 3", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreate 4", (created.getID() >= 0 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 5", (Object)created.getCollection(), (Matcher)CoreMatchers.equalTo((Object)this.collection));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                WorkspaceItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 3);
                this.result = new AuthorizeException();
            }
        };
        boolean template = false;
        WorkspaceItem created = null;
        template = false;
        created = this.workspaceItemService.create(this.context, this.collection, template);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindByEPerson() throws Exception {
        EPerson ep = this.context.getCurrentUser();
        List found = this.workspaceItemService.findByEPerson(this.context, ep);
        Assert.assertThat((String)"testFindByEPerson 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByEPerson 1", (found.size() >= 1 ? 1 : 0) != 0);
        boolean exists = false;
        for (WorkspaceItem w : found) {
            if (!w.equals((Object)this.wi)) continue;
            exists = true;
        }
        Assert.assertTrue((String)"testFindByEPerson 2", (boolean)exists);
    }

    @Test
    public void testFindByCollection() throws Exception {
        Collection c = this.wi.getCollection();
        List found = this.workspaceItemService.findByCollection(this.context, c);
        Assert.assertThat((String)"testFindByCollection 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByCollection 1", (found.size() >= 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testFindByCollection 2", (Object)((WorkspaceItem)found.get(0)).getID(), (Matcher)CoreMatchers.equalTo((Object)this.wi.getID()));
        Assert.assertThat((String)"testFindByCollection 3", found.get(0), (Matcher)CoreMatchers.equalTo((Object)this.wi));
        Assert.assertThat((String)"testFindByCollection 4", (Object)((WorkspaceItem)found.get(0)).getCollection(), (Matcher)CoreMatchers.equalTo((Object)this.wi.getCollection()));
    }

    @Test
    public void testFindAll() throws Exception {
        List found = this.workspaceItemService.findAll(this.context);
        Assert.assertTrue((String)"testFindAll 0", (found.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (WorkspaceItem f : found) {
            Assert.assertThat((String)"testFindAll 1", (Object)f, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testFindAll 2", (Object)f.getItem(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testFindAll 3", (Object)f.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
            if (!f.equals((Object)this.wi)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 4", (boolean)added);
    }

    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.wi.getID() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetStageReached() {
        Assert.assertTrue((String)"testGetStageReached 0", (this.wi.getStageReached() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSetStageReached() {
        this.wi.setStageReached(4);
        Assert.assertTrue((String)"testSetStageReached 0", (this.wi.getStageReached() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPageReached() {
        Assert.assertTrue((String)"testGetPageReached 0", (this.wi.getPageReached() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSetPageReached() {
        this.wi.setPageReached(4);
        Assert.assertTrue((String)"testSetPageReached 0", (this.wi.getPageReached() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateAuth() throws Exception {
        boolean pBefore = this.wi.isPublishedBefore();
        this.wi.setPublishedBefore(!pBefore);
        this.workspaceItemService.update(this.context, (InProgressSubmission)this.wi);
        this.context.commit();
        this.context.uncacheEntity((ReloadableEntity)this.wi);
        this.wi = this.workspaceItemService.find(this.context, this.wi.getID().intValue());
        this.collection = this.wi.getCollection();
        this.owningCommunity = (Community)this.collection.getCommunities().get(0);
        Assert.assertTrue((String)"testUpdate", (pBefore != this.wi.isPublishedBefore() ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                WorkspaceItemTest.this.authorizeService.authorizeActionBoolean((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = false;
                WorkspaceItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = new AuthorizeException();
            }
        };
        boolean pBefore = this.wi.isPublishedBefore();
        this.wi.setPublishedBefore(!pBefore);
        this.workspaceItemService.update(this.context, (InProgressSubmission)this.wi);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAllAuth() throws Exception {
        int id = this.wi.getID();
        this.workspaceItemService.deleteAll(this.context, this.wi);
        WorkspaceItem found = this.workspaceItemService.find(this.context, id);
        Assert.assertThat((String)"testDeleteAllAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteAllNoAuth() throws Exception {
        EPerson old = this.context.getCurrentUser();
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.ePersonService.create(this.context));
        this.context.restoreAuthSystemState();
        try {
            this.workspaceItemService.deleteAll(this.context, this.wi);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizeException ex) {
            this.context.setCurrentUser(old);
        }
    }

    @Test
    public void testDeleteWrapperAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                WorkspaceItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = null;
            }
        };
        UUID itemid = this.wi.getItem().getID();
        int id = this.wi.getID();
        this.workspaceItemService.deleteWrapper(this.context, (InProgressSubmission)this.wi);
        Item found = (Item)this.itemService.find(this.context, itemid);
        Assert.assertThat((String)"testDeleteWrapperAuth 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        WorkspaceItem wfound = this.workspaceItemService.find(this.context, id);
        Assert.assertThat((String)"testDeleteWrapperAuth 1", (Object)wfound, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteWrapperNoAuth() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                WorkspaceItemTest.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Item)this.any), 1);
                this.result = new AuthorizeException();
            }
        };
        this.workspaceItemService.deleteWrapper(this.context, (InProgressSubmission)this.wi);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetItem() {
        Assert.assertThat((String)"testGetItem 0", (Object)this.wi.getItem(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetCollection() {
        Assert.assertThat((String)"testGetCollection 0", (Object)this.wi.getCollection(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetSubmitter() throws Exception {
        Assert.assertThat((String)"testGetSubmitter 0", (Object)this.wi.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetSubmitter 1", (Object)this.wi.getSubmitter(), (Matcher)CoreMatchers.equalTo((Object)this.context.getCurrentUser()));
    }

    @Test
    public void testHasMultipleFiles() {
        Assert.assertFalse((String)"testHasMultipleFiles 0", (boolean)this.wi.hasMultipleFiles());
    }

    @Test
    public void testSetMultipleFiles() {
        this.wi.setMultipleFiles(true);
        Assert.assertTrue((String)"testSetMultipleFiles 0", (boolean)this.wi.hasMultipleFiles());
    }

    @Test
    public void testHasMultipleTitles() {
        Assert.assertFalse((String)"testHasMultipleTitles 0", (boolean)this.wi.hasMultipleTitles());
    }

    @Test
    public void testSetMultipleTitles() {
        this.wi.setMultipleTitles(true);
        Assert.assertTrue((String)"testSetMultipleTitles 0", (boolean)this.wi.hasMultipleTitles());
    }

    @Test
    public void testIsPublishedBefore() {
        Assert.assertFalse((String)"testIsPublishedBefore 0", (boolean)this.wi.isPublishedBefore());
    }

    @Test
    public void testSetPublishedBefore() {
        this.wi.setPublishedBefore(true);
        Assert.assertTrue((String)"testSetPublishedBefore 0", (boolean)this.wi.isPublishedBefore());
    }
}

