/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ITDSpaceAIP
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(ITDSpaceAIP.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
    protected ConfigurationService configService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private static final String valueseparator = "::";
    private static String topCommunityHandle = null;
    private static String testCollectionHandle = null;
    private static String testItemHandle = null;
    private static String testMappedItemHandle = null;
    private static String submitterEmail = "aip-test@dspace.org";
    private Context context;
    @ClassRule
    public static final TemporaryFolder uploadTempFolder = new TemporaryFolder();
    @Rule
    public final TemporaryFolder aipTempFolder = new TemporaryFolder();

    @BeforeClass
    public static void setUpClass() {
        try {
            Context context = new Context();
            context.turnOffAuthorisationSystem();
            CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
            CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
            ItemService itemService = ContentServiceFactory.getInstance().getItemService();
            BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
            WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
            InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
            log.info((Object)"setUpClass() - CREATE TEST HIERARCHY");
            Community topCommunity = communityService.create(null, context);
            communityService.addMetadata(context, (DSpaceObject)topCommunity, "dc", "title", null, null, "Top Community");
            communityService.update(context, (DSpaceObject)topCommunity);
            topCommunityHandle = topCommunity.getHandle();
            Community child = communityService.createSubcommunity(context, topCommunity);
            communityService.addMetadata(context, (DSpaceObject)child, "dc", "title", null, null, "Child Community");
            communityService.update(context, (DSpaceObject)child);
            Community grandchild = communityService.createSubcommunity(context, child);
            communityService.addMetadata(context, (DSpaceObject)grandchild, "dc", "title", null, null, "Grandchild Community");
            communityService.update(context, (DSpaceObject)grandchild);
            Collection grandchildCol = collectionService.create(context, child);
            collectionService.addMetadata(context, (DSpaceObject)grandchildCol, "dc", "title", null, null, "Grandchild Collection");
            collectionService.update(context, (DSpaceObject)grandchildCol);
            testCollectionHandle = grandchildCol.getHandle();
            Collection greatgrandchildCol = collectionService.create(context, grandchild);
            collectionService.addMetadata(context, (DSpaceObject)greatgrandchildCol, "dc", "title", null, null, "GreatGrandchild Collection");
            collectionService.update(context, (DSpaceObject)greatgrandchildCol);
            EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
            EPerson submitter = ePersonService.create(context);
            submitter.setEmail(submitterEmail);
            ePersonService.update(context, (DSpaceObject)submitter);
            context.setCurrentUser(submitter);
            WorkspaceItem wsItem = workspaceItemService.create(context, grandchildCol, false);
            Item item = installItemService.installItem(context, (InProgressSubmission)wsItem);
            itemService.addMetadata(context, (DSpaceObject)item, "dc", "title", null, null, "Grandchild Collection Item #1");
            File f = new File(testProps.get("test.bitstream").toString());
            Bitstream b = itemService.createSingleBitstream(context, (InputStream)new FileInputStream(f), item);
            b.setName(context, "Test Bitstream");
            bitstreamService.update(context, (DSpaceObject)b);
            itemService.update(context, (DSpaceObject)item);
            testItemHandle = item.getHandle();
            WorkspaceItem wsItem2 = workspaceItemService.create(context, grandchildCol, false);
            Item item2 = installItemService.installItem(context, (InProgressSubmission)wsItem2);
            itemService.addMetadata(context, (DSpaceObject)item2, "dc", "title", null, null, "Mapped Item");
            itemService.update(context, (DSpaceObject)item2);
            collectionService.addItem(context, greatgrandchildCol, item2);
            testMappedItemHandle = item2.getHandle();
            WorkspaceItem wsItem3 = workspaceItemService.create(context, greatgrandchildCol, false);
            Item item3 = installItemService.installItem(context, (InProgressSubmission)wsItem3);
            itemService.addMetadata(context, (DSpaceObject)item3, "dc", "title", null, null, "GreatGrandchild Collection Item #1");
            itemService.update(context, (DSpaceObject)item3);
            WorkspaceItem wsItem4 = workspaceItemService.create(context, greatgrandchildCol, false);
            Item item4 = installItemService.installItem(context, (InProgressSubmission)wsItem4);
            itemService.addMetadata(context, (DSpaceObject)item4, "dc", "title", null, null, "GreatGrandchild Collection Item #2");
            itemService.update(context, (DSpaceObject)item4);
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in setUpClass()", (Throwable)ex);
            Assert.fail((String)("Authorization Error in setUpClass(): " + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in setUpClass()", (Throwable)ex);
            Assert.fail((String)("IO Error in setUpClass(): " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in setUpClass()", (Throwable)ex);
            Assert.fail((String)("SQL Error in setUpClass(): " + ex.getMessage()));
        }
    }

    @AfterClass
    public static void tearDownClass() {
        try {
            EPersonService ePersonService;
            EPerson eperson;
            Context context = new Context();
            CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
            HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
            Community topCommunity = (Community)handleService.resolveToObject(context, topCommunityHandle);
            if (topCommunity != null) {
                log.info((Object)"tearDownClass() - DESTROY TEST HIERARCHY");
                context.turnOffAuthorisationSystem();
                communityService.delete(context, (DSpaceObject)topCommunity);
                context.restoreAuthSystemState();
                context.commit();
            }
            if ((eperson = (ePersonService = EPersonServiceFactory.getInstance().getEPersonService()).findByEmail(context, submitterEmail)) != null) {
                log.info((Object)"tearDownClass() - DESTROY TEST EPERSON");
                context.turnOffAuthorisationSystem();
                ePersonService.delete(context, (DSpaceObject)eperson);
                context.restoreAuthSystemState();
                context.commit();
            }
            if (context.isValid()) {
                context.abort();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error in tearDownClass()", (Throwable)ex);
        }
    }

    @Override
    @Before
    public void init() {
        super.init();
        new NonStrictExpectations(new Object[]{this.configService.getClass()}){
            {
                ITDSpaceAIP.this.configService.getProperty("upload.temp.dir");
                this.result = uploadTempFolder.getRoot().getAbsolutePath();
            }
        };
        try {
            this.context = new Context();
            this.context.setCurrentUser(EPersonServiceFactory.getInstance().getEPersonService().findByEmail(this.context, submitterEmail));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init()", (Throwable)ex);
            Assert.fail((String)("SQL Error in init(): " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.abort();
        super.destroy();
    }

    @Test
    public void testRestoreCommunityHierarchy() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreCommunityHierarchy() - BEGIN");
        Community topCommunity = (Community)this.handleService.resolveToObject(this.context, topCommunityHandle);
        DSpaceObject parent = this.communityService.getParentObject(this.context, (DSpaceObject)topCommunity);
        HashMap<String, String> infoMap = new HashMap<String, String>();
        this.saveObjectInfo((DSpaceObject)topCommunity, infoMap);
        log.info((Object)"testRestoreCommunityHierarchy() - CREATE AIPs");
        File aipFile = this.createAIP((DSpaceObject)topCommunity, null, true);
        log.info((Object)"testRestoreCommunityHierarchy() - DELETE Community Hierarchy");
        this.communityService.delete(this.context, (DSpaceObject)topCommunity);
        this.assertObjectsNotExist(infoMap);
        log.info((Object)"testRestoreCommunityHierarchy() - RESTORE Community Hierarchy");
        PackageParameters pkgParams = new PackageParameters();
        pkgParams.addProperty("skipIfParentMissing", "true");
        this.restoreFromAIP(parent, aipFile, pkgParams, true);
        this.assertObjectsExist(infoMap);
        Item mappedItem = (Item)this.handleService.resolveToObject(this.context, testMappedItemHandle);
        Assert.assertEquals((String)"testRestoreCommunityHierarchy() - Mapped Item's Collection mappings restored", (long)2L, (long)mappedItem.getCollections().size());
        log.info((Object)"testRestoreCommunityHierarchy() - END");
    }

    @Test
    public void testRestoreRestrictedCommunity() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreRestrictedCommunity() - BEGIN");
        Community parent = (Community)this.handleService.resolveToObject(this.context, topCommunityHandle);
        Community community = this.communityService.createSubcommunity(this.context, parent);
        this.communityService.addMetadata(this.context, (DSpaceObject)community, "dc", "title", null, null, "Restricted Community");
        this.communityService.update(this.context, (DSpaceObject)community);
        String communityHandle = community.getHandle();
        Group group = this.groupService.create(this.context);
        this.groupService.setName(group, "Special Users");
        this.groupService.update(this.context, (DSpaceObject)group);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Special Read Only");
        policy.setGroup(group);
        policy.setAction(0);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)community);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)community);
        log.info((Object)"testRestoreRestrictedCommunity() - CREATE Community AIP");
        File aipFile = this.createAIP((DSpaceObject)community, null, false);
        log.info((Object)"testRestoreRestrictedCommunity() - DELETE Community");
        this.communityService.removeSubcommunity(this.context, parent, community);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, communityHandle);
        Assert.assertThat((String)("testRestoreRestrictedCommunity() Community " + communityHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testRestoreRestrictedCommunity() - RESTORE Community");
        this.restoreFromAIP((DSpaceObject)parent, aipFile, null, false);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, communityHandle);
        Assert.assertThat((String)("testRestoreRestrictedCommunity() Community " + communityHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        List policiesRestored = this.authorizeService.getPolicies(this.context, objRestored);
        Assert.assertEquals((String)"testRestoreRestrictedCommunity() restored policy count equal", (long)policies.size(), (long)policiesRestored.size());
        ResourcePolicy restoredPolicy = (ResourcePolicy)policiesRestored.get(0);
        Assert.assertEquals((String)"testRestoreRestrictedCommunity() restored policy group successfully", (Object)policy.getGroup().getName(), (Object)restoredPolicy.getGroup().getName());
        Assert.assertEquals((String)"testRestoreRestrictedCommunity() restored policy action successfully", (long)policy.getAction(), (long)restoredPolicy.getAction());
        Assert.assertEquals((String)"testRestoreRestrictedCommunity() restored policy name successfully", (Object)policy.getRpName(), (Object)restoredPolicy.getRpName());
        log.info((Object)"testRestoreRestrictedCommunity() - END");
    }

    @Test
    public void testReplaceCommunityHierarchy() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testReplaceCommunityHierarchy() - BEGIN");
        Community topCommunity = (Community)this.handleService.resolveToObject(this.context, topCommunityHandle);
        int numberOfCollections = this.communityService.getAllCollections(this.context, topCommunity).size();
        log.info((Object)"testReplaceCommunityHierarchy() - CREATE AIPs");
        File aipFile = this.createAIP((DSpaceObject)topCommunity, null, true);
        String deletedCollectionHandle = testCollectionHandle;
        Collection collectionToDelete = (Collection)this.handleService.resolveToObject(this.context, deletedCollectionHandle);
        Community parent = (Community)this.collectionService.getParentObject(this.context, (DSpaceObject)collectionToDelete);
        int numberOfItems = this.itemService.countItems(this.context, collectionToDelete);
        String deletedItemHandle = testItemHandle;
        log.info((Object)"testReplaceCommunityHierarchy() - DELETE Collection");
        this.communityService.removeCollection(this.context, parent, collectionToDelete);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, deletedCollectionHandle);
        Assert.assertThat((String)("testReplaceCommunityHierarchy() collection " + deletedCollectionHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        DSpaceObject obj2 = this.handleService.resolveToObject(this.context, deletedItemHandle);
        Assert.assertThat((String)("testReplaceCommunityHierarchy() item " + deletedItemHandle + " doesn't exist"), (Object)obj2, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testReplaceCommunityHierarchy() - REPLACE Community Hierarchy");
        PackageParameters pkgParams = new PackageParameters();
        pkgParams.addProperty("skipIfParentMissing", "true");
        this.replaceFromAIP((DSpaceObject)topCommunity, aipFile, pkgParams, true);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, deletedCollectionHandle);
        Assert.assertThat((String)("testReplaceCommunityHierarchy() collection " + deletedCollectionHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        DSpaceObject obj2Restored = this.handleService.resolveToObject(this.context, deletedItemHandle);
        Assert.assertThat((String)("testReplaceCommunityHierarchy() item " + deletedItemHandle + " exists"), (Object)obj2Restored, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((String)"testReplaceCommunityHierarchy() collection count", (long)numberOfCollections, (long)this.communityService.getAllCollections(this.context, topCommunity).size());
        Assert.assertEquals((String)"testReplaceCommunityHierarchy() item count", (long)numberOfItems, (long)this.itemService.countItems(this.context, (Collection)objRestored));
        log.info((Object)"testReplaceCommunityHierarchy() - END");
    }

    @Test
    public void testReplaceCommunityOnly() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Community)this.any), 1, true);
                this.result = null;
            }
        };
        log.info((Object)"testReplaceCommunityOnly() - BEGIN");
        Community topCommunity = (Community)this.handleService.resolveToObject(this.context, topCommunityHandle);
        String oldName = topCommunity.getName();
        log.info((Object)"testReplaceCommunityOnly() - CREATE Community AIP");
        File aipFile = this.createAIP((DSpaceObject)topCommunity, null, false);
        String newName = "This is NOT my Community name!";
        this.communityService.clearMetadata(this.context, (DSpaceObject)topCommunity, "dc", "title", null, "*");
        this.communityService.addMetadata(this.context, (DSpaceObject)topCommunity, "dc", "title", null, null, newName);
        Assert.assertEquals((String)"testReplaceCommunityOnly() new name", (Object)topCommunity.getName(), (Object)newName);
        this.replaceFromAIP((DSpaceObject)topCommunity, aipFile, null, false);
        Assert.assertEquals((String)"testReplaceCommunityOnly() old name", (Object)topCommunity.getName(), (Object)oldName);
    }

    @Test
    public void testRestoreCollectionHierarchy() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreCollectionHierarchy() - BEGIN");
        Collection testCollection = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        Community parent = (Community)this.collectionService.getParentObject(this.context, (DSpaceObject)testCollection);
        HashMap<String, String> infoMap = new HashMap<String, String>();
        this.saveObjectInfo((DSpaceObject)testCollection, infoMap);
        log.info((Object)"testRestoreCollectionHierarchy() - CREATE AIPs");
        File aipFile = this.createAIP((DSpaceObject)testCollection, null, true);
        log.info((Object)"testRestoreCollectionHierarchy() - DELETE Collection Hierarchy");
        this.communityService.removeCollection(this.context, parent, testCollection);
        this.assertObjectsNotExist(infoMap);
        log.info((Object)"testRestoreCollectionHierarchy() - RESTORE Collection Hierarchy");
        this.restoreFromAIP((DSpaceObject)parent, aipFile, null, true);
        this.assertObjectsExist(infoMap);
        log.info((Object)"testRestoreCollectionHierarchy() - END");
    }

    @Test
    public void testRestoreRestrictedCollection() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreRestrictedCollection() - BEGIN");
        Community parent = (Community)this.handleService.resolveToObject(this.context, topCommunityHandle);
        Collection collection = this.collectionService.create(this.context, parent);
        this.collectionService.addMetadata(this.context, (DSpaceObject)collection, "dc", "title", null, null, "Restricted Collection");
        this.collectionService.update(this.context, (DSpaceObject)collection);
        String collectionHandle = collection.getHandle();
        Group group = this.groupService.create(this.context);
        this.groupService.setName(group, "Special Users");
        this.groupService.update(this.context, (DSpaceObject)group);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        policy.setRpName("Special Read Only");
        policy.setGroup(group);
        policy.setAction(0);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)collection);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)collection);
        log.info((Object)"testRestoreRestrictedCollection() - CREATE Collection AIP");
        File aipFile = this.createAIP((DSpaceObject)collection, null, false);
        log.info((Object)"testRestoreRestrictedCollection() - DELETE Collection");
        this.communityService.removeCollection(this.context, parent, collection);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, collectionHandle);
        Assert.assertThat((String)("testRestoreRestrictedCollection() Collection " + collectionHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testRestoreRestrictedCollection() - RESTORE Collection");
        this.restoreFromAIP((DSpaceObject)parent, aipFile, null, false);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, collectionHandle);
        Assert.assertThat((String)("testRestoreRestrictedCollection() Collection " + collectionHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        List policiesRestored = this.authorizeService.getPolicies(this.context, objRestored);
        Assert.assertEquals((String)"testRestoreRestrictedCollection() restored policy count equal", (long)policies.size(), (long)policiesRestored.size());
        ResourcePolicy restoredPolicy = (ResourcePolicy)policiesRestored.get(0);
        Assert.assertEquals((String)"testRestoreRestrictedCollection() restored policy group successfully", (Object)policy.getGroup().getName(), (Object)restoredPolicy.getGroup().getName());
        Assert.assertEquals((String)"testRestoreRestrictedCollection() restored policy action successfully", (long)policy.getAction(), (long)restoredPolicy.getAction());
        Assert.assertEquals((String)"testRestoreRestrictedCollection() restored policy name successfully", (Object)policy.getRpName(), (Object)restoredPolicy.getRpName());
        log.info((Object)"testRestoreRestrictedCollection() - END");
    }

    @Test
    public void testReplaceCollectionHierarchy() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testReplaceCollectionHierarchy() - BEGIN");
        Collection testCollection = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        int numberOfItems = this.itemService.countItems(this.context, testCollection);
        log.info((Object)"testReplaceCollectionHierarchy() - CREATE AIPs");
        File aipFile = this.createAIP((DSpaceObject)testCollection, null, true);
        String deletedItemHandle = testItemHandle;
        Item itemToDelete = (Item)this.handleService.resolveToObject(this.context, deletedItemHandle);
        Collection parent = (Collection)this.itemService.getParentObject(this.context, (DSpaceObject)itemToDelete);
        log.info((Object)"testReplaceCollectionHierarchy() - DELETE Item");
        this.collectionService.removeItem(this.context, parent, itemToDelete);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, deletedItemHandle);
        Assert.assertThat((String)("testReplaceCollectionHierarchy() item " + deletedItemHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        Assert.assertEquals((String)("testReplaceCollectionHierarchy() updated item count for collection " + testCollectionHandle), (long)(numberOfItems - 1), (long)this.itemService.countItems(this.context, testCollection));
        log.info((Object)"testReplaceCollectionHierarchy() - REPLACE Collection Hierarchy");
        this.replaceFromAIP((DSpaceObject)testCollection, aipFile, null, true);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, deletedItemHandle);
        Assert.assertThat((String)("testReplaceCollectionHierarchy() item " + deletedItemHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((String)("testReplaceCollectionHierarchy() restored item count for collection " + testCollectionHandle), (long)numberOfItems, (long)this.itemService.countItems(this.context, testCollection));
        log.info((Object)"testReplaceCollectionHierarchy() - END");
    }

    @Test
    public void testReplaceCollectionOnly() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.authorizeAction((Context)this.any, (DSpaceObject)((Collection)this.any), 1, true);
                this.result = null;
            }
        };
        log.info((Object)"testReplaceCollectionOnly() - BEGIN");
        Collection testCollection = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        String oldName = testCollection.getName();
        log.info((Object)"testReplaceCollectionOnly() - CREATE Collection AIP");
        File aipFile = this.createAIP((DSpaceObject)testCollection, null, false);
        String newName = "This is NOT my Collection name!";
        this.collectionService.clearMetadata(this.context, (DSpaceObject)testCollection, "dc", "title", null, "*");
        this.collectionService.addMetadata(this.context, (DSpaceObject)testCollection, "dc", "title", null, null, newName);
        Assert.assertEquals((String)"testReplaceCollectionOnly() new name", (Object)testCollection.getName(), (Object)newName);
        this.replaceFromAIP((DSpaceObject)testCollection, aipFile, null, false);
        Assert.assertEquals((String)"testReplaceCollectionOnly() old name", (Object)testCollection.getName(), (Object)oldName);
    }

    @Test
    public void testRestoreItem() throws Exception {
        List bitstreams;
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreItem() - BEGIN");
        Item testItem = (Item)this.handleService.resolveToObject(this.context, testItemHandle);
        int bitstreamCount = 0;
        String bitstreamName = null;
        String bitstreamCheckSum = null;
        List bundles = this.itemService.getBundles(testItem, "ORIGINAL");
        if (bundles.size() > 0 && (bitstreamCount = (bitstreams = ((Bundle)bundles.get(0)).getBitstreams()).size()) > 0) {
            bitstreamName = ((Bitstream)bitstreams.get(0)).getName();
            bitstreamCheckSum = ((Bitstream)bitstreams.get(0)).getChecksum();
        }
        if (bitstreamCount <= 0) {
            Assert.fail((String)"No test bitstream found for Item in testRestoreItem()!");
        }
        log.info((Object)"testRestoreItem() - CREATE Item AIP");
        File aipFile = this.createAIP((DSpaceObject)testItem, null, false);
        Collection parent = (Collection)this.itemService.getParentObject(this.context, (DSpaceObject)testItem);
        log.info((Object)"testRestoreItem() - DELETE Item");
        this.collectionService.removeItem(this.context, parent, testItem);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, testItemHandle);
        Assert.assertThat((String)("testRestoreItem() item " + testItemHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testRestoreItem() - RESTORE Item");
        this.restoreFromAIP((DSpaceObject)parent, aipFile, null, false);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, testItemHandle);
        Assert.assertThat((String)("testRestoreItem() item " + testItemHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        List restoredBund = this.itemService.getBundles((Item)objRestored, "ORIGINAL");
        Bitstream restoredBitstream = this.bundleService.getBitstreamByName((Bundle)restoredBund.get(0), bitstreamName);
        Assert.assertThat((String)"testRestoreItem() bitstream exists", (Object)restoredBitstream, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((String)"testRestoreItem() bitstream checksum", (Object)restoredBitstream.getChecksum(), (Object)bitstreamCheckSum);
        log.info((Object)"testRestoreItem() - END");
    }

    @Test
    public void testRestoreRestrictedItem() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreRestrictedItem() - BEGIN");
        Collection parent = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, parent, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "title", null, null, "Test Restricted Item");
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream b = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item);
        b.setName(this.context, "Test Bitstream");
        this.bitstreamService.update(this.context, (DSpaceObject)b);
        this.itemService.update(this.context, (DSpaceObject)item);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        ResourcePolicy admin_policy = (ResourcePolicy)this.resourcePolicyService.create(this.context);
        admin_policy.setRpName("Admin Read-Only");
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        admin_policy.setGroup(adminGroup);
        admin_policy.setAction(0);
        policies.add(admin_policy);
        this.itemService.replaceAllItemPolicies(this.context, item, policies);
        log.info((Object)"testRestoreRestrictedItem() - CREATE Item AIP");
        File aipFile = this.createAIP((DSpaceObject)item, null, false);
        String itemHandle = item.getHandle();
        log.info((Object)"testRestoreRestrictedItem() - DELETE Item");
        this.collectionService.removeItem(this.context, parent, item);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, itemHandle);
        Assert.assertThat((String)("testRestoreRestrictedItem() item " + itemHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testRestoreRestrictedItem() - RESTORE Item");
        this.restoreFromAIP((DSpaceObject)parent, aipFile, null, false);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, itemHandle);
        Assert.assertThat((String)("testRestoreRestrictedItem() item " + itemHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        List policiesRestored = this.authorizeService.getPolicies(this.context, objRestored);
        Assert.assertEquals((String)"testRestoreRestrictedItem() restored policy count equal", (long)policies.size(), (long)policiesRestored.size());
        ResourcePolicy restoredPolicy = (ResourcePolicy)policiesRestored.get(0);
        Assert.assertEquals((String)"testRestoreRestrictedItem() restored policy group successfully", (Object)admin_policy.getGroup().getName(), (Object)restoredPolicy.getGroup().getName());
        Assert.assertEquals((String)"testRestoreRestrictedItem() restored policy action successfully", (long)admin_policy.getAction(), (long)restoredPolicy.getAction());
        Assert.assertEquals((String)"testRestoreRestrictedItem() restored policy name successfully", (Object)admin_policy.getRpName(), (Object)restoredPolicy.getRpName());
        log.info((Object)"testRestoreRestrictedItem() - END");
    }

    @Test
    public void testRestoreItemNoPolicies() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testRestoreItemNoPolicies() - BEGIN");
        Collection parent = (Collection)this.handleService.resolveToObject(this.context, testCollectionHandle);
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, parent, false);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wsItem);
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "title", null, null, "Test No Policies Item");
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream b = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item);
        b.setName(this.context, "Test Bitstream");
        this.bitstreamService.update(this.context, (DSpaceObject)b);
        this.itemService.update(this.context, (DSpaceObject)item);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)item);
        log.info((Object)"testRestoreItemNoPolicies() - CREATE Item AIP");
        File aipFile = this.createAIP((DSpaceObject)item, null, false);
        String itemHandle = item.getHandle();
        log.info((Object)"testRestoreItemNoPolicies() - DELETE Item");
        this.collectionService.removeItem(this.context, parent, item);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, itemHandle);
        Assert.assertThat((String)("testRestoreItemNoPolicies() item " + itemHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testRestoreItemNoPolicies() - RESTORE Item");
        this.restoreFromAIP((DSpaceObject)parent, aipFile, null, false);
        DSpaceObject objRestored = this.handleService.resolveToObject(this.context, itemHandle);
        Assert.assertThat((String)("testRestoreItemNoPolicies() item " + itemHandle + " exists"), (Object)objRestored, (Matcher)CoreMatchers.notNullValue());
        List policiesRestored = this.authorizeService.getPolicies(this.context, objRestored);
        Assert.assertEquals((String)"testRestoreItemNoPolicies() restored policy count is zero", (long)0L, (long)policiesRestored.size());
        log.info((Object)"testRestoreItemNoPolicies() - END");
    }

    @Test
    public void testReplaceItem() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
            }
        };
        log.info((Object)"testReplaceItem() - BEGIN");
        Item testItem = (Item)this.handleService.resolveToObject(this.context, testItemHandle);
        String oldName = testItem.getName();
        log.info((Object)"testReplaceItem() - CREATE Item AIP");
        File aipFile = this.createAIP((DSpaceObject)testItem, null, false);
        String newName = "This is NOT my Item name!";
        this.itemService.clearMetadata(this.context, (DSpaceObject)testItem, "dc", "title", null, "*");
        this.itemService.addMetadata(this.context, (DSpaceObject)testItem, "dc", "title", null, null, newName);
        Assert.assertEquals((String)"testReplaceItem() new name", (Object)testItem.getName(), (Object)newName);
        this.replaceFromAIP((DSpaceObject)testItem, aipFile, null, false);
        Assert.assertEquals((String)"testReplaceItem() old name", (Object)testItem.getName(), (Object)oldName);
    }

    @Test
    public void testRestoreMappedItem() throws Exception {
        new NonStrictExpectations(new Object[]{this.authorizeService.getClass()}){
            {
                ITDSpaceAIP.this.authorizeService.isAdmin((Context)this.any);
                this.result = true;
                ITDSpaceAIP.this.authorizeService.authorizeAction(ITDSpaceAIP.this.context, (DSpaceObject)((Collection)this.any), 4);
                this.result = null;
                ITDSpaceAIP.this.authorizeService.authorizeAction(ITDSpaceAIP.this.context, (DSpaceObject)((Collection)this.any), 3);
                this.result = null;
            }
        };
        log.info((Object)"testRestoreMappedItem() - BEGIN");
        Item item = (Item)this.handleService.resolveToObject(this.context, testMappedItemHandle);
        Collection owner = item.getOwningCollection();
        List mappedCollections = item.getCollections();
        Assert.assertEquals((String)("testRestoreMappedItem() item " + testMappedItemHandle + " is mapped to multiple collections"), (long)2L, (long)mappedCollections.size());
        log.info((Object)"testRestoreMappedItem() - CREATE Mapped Item AIP");
        File aipFile = this.createAIP((DSpaceObject)item, null, false);
        log.info((Object)"testRestoreMappedItem() - DELETE Item");
        this.itemService.delete(this.context, (DSpaceObject)item);
        DSpaceObject obj = this.handleService.resolveToObject(this.context, testMappedItemHandle);
        Assert.assertThat((String)("testRestoreMappedItem() item " + testMappedItemHandle + " doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        log.info((Object)"testRestoreMappedItem() - RESTORE Item");
        this.restoreFromAIP((DSpaceObject)owner, aipFile, null, false);
        Item itemRestored = (Item)this.handleService.resolveToObject(this.context, testMappedItemHandle);
        Assert.assertThat((String)("testRestoreMappedItem() item " + testMappedItemHandle + " exists"), (Object)itemRestored, (Matcher)CoreMatchers.notNullValue());
        List restoredMappings = itemRestored.getCollections();
        Assert.assertEquals((String)"testRestoreMappedItem() collection count", (long)2L, (long)restoredMappings.size());
        log.info((Object)"testRestoreMappedItem() - END");
    }

    private File createAIP(DSpaceObject dso, PackageParameters pkgParams, boolean recursive) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        PackageDisseminator dip = (PackageDisseminator)this.pluginService.getNamedPlugin(PackageDisseminator.class, "AIP");
        if (dip == null) {
            Assert.fail((String)"Could not find a disseminator for type 'AIP'");
            return null;
        }
        File exportAIPFile = new File(this.aipTempFolder.getRoot().getAbsolutePath() + File.separator + PackageUtils.getPackageName((DSpaceObject)dso, (String)"zip"));
        if (pkgParams == null) {
            pkgParams = new PackageParameters();
        }
        if (recursive) {
            dip.disseminateAll(this.context, dso, pkgParams, exportAIPFile);
        } else {
            dip.disseminate(this.context, dso, pkgParams, exportAIPFile);
        }
        return exportAIPFile;
    }

    private void restoreFromAIP(DSpaceObject parent, File aipFile, PackageParameters pkgParams, boolean recursive) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException, WorkflowException {
        PackageIngester sip = (PackageIngester)this.pluginService.getNamedPlugin(PackageIngester.class, "AIP");
        if (sip == null) {
            Assert.fail((String)"Could not find a ingestor for type 'AIP'");
        } else {
            if (!aipFile.exists()) {
                Assert.fail((String)("AIP Package File does NOT exist: " + aipFile.getAbsolutePath()));
            }
            if (pkgParams == null) {
                pkgParams = new PackageParameters();
            }
            pkgParams.setRestoreModeEnabled(true);
            if (recursive) {
                sip.ingestAll(this.context, parent, aipFile, pkgParams, null);
            } else {
                sip.ingest(this.context, parent, aipFile, pkgParams, null);
            }
        }
    }

    private void replaceFromAIP(DSpaceObject dso, File aipFile, PackageParameters pkgParams, boolean recursive) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException, WorkflowException {
        PackageIngester sip = (PackageIngester)this.pluginService.getNamedPlugin(PackageIngester.class, "AIP");
        if (sip == null) {
            Assert.fail((String)"Could not find a ingestor for type 'AIP'");
        } else {
            if (!aipFile.exists()) {
                Assert.fail((String)("AIP Package File does NOT exist: " + aipFile.getAbsolutePath()));
            }
            if (pkgParams == null) {
                pkgParams = new PackageParameters();
            }
            pkgParams.setRestoreModeEnabled(true);
            if (recursive) {
                sip.replaceAll(this.context, dso, aipFile, pkgParams);
            } else {
                sip.replace(this.context, dso, aipFile, pkgParams);
            }
        }
    }

    private void saveObjectInfo(DSpaceObject dso, HashMap<String, String> infoMap) throws SQLException {
        if (infoMap == null) {
            return;
        }
        if (dso instanceof Community) {
            Community community = (Community)dso;
            infoMap.put(community.getHandle(), this.communityService.getTypeText((DSpaceObject)community) + valueseparator + community.getName());
            List subCommunities = community.getSubcommunities();
            for (Community c : subCommunities) {
                this.saveObjectInfo((DSpaceObject)c, infoMap);
            }
            List collections = community.getCollections();
            for (Collection c : collections) {
                this.saveObjectInfo((DSpaceObject)c, infoMap);
            }
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            infoMap.put(collection.getHandle(), this.collectionService.getTypeText((DSpaceObject)collection) + valueseparator + collection.getName());
            Iterator items = this.itemService.findByCollection(this.context, collection);
            while (items.hasNext()) {
                Item i = (Item)items.next();
                this.saveObjectInfo((DSpaceObject)i, infoMap);
            }
        } else if (dso instanceof Item) {
            Item item = (Item)dso;
            infoMap.put(item.getHandle(), this.itemService.getTypeText((DSpaceObject)item) + valueseparator + item.getName());
        }
    }

    private void assertObjectsExist(HashMap<String, String> infoMap) throws SQLException {
        if (infoMap == null || infoMap.isEmpty()) {
            Assert.fail((String)"Cannot assert against an empty infoMap");
        }
        for (String key : infoMap.keySet()) {
            DSpaceObject obj = this.handleService.resolveToObject(this.context, key);
            Assert.assertThat((String)("assertObjectsExist object " + key + " (info=" + infoMap.get(key) + ") exists"), (Object)obj, (Matcher)CoreMatchers.notNullValue());
            String info = infoMap.get(key);
            String[] values = info.split(valueseparator);
            String typeText = values[0];
            String name = values[1];
            Assert.assertEquals((String)("assertObjectsExist object " + key + " type"), (Object)ContentServiceFactory.getInstance().getDSpaceObjectService(obj).getTypeText(obj), (Object)typeText);
            Assert.assertEquals((String)("assertObjectsExist object " + key + " name"), (Object)obj.getName(), (Object)name);
        }
    }

    public void assertObjectsNotExist(HashMap<String, String> infoMap) throws SQLException {
        if (infoMap == null || infoMap.isEmpty()) {
            Assert.fail((String)"Cannot assert against an empty infoMap");
        }
        for (String key : infoMap.keySet()) {
            DSpaceObject obj = this.handleService.resolveToObject(this.context, key);
            Assert.assertThat((String)("assertObjectsNotExist object " + key + " (info=" + infoMap.get(key) + ") doesn't exist"), (Object)obj, (Matcher)CoreMatchers.nullValue());
        }
    }
}

