/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import com.sun.org.apache.bcel.internal.generic.ClassGen;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.dspace.core.PathsClassLoader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PathsClassLoaderTest {
    private static final String FILENAME_PREFIX = "foo";
    private static final String CLASS_FILENAME_SUFFIX = ".class";
    private static final String JAR_FILENAME_SUFFIX = ".jar";
    private static final ClassLoader parentCL = PathsClassLoaderTest.class.getClassLoader();
    private static File classFile;
    private static File jarFile;
    private static String className;
    private static String jarClassName;

    @BeforeClass
    public static void setUpClass() {
        try {
            classFile = File.createTempFile(FILENAME_PREFIX, CLASS_FILENAME_SUFFIX);
            classFile.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String classFileName = classFile.getName();
        className = classFileName.substring(0, classFileName.length() - CLASS_FILENAME_SUFFIX.length());
        ClassGen cg = new ClassGen(className, "java.lang.Object", "<generated>", 1, null);
        cg.addEmptyConstructor(1);
        try {
            cg.getJavaClass().dump(classFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            jarFile = File.createTempFile(FILENAME_PREFIX, JAR_FILENAME_SUFFIX);
            jarFile.deleteOnExit();
            String jarFileName = jarFile.getName();
            jarClassName = jarFileName.substring(0, jarFileName.length() - JAR_FILENAME_SUFFIX.length());
            cg = new ClassGen(jarClassName, "java.lang.Object", "<generated>", 1, null);
            cg.addEmptyConstructor(1);
            JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));
            JarEntry entry = new JarEntry(jarClassName + CLASS_FILENAME_SUFFIX);
            jar.putNextEntry(entry);
            jar.write(cg.getJavaClass().getBytes());
            jar.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testFindClass() throws Exception {
        System.out.println("findClass");
        String[] classpath = new String[]{classFile.getParent(), jarFile.getCanonicalPath()};
        PathsClassLoader instance = new PathsClassLoader(parentCL, classpath);
        Class result = instance.findClass(className);
        Assert.assertTrue((String)"Should return a Class from file", (boolean)(result instanceof Class));
        classpath[0] = jarFile.getCanonicalPath();
        instance = new PathsClassLoader(parentCL, classpath);
        result = instance.findClass(jarClassName);
        Assert.assertTrue((String)"Should return a Class from JAR", (boolean)(result instanceof Class));
    }
}

