/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.dspace.AbstractDSpaceTest;
import org.dspace.identifier.HandleIdentifierProvider;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class HandleIdentifierProviderTest
extends AbstractDSpaceTest {
    private static final String BEAN_NAME = "test-HandleIdentifierProvider";
    private static AnnotationConfigApplicationContext applicationContext;

    @BeforeClass
    public static void setUpClass() {
        ServiceManager serviceManager = kernelImpl.getServiceManager();
        ApplicationContext parentApplicationContext = (ApplicationContext)serviceManager.getServiceByName(ApplicationContext.class.getName(), ApplicationContext.class);
        applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.setParent(parentApplicationContext);
        applicationContext.setId("TestingContext");
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(HandleIdentifierProvider.class);
        bd.setAutowireMode(2);
        bd.setScope("prototype");
        applicationContext.registerBeanDefinition(BEAN_NAME, (BeanDefinition)bd);
        applicationContext.refresh();
    }

    @AfterClass
    public static void tearDownClass() {
        applicationContext.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSupports_String() {
        System.out.println("supports(String)");
        DSpaceServicesFactory.getInstance().getConfigurationService().setProperty("handle.prefix", (Object)"123456789");
        DSpaceServicesFactory.getInstance().getConfigurationService().setProperty("handle.additional.prefixes", (Object)"123456789.1,123456789.2");
        HandleIdentifierProvider instance = new HandleIdentifierProvider();
        applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)instance, 2, true);
        Properties forms = new Properties();
        try {
            forms.load(this.getClass().getResourceAsStream("handle-forms.properties"));
        }
        catch (IOException e) {
            System.err.format("Could not load handle-forms.properties:  %s%n", e.getMessage());
            return;
        }
        for (Map.Entry<Object, Object> entry : forms.entrySet()) {
            String identifier = (String)entry.getKey();
            boolean expResult = Boolean.parseBoolean((String)entry.getValue());
            boolean result = instance.supports(identifier);
            String message = expResult ? "This provider should support " + identifier : "This provider should not support " + identifier;
            Assert.assertEquals((String)message, (Object)expResult, (Object)result);
        }
    }
}

