/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mockit.Mock;
import mockit.MockUp;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.identifier.doi.DOIIdentifierException;

public class MockDOIConnector
extends MockUp<DOIConnector>
implements DOIConnector {
    public Map<String, UUID> reserved = new HashMap<String, UUID>();
    public Map<String, UUID> registered = new HashMap<String, UUID>();

    public void reset() {
        this.reserved.clear();
        this.registered.clear();
    }

    @Mock
    public boolean isDOIReserved(Context context, String doi) throws DOIIdentifierException {
        return this.reserved.containsKey(doi);
    }

    @Mock
    public boolean isDOIRegistered(Context context, String doi) throws DOIIdentifierException {
        return this.registered.containsKey(doi);
    }

    @Mock
    public void deleteDOI(Context context, String doi) throws DOIIdentifierException {
        if (this.reserved.remove(doi) == null) {
            throw new DOIIdentifierException("Trying to delete a DOI that was never reserved!", 1);
        }
        this.registered.remove(doi);
    }

    @Mock
    public void reserveDOI(Context context, DSpaceObject dso, String doi) throws DOIIdentifierException {
        UUID itemId = this.reserved.get(doi);
        if (null != itemId) {
            if (dso.getID().equals(itemId)) {
                return;
            }
            throw new DOIIdentifierException("Trying to reserve a DOI that is reserved for another object.", 10);
        }
        this.reserved.put(doi, dso.getID());
    }

    @Mock
    public void registerDOI(Context context, DSpaceObject dso, String doi) throws DOIIdentifierException {
        if (!this.reserved.containsKey(doi)) {
            throw new DOIIdentifierException("Trying to register an unreserverd DOI.", 6);
        }
        if (!this.reserved.get(doi).equals(dso.getID())) {
            throw new DOIIdentifierException("Trying to register a DOI that is reserved for another item.", 10);
        }
        if (this.registered.containsKey(doi)) {
            if (this.registered.get(doi).equals(dso.getID())) {
                return;
            }
            throw new DOIIdentifierException("Trying to register a DOI that is registered for another item.", 10);
        }
        this.registered.put(doi, dso.getID());
    }

    @Mock
    public void updateMetadata(Context context, DSpaceObject dso, String doi) throws DOIIdentifierException {
        if (!this.reserved.containsKey(doi)) {
            throw new DOIIdentifierException("Trying to update a DOI that is not registered!", 1);
        }
        if (!this.reserved.get(doi).equals(dso.getID())) {
            throw new DOIIdentifierException("Trying to update metadata of an unreserved DOI.", 1);
        }
    }
}

