/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestItemHelpdeskStrategy
extends RequestItemSubmitterStrategy {
    private Logger log = Logger.getLogger(RequestItemHelpdeskStrategy.class);
    @Autowired(required=true)
    protected EPersonService ePersonService;

    @Override
    public RequestItemAuthor getRequestItemAuthor(Context context, Item item) throws SQLException {
        boolean helpdeskOverridesSubmitter = ConfigurationManager.getBooleanProperty("request.item.helpdesk.override", false);
        String helpDeskEmail = ConfigurationManager.getProperty("mail.helpdesk");
        if (helpdeskOverridesSubmitter && StringUtils.isNotBlank((String)helpDeskEmail)) {
            return this.getHelpDeskPerson(context, helpDeskEmail);
        }
        return super.getRequestItemAuthor(context, item);
    }

    public RequestItemAuthor getHelpDeskPerson(Context context, String helpDeskEmail) throws SQLException {
        EPerson helpdeskEPerson = null;
        context.turnOffAuthorisationSystem();
        helpdeskEPerson = this.ePersonService.findByEmail(context, helpDeskEmail);
        context.restoreAuthSystemState();
        if (helpdeskEPerson != null) {
            return new RequestItemAuthor(helpdeskEPerson);
        }
        String helpdeskName = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemHelpdeskStrategy.helpdeskname", context);
        return new RequestItemAuthor(helpdeskName, helpDeskEmail);
    }
}

