/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;

public class LDAPAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(LDAPAuthentication.class);
    protected AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return ConfigurationManager.getBooleanProperty("authentication-ldap", "autoregister");
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) {
        try {
            String groupName;
            if (!context.getCurrentUser().getNetid().equals("") && (groupName = ConfigurationManager.getProperty("authentication-ldap", "login.specialgroup")) != null && !groupName.trim().equals("")) {
                Group ldapGroup = this.groupService.findByName(context, groupName);
                if (ldapGroup == null) {
                    log.warn((Object)LogManager.getHeader(context, "ldap_specialgroup", "Group defined in login.specialgroup does not exist"));
                    return ListUtils.EMPTY_LIST;
                }
                return Arrays.asList(ldapGroup);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ListUtils.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int authenticate(Context context, String netid, String password, String realm, HttpServletRequest request) throws SQLException {
        log.info((Object)LogManager.getHeader(context, "auth", "attempting trivial auth of user=" + netid));
        if (netid == null || password == null) {
            return 5;
        }
        EPerson eperson = null;
        try {
            eperson = this.ePersonService.findByNetid(context, netid.toLowerCase());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SpeakerToLDAP ldap = new SpeakerToLDAP(log);
        boolean anonymousSearch = ConfigurationManager.getBooleanProperty("authentication-ldap", "search.anonymous");
        String adminUser = ConfigurationManager.getProperty("authentication-ldap", "search.user");
        String adminPassword = ConfigurationManager.getProperty("authentication-ldap", "search.password");
        String objectContext = ConfigurationManager.getProperty("authentication-ldap", "object_context");
        String idField = ConfigurationManager.getProperty("authentication-ldap", "id_field");
        String dn = "";
        dn = (StringUtils.isBlank((String)adminUser) || StringUtils.isBlank((String)adminPassword)) && !anonymousSearch ? idField + "=" + netid + "," + objectContext : ldap.getDNOfUser(adminUser, adminPassword, context, netid);
        if (dn == null || dn.trim().equals("")) {
            log.info((Object)LogManager.getHeader(context, "failed_login", "no DN found for user " + netid));
            return 2;
        }
        if (eperson != null) {
            if (eperson.getRequireCertificate()) {
                return 3;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            if (ldap.ldapAuthenticate(dn, password, context)) {
                context.setCurrentUser(eperson);
                this.assignGroups(dn, ldap.ldapGroup, context);
                log.info((Object)LogManager.getHeader(context, "authenticate", "type=ldap"));
                return 1;
            }
            return 2;
        }
        if (ldap.ldapAuthenticate(dn, password, context)) {
            log.info((Object)LogManager.getHeader(context, "autoregister", "netid=" + netid));
            String email = ldap.ldapEmail;
            if (StringUtils.isEmpty((String)email)) {
                if (StringUtils.isNotEmpty((String)ConfigurationManager.getProperty("authentication-ldap", "netid_email_domain"))) {
                    email = netid + ConfigurationManager.getProperty("authentication-ldap", "netid_email_domain");
                } else {
                    log.warn((Object)LogManager.getHeader(context, "autoregister", "Unable to locate email address for account '" + netid + "', so it has been set to '" + netid + "'. Please check the LDAP 'email_field' OR consider configuring 'netid_email_domain'."));
                    email = netid;
                }
            }
            if (StringUtils.isNotEmpty((String)email)) {
                try {
                    eperson = this.ePersonService.findByEmail(context, email);
                    if (eperson != null) {
                        log.info((Object)LogManager.getHeader(context, "type=ldap-login", "type=ldap_but_already_email"));
                        context.turnOffAuthorisationSystem();
                        eperson.setNetid(netid.toLowerCase());
                        this.ePersonService.update(context, eperson);
                        context.dispatchEvents();
                        context.restoreAuthSystemState();
                        context.setCurrentUser(eperson);
                        this.assignGroups(dn, ldap.ldapGroup, context);
                        int n = 1;
                        return n;
                    }
                    if (this.canSelfRegister(context, request, netid)) {
                        try {
                            context.turnOffAuthorisationSystem();
                            eperson = this.ePersonService.create(context);
                            if (StringUtils.isNotEmpty((String)email)) {
                                eperson.setEmail(email);
                            }
                            if (StringUtils.isNotEmpty((String)ldap.ldapGivenName)) {
                                eperson.setFirstName(context, ldap.ldapGivenName);
                            }
                            if (StringUtils.isNotEmpty((String)ldap.ldapSurname)) {
                                eperson.setLastName(context, ldap.ldapSurname);
                            }
                            if (StringUtils.isNotEmpty((String)ldap.ldapPhone)) {
                                this.ePersonService.setMetadata(context, eperson, "phone", ldap.ldapPhone);
                            }
                            eperson.setNetid(netid.toLowerCase());
                            eperson.setCanLogIn(true);
                            this.authenticationService.initEPerson(context, request, eperson);
                            this.ePersonService.update(context, eperson);
                            context.dispatchEvents();
                            context.setCurrentUser(eperson);
                            this.assignGroups(dn, ldap.ldapGroup, context);
                        }
                        catch (AuthorizeException e) {
                            int n = 4;
                            return n;
                        }
                        finally {
                            context.restoreAuthSystemState();
                        }
                        log.info((Object)LogManager.getHeader(context, "authenticate", "type=ldap-login, created ePerson"));
                        int e = 1;
                        return e;
                    }
                    log.info((Object)LogManager.getHeader(context, "failed_login", "type=ldap_but_no_record"));
                    int e = 4;
                    return e;
                }
                catch (AuthorizeException e) {
                    eperson = null;
                }
                finally {
                    context.restoreAuthSystemState();
                }
            }
        }
        return 5;
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + "/ldap-login");
    }

    @Override
    public String loginPageTitle(Context context) {
        return "org.dspace.eperson.LDAPAuthentication.title";
    }

    private void assignGroups(String dn, String group, Context context) {
        if (StringUtils.isNotBlank((String)dn)) {
            System.out.println("dn:" + dn);
            int i = 1;
            String groupMap = ConfigurationManager.getProperty("authentication-ldap", "login.groupmap." + i);
            while (groupMap != null) {
                String[] t = groupMap.split(":");
                String ldapSearchString = t[0];
                String dspaceGroupName = t[1];
                boolean cmp = group == null ? StringUtils.containsIgnoreCase((String)dn, (String)(ldapSearchString + ",")) : StringUtils.equalsIgnoreCase((String)group, (String)ldapSearchString);
                if (cmp) {
                    try {
                        Group ldapGroup = this.groupService.findByName(context, dspaceGroupName);
                        if (ldapGroup != null) {
                            this.groupService.addMember(context, ldapGroup, context.getCurrentUser());
                            this.groupService.update(context, ldapGroup);
                        } else {
                            log.warn((Object)LogManager.getHeader(context, "ldap_assignGroupsBasedOnLdapDn", "Group defined in authentication-ldap.login.groupmap." + i + " does not exist :: " + dspaceGroupName));
                        }
                    }
                    catch (AuthorizeException ae) {
                        log.debug((Object)LogManager.getHeader(context, "assignGroupsBasedOnLdapDn could not authorize addition to group", dspaceGroupName));
                    }
                    catch (SQLException e) {
                        log.debug((Object)LogManager.getHeader(context, "assignGroupsBasedOnLdapDn could not find group", dspaceGroupName));
                    }
                }
                groupMap = ConfigurationManager.getProperty("authentication-ldap", "login.groupmap." + ++i);
            }
        }
    }

    private static class SpeakerToLDAP {
        private Logger log = null;
        protected String ldapEmail = null;
        protected String ldapGivenName = null;
        protected String ldapSurname = null;
        protected String ldapPhone = null;
        protected String ldapGroup = null;
        String ldap_provider_url = ConfigurationManager.getProperty("authentication-ldap", "provider_url");
        String ldap_id_field = ConfigurationManager.getProperty("authentication-ldap", "id_field");
        String ldap_search_context = ConfigurationManager.getProperty("authentication-ldap", "search_context");
        String ldap_search_scope = ConfigurationManager.getProperty("authentication-ldap", "search_scope");
        String ldap_email_field = ConfigurationManager.getProperty("authentication-ldap", "email_field");
        String ldap_givenname_field = ConfigurationManager.getProperty("authentication-ldap", "givenname_field");
        String ldap_surname_field = ConfigurationManager.getProperty("authentication-ldap", "surname_field");
        String ldap_phone_field = ConfigurationManager.getProperty("authentication-ldap", "phone_field");
        String ldap_group_field = ConfigurationManager.getProperty("authentication-ldap", "login.groupmap.attribute");
        boolean useTLS = ConfigurationManager.getBooleanProperty("authentication-ldap", "starttls", false);

        SpeakerToLDAP(Logger thelog) {
            this.log = thelog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getDNOfUser(String adminUser, String adminPassword, Context context, String netid) {
            int ldap_search_scope_value;
            block32: {
                ldap_search_scope_value = 0;
                try {
                    ldap_search_scope_value = Integer.parseInt(this.ldap_search_scope.trim());
                }
                catch (NumberFormatException e) {
                    if (this.ldap_search_scope == null) break block32;
                    this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "invalid search scope: " + this.ldap_search_scope));
                }
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.ldap_provider_url);
            javax.naming.Context ctx = null;
            StartTlsResponse startTLSResponse = null;
            try {
                if (adminUser != null && !adminUser.trim().equals("") && adminPassword != null && !adminPassword.trim().equals("")) {
                    if (this.useTLS) {
                        ctx = new InitialLdapContext(env, null);
                        startTLSResponse = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                        startTLSResponse.negotiate();
                        ctx.addToEnvironment("java.naming.security.authentication", "simple");
                        ctx.addToEnvironment("java.naming.security.principal", adminUser);
                        ctx.addToEnvironment("java.naming.security.credentials", adminPassword);
                    } else {
                        env.put("java.naming.security.authentication", "simple");
                        env.put("java.naming.security.principal", adminUser);
                        env.put("java.naming.security.credentials", adminPassword);
                    }
                } else {
                    env.put("java.naming.security.authentication", "none");
                }
                if (ctx == null) {
                    ctx = new InitialLdapContext(env, null);
                }
                BasicAttributes matchAttrs = new BasicAttributes(true);
                matchAttrs.put(new BasicAttribute(this.ldap_id_field, netid));
                try {
                    String resultDN;
                    SearchControls ctrls = new SearchControls();
                    ctrls.setSearchScope(ldap_search_scope_value);
                    String searchName = "";
                    searchName = this.useTLS ? this.ldap_search_context : this.ldap_provider_url + this.ldap_search_context;
                    NamingEnumeration<SearchResult> answer = ctx.search(searchName, "(&({0}={1}))", new Object[]{this.ldap_id_field, netid}, ctrls);
                    do {
                        Attribute att;
                        if (!answer.hasMoreElements()) return null;
                        SearchResult sr = answer.next();
                        resultDN = StringUtils.isEmpty((String)this.ldap_search_context) ? sr.getName() : sr.getName() + "," + this.ldap_search_context;
                        String[] attlist = new String[]{this.ldap_email_field, this.ldap_givenname_field, this.ldap_surname_field, this.ldap_phone_field, this.ldap_group_field};
                        Attributes atts = sr.getAttributes();
                        if (attlist[0] != null && (att = atts.get(attlist[0])) != null) {
                            this.ldapEmail = (String)att.get();
                        }
                        if (attlist[1] != null && (att = atts.get(attlist[1])) != null) {
                            this.ldapGivenName = (String)att.get();
                        }
                        if (attlist[2] != null && (att = atts.get(attlist[2])) != null) {
                            this.ldapSurname = (String)att.get();
                        }
                        if (attlist[3] != null && (att = atts.get(attlist[3])) != null) {
                            this.ldapPhone = (String)att.get();
                        }
                        if (attlist[4] == null || (att = atts.get(attlist[4])) == null) continue;
                        this.ldapGroup = (String)att.get();
                    } while (answer.hasMoreElements());
                    this.log.debug((Object)LogManager.getHeader(context, "got DN", resultDN));
                    String string = resultDN;
                    return string;
                }
                catch (NamingException e) {
                    this.log.warn((Object)LogManager.getHeader(context, "ldap_attribute_lookup", "type=failed_search " + e));
                    return null;
                }
            }
            catch (IOException | NamingException e) {
                this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "type=failed_auth " + e));
                return null;
            }
            finally {
                try {
                    if (startTLSResponse != null) {
                        startTLSResponse.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (IOException | NamingException exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean ldapAuthenticate(String netid, String password, Context context) {
            if (password.equals("")) return false;
            InitialLdapContext ctx = null;
            StartTlsResponse startTLSResponse = null;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.ldap_provider_url);
            try {
                if (this.useTLS) {
                    ctx = new InitialLdapContext(env, null);
                    startTLSResponse = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                    startTLSResponse.negotiate();
                    ctx.addToEnvironment("java.naming.security.authentication", "simple");
                    ctx.addToEnvironment("java.naming.security.principal", netid);
                    ctx.addToEnvironment("java.naming.security.credentials", password);
                    ctx.addToEnvironment("java.naming.authoritative", "true");
                    ctx.addToEnvironment("java.naming.referral", "follow");
                    ctx.getAttributes("");
                    return true;
                } else {
                    if (this.useTLS) return true;
                    env.put("java.naming.security.authentication", "Simple");
                    env.put("java.naming.security.principal", netid);
                    env.put("java.naming.security.credentials", password);
                    env.put("java.naming.authoritative", "true");
                    env.put("java.naming.referral", "follow");
                    ctx = new InitialLdapContext(env, null);
                }
                return true;
            }
            catch (IOException | NamingException e) {
                this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "type=failed_auth " + e));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (startTLSResponse != null) {
                        startTLSResponse.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (IOException | NamingException exception) {}
            }
        }
    }
}

