/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import org.apache.log4j.Logger;
import org.dspace.checker.factory.CheckerServiceFactory;
import org.dspace.checker.service.ChecksumHistoryService;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class CheckerConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(CheckerConsumer.class);
    protected ChecksumHistoryService checksumHistoryService = CheckerServiceFactory.getInstance().getChecksumHistoryService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        if (event.getEventType() == 32) {
            Bitstream bitstream = (Bitstream)this.bitstreamService.find(ctx, event.getSubjectID());
            log.debug((Object)"Attempting to remove Checker Info");
            this.checksumHistoryService.deleteByBitstream(ctx, bitstream);
            log.debug((Object)"Completed removing Checker Info");
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

