/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.ChecksumResult;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.dao.MostRecentChecksumDAO;
import org.dspace.checker.service.ChecksumResultService;
import org.dspace.checker.service.MostRecentChecksumService;
import org.dspace.content.Bitstream;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class MostRecentChecksumServiceImpl
implements MostRecentChecksumService {
    private static final Logger log = Logger.getLogger(MostRecentChecksumServiceImpl.class);
    @Autowired(required=true)
    protected MostRecentChecksumDAO mostRecentChecksumDAO;
    @Autowired(required=true)
    protected ChecksumResultService checksumResultService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;

    protected MostRecentChecksumServiceImpl() {
    }

    @Override
    public MostRecentChecksum getNonPersistedObject() {
        return new MostRecentChecksum();
    }

    @Override
    public MostRecentChecksum findByBitstream(Context context, Bitstream bitstream) throws SQLException {
        return this.mostRecentChecksumDAO.findByBitstream(context, bitstream);
    }

    @Override
    public List<MostRecentChecksum> findNotProcessedBitstreamsReport(Context context, Date startDate, Date endDate) throws SQLException {
        return this.mostRecentChecksumDAO.findByNotProcessedInDateRange(context, startDate, endDate);
    }

    @Override
    public List<MostRecentChecksum> findBitstreamResultTypeReport(Context context, Date startDate, Date endDate, ChecksumResultCode resultCode) throws SQLException {
        return this.mostRecentChecksumDAO.findByResultTypeInDateRange(context, startDate, endDate, resultCode);
    }

    @Override
    public void updateMissingBitstreams(Context context) throws SQLException {
        List<Bitstream> unknownBitstreams = this.bitstreamService.findBitstreamsWithNoRecentChecksum(context);
        for (Bitstream bitstream : unknownBitstreams) {
            log.info((Object)(bitstream + " " + bitstream.getID().toString() + " " + bitstream.getName()));
            MostRecentChecksum mostRecentChecksum = new MostRecentChecksum();
            mostRecentChecksum.setBitstream(bitstream);
            mostRecentChecksum.setToBeProcessed(!bitstream.isDeleted());
            if (bitstream.getChecksum() == null) {
                mostRecentChecksum.setCurrentChecksum("");
                mostRecentChecksum.setExpectedChecksum("");
            } else {
                mostRecentChecksum.setCurrentChecksum(bitstream.getChecksum());
                mostRecentChecksum.setExpectedChecksum(bitstream.getChecksum());
            }
            mostRecentChecksum.setProcessStartDate(new Date());
            mostRecentChecksum.setProcessEndDate(new Date());
            if (bitstream.getChecksumAlgorithm() == null) {
                mostRecentChecksum.setChecksumAlgorithm("MD5");
            } else {
                mostRecentChecksum.setChecksumAlgorithm(bitstream.getChecksumAlgorithm());
            }
            mostRecentChecksum.setMatchedPrevChecksum(true);
            ChecksumResult checksumResult = bitstream.isDeleted() ? this.checksumResultService.findByCode(context, ChecksumResultCode.BITSTREAM_MARKED_DELETED) : this.checksumResultService.findByCode(context, ChecksumResultCode.CHECKSUM_MATCH);
            mostRecentChecksum.setChecksumResult(checksumResult);
            this.mostRecentChecksumDAO.create(context, mostRecentChecksum);
            this.mostRecentChecksumDAO.save(context, mostRecentChecksum);
        }
    }

    @Override
    public void deleteByBitstream(Context context, Bitstream bitstream) throws SQLException {
        this.mostRecentChecksumDAO.deleteByBitstream(context, bitstream);
    }

    @Override
    public MostRecentChecksum findOldestRecord(Context context) throws SQLException {
        return this.mostRecentChecksumDAO.getOldestRecord(context);
    }

    @Override
    public MostRecentChecksum findOldestRecord(Context context, Date lessThanDate) throws SQLException {
        return this.mostRecentChecksumDAO.getOldestRecord(context, lessThanDate);
    }

    @Override
    public List<MostRecentChecksum> findNotInHistory(Context context) throws SQLException {
        return this.mostRecentChecksumDAO.findNotInHistory(context);
    }

    @Override
    public void update(Context context, MostRecentChecksum mostRecentChecksum) throws SQLException {
        this.mostRecentChecksumDAO.save(context, mostRecentChecksum);
    }
}

