/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.eperson.Group;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="community")
public class Community
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    private static final Logger log = Logger.getLogger(Community.class);
    @Column(name="community_id", insertable=false, updatable=false)
    private Integer legacyId;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="community2community", joinColumns={@JoinColumn(name="parent_comm_id")}, inverseJoinColumns={@JoinColumn(name="child_comm_id")})
    private final List<Community> subCommunities = new ArrayList<Community>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="subCommunities")
    private List<Community> parentCommunities = new ArrayList<Community>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="communities", cascade={CascadeType.PERSIST})
    private final List<Collection> collections = new ArrayList<Collection>();
    @OneToOne
    @JoinColumn(name="admin")
    private Group admins;
    @OneToOne
    @JoinColumn(name="logo_bitstream_id")
    private Bitstream logo = null;
    public static final String COPYRIGHT_TEXT = "copyright_text";
    public static final String INTRODUCTORY_TEXT = "introductory_text";
    public static final String SHORT_DESCRIPTION = "short_description";
    public static final String SIDEBAR_TEXT = "side_bar_text";
    @Transient
    protected transient CommunityService communityService;

    protected Community() {
    }

    void addSubCommunity(Community subCommunity) {
        this.getSubcommunities().add(subCommunity);
        this.setModified();
    }

    void removeSubCommunity(Community subCommunity) {
        this.getSubcommunities().remove(subCommunity);
        this.setModified();
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    void setLogo(Bitstream logo) {
        this.logo = logo;
        this.setModified();
    }

    public Group getAdministrators() {
        return this.admins;
    }

    void setAdmins(Group admins) {
        this.admins = admins;
        this.setModified();
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    void addCollection(Collection collection) {
        this.getCollections().add(collection);
    }

    void removeCollection(Collection collection) {
        this.getCollections().remove(collection);
    }

    public List<Community> getSubcommunities() {
        return this.subCommunities;
    }

    public List<Community> getParentCommunities() {
        return this.parentCommunities;
    }

    void addParentCommunity(Community parentCommunity) {
        this.getParentCommunities().add(parentCommunity);
    }

    void clearParentCommunities() {
        this.parentCommunities.clear();
        this.parentCommunities = null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)other);
        if (this.getClass() != objClass) {
            return false;
        }
        Community otherCommunity = (Community)other;
        return this.getID().equals(otherCommunity.getID());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getID()).toHashCode();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String getName() {
        String value = this.getCommunityService().getMetadataFirstValue(this, "dc", "title", null, "*");
        return value == null ? "" : value;
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    private CommunityService getCommunityService() {
        if (this.communityService == null) {
            this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        }
        return this.communityService;
    }
}

